# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseFleetBackupMetrics(object):
    """
    The details of the backup metrics for the fleet of databases.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseFleetBackupMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param backup_metrics:
            The value to assign to the backup_metrics property of this DatabaseFleetBackupMetrics.
        :type backup_metrics: list[oci.database_management.models.DatabaseBackupMetrics]

        """
        self.swagger_types = {
            'backup_metrics': 'list[DatabaseBackupMetrics]'
        }
        self.attribute_map = {
            'backup_metrics': 'backupMetrics'
        }
        self._backup_metrics = None

    @property
    def backup_metrics(self):
        """
        **[Required]** Gets the backup_metrics of this DatabaseFleetBackupMetrics.
        A list of backup metrics for the databases present in the fleet.


        :return: The backup_metrics of this DatabaseFleetBackupMetrics.
        :rtype: list[oci.database_management.models.DatabaseBackupMetrics]
        """
        return self._backup_metrics

    @backup_metrics.setter
    def backup_metrics(self, backup_metrics):
        """
        Sets the backup_metrics of this DatabaseFleetBackupMetrics.
        A list of backup metrics for the databases present in the fleet.


        :param backup_metrics: The backup_metrics of this DatabaseFleetBackupMetrics.
        :type: list[oci.database_management.models.DatabaseBackupMetrics]
        """
        self._backup_metrics = backup_metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
