# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseHaBackupDetails(object):
    """
    The database HA and backup details.
    """

    #: A constant which can be used with the database_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "EXTERNAL_SIDB"
    DATABASE_TYPE_EXTERNAL_SIDB = "EXTERNAL_SIDB"

    #: A constant which can be used with the database_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "EXTERNAL_RAC"
    DATABASE_TYPE_EXTERNAL_RAC = "EXTERNAL_RAC"

    #: A constant which can be used with the database_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "CLOUD_SIDB"
    DATABASE_TYPE_CLOUD_SIDB = "CLOUD_SIDB"

    #: A constant which can be used with the database_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "CLOUD_RAC"
    DATABASE_TYPE_CLOUD_RAC = "CLOUD_RAC"

    #: A constant which can be used with the database_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "SHARED"
    DATABASE_TYPE_SHARED = "SHARED"

    #: A constant which can be used with the database_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "DEDICATED"
    DATABASE_TYPE_DEDICATED = "DEDICATED"

    #: A constant which can be used with the database_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "CLOUD_AT_CUSTOMER"
    DATABASE_TYPE_CLOUD_AT_CUSTOMER = "CLOUD_AT_CUSTOMER"

    #: A constant which can be used with the database_sub_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "CDB"
    DATABASE_SUB_TYPE_CDB = "CDB"

    #: A constant which can be used with the database_sub_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "PDB"
    DATABASE_SUB_TYPE_PDB = "PDB"

    #: A constant which can be used with the database_sub_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "NON_CDB"
    DATABASE_SUB_TYPE_NON_CDB = "NON_CDB"

    #: A constant which can be used with the database_sub_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "ACD"
    DATABASE_SUB_TYPE_ACD = "ACD"

    #: A constant which can be used with the database_sub_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "ADB"
    DATABASE_SUB_TYPE_ADB = "ADB"

    #: A constant which can be used with the deployment_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "ONPREMISE"
    DEPLOYMENT_TYPE_ONPREMISE = "ONPREMISE"

    #: A constant which can be used with the deployment_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "BM"
    DEPLOYMENT_TYPE_BM = "BM"

    #: A constant which can be used with the deployment_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "VM"
    DEPLOYMENT_TYPE_VM = "VM"

    #: A constant which can be used with the deployment_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "EXADATA"
    DEPLOYMENT_TYPE_EXADATA = "EXADATA"

    #: A constant which can be used with the deployment_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "EXADATA_CC"
    DEPLOYMENT_TYPE_EXADATA_CC = "EXADATA_CC"

    #: A constant which can be used with the deployment_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "AUTONOMOUS"
    DEPLOYMENT_TYPE_AUTONOMOUS = "AUTONOMOUS"

    #: A constant which can be used with the deployment_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "EXADATA_XS"
    DEPLOYMENT_TYPE_EXADATA_XS = "EXADATA_XS"

    #: A constant which can be used with the workload_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "OLTP"
    WORKLOAD_TYPE_OLTP = "OLTP"

    #: A constant which can be used with the workload_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "DW"
    WORKLOAD_TYPE_DW = "DW"

    #: A constant which can be used with the workload_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "AJD"
    WORKLOAD_TYPE_AJD = "AJD"

    #: A constant which can be used with the workload_type property of a DatabaseHaBackupDetails.
    #: This constant has a value of "APEX"
    WORKLOAD_TYPE_APEX = "APEX"

    #: A constant which can be used with the db_role property of a DatabaseHaBackupDetails.
    #: This constant has a value of "SNAPSHOT_STANDBY"
    DB_ROLE_SNAPSHOT_STANDBY = "SNAPSHOT_STANDBY"

    #: A constant which can be used with the db_role property of a DatabaseHaBackupDetails.
    #: This constant has a value of "LOGICAL_STANDBY"
    DB_ROLE_LOGICAL_STANDBY = "LOGICAL_STANDBY"

    #: A constant which can be used with the db_role property of a DatabaseHaBackupDetails.
    #: This constant has a value of "PHYSICAL_STANDBY"
    DB_ROLE_PHYSICAL_STANDBY = "PHYSICAL_STANDBY"

    #: A constant which can be used with the db_role property of a DatabaseHaBackupDetails.
    #: This constant has a value of "PRIMARY"
    DB_ROLE_PRIMARY = "PRIMARY"

    #: A constant which can be used with the db_role property of a DatabaseHaBackupDetails.
    #: This constant has a value of "FAR_SYNC"
    DB_ROLE_FAR_SYNC = "FAR_SYNC"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseHaBackupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param flash_back_on:
            The value to assign to the flash_back_on property of this DatabaseHaBackupDetails.
        :type flash_back_on: str

        :param flash_back_time:
            The value to assign to the flash_back_time property of this DatabaseHaBackupDetails.
        :type flash_back_time: datetime

        :param recovery_window_goal_in_days:
            The value to assign to the recovery_window_goal_in_days property of this DatabaseHaBackupDetails.
        :type recovery_window_goal_in_days: int

        :param last_full_backup_summary:
            The value to assign to the last_full_backup_summary property of this DatabaseHaBackupDetails.
        :type last_full_backup_summary: oci.database_management.models.DatabaseBackupSummary

        :param backup_history:
            The value to assign to the backup_history property of this DatabaseHaBackupDetails.
        :type backup_history: list[oci.database_management.models.DatabaseBackupSummary]

        :param metrics:
            The value to assign to the metrics property of this DatabaseHaBackupDetails.
        :type metrics: list[oci.database_management.models.HaMetricDefinition]

        :param db_id:
            The value to assign to the db_id property of this DatabaseHaBackupDetails.
        :type db_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DatabaseHaBackupDetails.
        :type compartment_id: str

        :param database_type:
            The value to assign to the database_type property of this DatabaseHaBackupDetails.
            Allowed values for this property are: "EXTERNAL_SIDB", "EXTERNAL_RAC", "CLOUD_SIDB", "CLOUD_RAC", "SHARED", "DEDICATED", "CLOUD_AT_CUSTOMER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_type: str

        :param database_sub_type:
            The value to assign to the database_sub_type property of this DatabaseHaBackupDetails.
            Allowed values for this property are: "CDB", "PDB", "NON_CDB", "ACD", "ADB", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_sub_type: str

        :param deployment_type:
            The value to assign to the deployment_type property of this DatabaseHaBackupDetails.
            Allowed values for this property are: "ONPREMISE", "BM", "VM", "EXADATA", "EXADATA_CC", "AUTONOMOUS", "EXADATA_XS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deployment_type: str

        :param database_version:
            The value to assign to the database_version property of this DatabaseHaBackupDetails.
        :type database_version: str

        :param workload_type:
            The value to assign to the workload_type property of this DatabaseHaBackupDetails.
            Allowed values for this property are: "OLTP", "DW", "AJD", "APEX", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type workload_type: str

        :param database_name:
            The value to assign to the database_name property of this DatabaseHaBackupDetails.
        :type database_name: str

        :param database_id:
            The value to assign to the database_id property of this DatabaseHaBackupDetails.
        :type database_id: str

        :param db_unique_name:
            The value to assign to the db_unique_name property of this DatabaseHaBackupDetails.
        :type db_unique_name: str

        :param db_role:
            The value to assign to the db_role property of this DatabaseHaBackupDetails.
            Allowed values for this property are: "SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type db_role: str

        """
        self.swagger_types = {
            'flash_back_on': 'str',
            'flash_back_time': 'datetime',
            'recovery_window_goal_in_days': 'int',
            'last_full_backup_summary': 'DatabaseBackupSummary',
            'backup_history': 'list[DatabaseBackupSummary]',
            'metrics': 'list[HaMetricDefinition]',
            'db_id': 'str',
            'compartment_id': 'str',
            'database_type': 'str',
            'database_sub_type': 'str',
            'deployment_type': 'str',
            'database_version': 'str',
            'workload_type': 'str',
            'database_name': 'str',
            'database_id': 'str',
            'db_unique_name': 'str',
            'db_role': 'str'
        }
        self.attribute_map = {
            'flash_back_on': 'flashBackOn',
            'flash_back_time': 'flashBackTime',
            'recovery_window_goal_in_days': 'recoveryWindowGoalInDays',
            'last_full_backup_summary': 'lastFullBackupSummary',
            'backup_history': 'backupHistory',
            'metrics': 'metrics',
            'db_id': 'dbId',
            'compartment_id': 'compartmentId',
            'database_type': 'databaseType',
            'database_sub_type': 'databaseSubType',
            'deployment_type': 'deploymentType',
            'database_version': 'databaseVersion',
            'workload_type': 'workloadType',
            'database_name': 'databaseName',
            'database_id': 'databaseId',
            'db_unique_name': 'dbUniqueName',
            'db_role': 'dbRole'
        }
        self._flash_back_on = None
        self._flash_back_time = None
        self._recovery_window_goal_in_days = None
        self._last_full_backup_summary = None
        self._backup_history = None
        self._metrics = None
        self._db_id = None
        self._compartment_id = None
        self._database_type = None
        self._database_sub_type = None
        self._deployment_type = None
        self._database_version = None
        self._workload_type = None
        self._database_name = None
        self._database_id = None
        self._db_unique_name = None
        self._db_role = None

    @property
    def flash_back_on(self):
        """
        Gets the flash_back_on of this DatabaseHaBackupDetails.
        Indicates whether flashback is enabled for the database.


        :return: The flash_back_on of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._flash_back_on

    @flash_back_on.setter
    def flash_back_on(self, flash_back_on):
        """
        Sets the flash_back_on of this DatabaseHaBackupDetails.
        Indicates whether flashback is enabled for the database.


        :param flash_back_on: The flash_back_on of this DatabaseHaBackupDetails.
        :type: str
        """
        self._flash_back_on = flash_back_on

    @property
    def flash_back_time(self):
        """
        Gets the flash_back_time of this DatabaseHaBackupDetails.
        The oldest flashback date and time in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".


        :return: The flash_back_time of this DatabaseHaBackupDetails.
        :rtype: datetime
        """
        return self._flash_back_time

    @flash_back_time.setter
    def flash_back_time(self, flash_back_time):
        """
        Sets the flash_back_time of this DatabaseHaBackupDetails.
        The oldest flashback date and time in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".


        :param flash_back_time: The flash_back_time of this DatabaseHaBackupDetails.
        :type: datetime
        """
        self._flash_back_time = flash_back_time

    @property
    def recovery_window_goal_in_days(self):
        """
        Gets the recovery_window_goal_in_days of this DatabaseHaBackupDetails.
        The configured number of days intended to recover a protected database from a backup.


        :return: The recovery_window_goal_in_days of this DatabaseHaBackupDetails.
        :rtype: int
        """
        return self._recovery_window_goal_in_days

    @recovery_window_goal_in_days.setter
    def recovery_window_goal_in_days(self, recovery_window_goal_in_days):
        """
        Sets the recovery_window_goal_in_days of this DatabaseHaBackupDetails.
        The configured number of days intended to recover a protected database from a backup.


        :param recovery_window_goal_in_days: The recovery_window_goal_in_days of this DatabaseHaBackupDetails.
        :type: int
        """
        self._recovery_window_goal_in_days = recovery_window_goal_in_days

    @property
    def last_full_backup_summary(self):
        """
        Gets the last_full_backup_summary of this DatabaseHaBackupDetails.

        :return: The last_full_backup_summary of this DatabaseHaBackupDetails.
        :rtype: oci.database_management.models.DatabaseBackupSummary
        """
        return self._last_full_backup_summary

    @last_full_backup_summary.setter
    def last_full_backup_summary(self, last_full_backup_summary):
        """
        Sets the last_full_backup_summary of this DatabaseHaBackupDetails.

        :param last_full_backup_summary: The last_full_backup_summary of this DatabaseHaBackupDetails.
        :type: oci.database_management.models.DatabaseBackupSummary
        """
        self._last_full_backup_summary = last_full_backup_summary

    @property
    def backup_history(self):
        """
        Gets the backup_history of this DatabaseHaBackupDetails.
        A list of database backups.


        :return: The backup_history of this DatabaseHaBackupDetails.
        :rtype: list[oci.database_management.models.DatabaseBackupSummary]
        """
        return self._backup_history

    @backup_history.setter
    def backup_history(self, backup_history):
        """
        Sets the backup_history of this DatabaseHaBackupDetails.
        A list of database backups.


        :param backup_history: The backup_history of this DatabaseHaBackupDetails.
        :type: list[oci.database_management.models.DatabaseBackupSummary]
        """
        self._backup_history = backup_history

    @property
    def metrics(self):
        """
        Gets the metrics of this DatabaseHaBackupDetails.
        A list of database backup metrics such as BackupSize and BackupDuration.


        :return: The metrics of this DatabaseHaBackupDetails.
        :rtype: list[oci.database_management.models.HaMetricDefinition]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this DatabaseHaBackupDetails.
        A list of database backup metrics such as BackupSize and BackupDuration.


        :param metrics: The metrics of this DatabaseHaBackupDetails.
        :type: list[oci.database_management.models.HaMetricDefinition]
        """
        self._metrics = metrics

    @property
    def db_id(self):
        """
        **[Required]** Gets the db_id of this DatabaseHaBackupDetails.
        The `OCID`__ of the Managed Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_id of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._db_id

    @db_id.setter
    def db_id(self, db_id):
        """
        Sets the db_id of this DatabaseHaBackupDetails.
        The `OCID`__ of the Managed Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_id: The db_id of this DatabaseHaBackupDetails.
        :type: str
        """
        self._db_id = db_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DatabaseHaBackupDetails.
        The `OCID`__ of the compartment where the Managed Database resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DatabaseHaBackupDetails.
        The `OCID`__ of the compartment where the Managed Database resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DatabaseHaBackupDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def database_type(self):
        """
        **[Required]** Gets the database_type of this DatabaseHaBackupDetails.
        The type of Oracle Database installation.

        Allowed values for this property are: "EXTERNAL_SIDB", "EXTERNAL_RAC", "CLOUD_SIDB", "CLOUD_RAC", "SHARED", "DEDICATED", "CLOUD_AT_CUSTOMER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_type of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._database_type

    @database_type.setter
    def database_type(self, database_type):
        """
        Sets the database_type of this DatabaseHaBackupDetails.
        The type of Oracle Database installation.


        :param database_type: The database_type of this DatabaseHaBackupDetails.
        :type: str
        """
        allowed_values = ["EXTERNAL_SIDB", "EXTERNAL_RAC", "CLOUD_SIDB", "CLOUD_RAC", "SHARED", "DEDICATED", "CLOUD_AT_CUSTOMER"]
        if not value_allowed_none_or_none_sentinel(database_type, allowed_values):
            database_type = 'UNKNOWN_ENUM_VALUE'
        self._database_type = database_type

    @property
    def database_sub_type(self):
        """
        **[Required]** Gets the database_sub_type of this DatabaseHaBackupDetails.
        The subtype of the Oracle Database. Indicates whether the database is a Container Database,
        Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.

        Allowed values for this property are: "CDB", "PDB", "NON_CDB", "ACD", "ADB", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_sub_type of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._database_sub_type

    @database_sub_type.setter
    def database_sub_type(self, database_sub_type):
        """
        Sets the database_sub_type of this DatabaseHaBackupDetails.
        The subtype of the Oracle Database. Indicates whether the database is a Container Database,
        Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.


        :param database_sub_type: The database_sub_type of this DatabaseHaBackupDetails.
        :type: str
        """
        allowed_values = ["CDB", "PDB", "NON_CDB", "ACD", "ADB"]
        if not value_allowed_none_or_none_sentinel(database_sub_type, allowed_values):
            database_sub_type = 'UNKNOWN_ENUM_VALUE'
        self._database_sub_type = database_sub_type

    @property
    def deployment_type(self):
        """
        **[Required]** Gets the deployment_type of this DatabaseHaBackupDetails.
        The infrastructure used to deploy the Oracle Database.

        Allowed values for this property are: "ONPREMISE", "BM", "VM", "EXADATA", "EXADATA_CC", "AUTONOMOUS", "EXADATA_XS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deployment_type of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this DatabaseHaBackupDetails.
        The infrastructure used to deploy the Oracle Database.


        :param deployment_type: The deployment_type of this DatabaseHaBackupDetails.
        :type: str
        """
        allowed_values = ["ONPREMISE", "BM", "VM", "EXADATA", "EXADATA_CC", "AUTONOMOUS", "EXADATA_XS"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            deployment_type = 'UNKNOWN_ENUM_VALUE'
        self._deployment_type = deployment_type

    @property
    def database_version(self):
        """
        Gets the database_version of this DatabaseHaBackupDetails.
        The Oracle Database version.


        :return: The database_version of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._database_version

    @database_version.setter
    def database_version(self, database_version):
        """
        Sets the database_version of this DatabaseHaBackupDetails.
        The Oracle Database version.


        :param database_version: The database_version of this DatabaseHaBackupDetails.
        :type: str
        """
        self._database_version = database_version

    @property
    def workload_type(self):
        """
        Gets the workload_type of this DatabaseHaBackupDetails.
        The workload type of the Autonomous Database.

        Allowed values for this property are: "OLTP", "DW", "AJD", "APEX", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The workload_type of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._workload_type

    @workload_type.setter
    def workload_type(self, workload_type):
        """
        Sets the workload_type of this DatabaseHaBackupDetails.
        The workload type of the Autonomous Database.


        :param workload_type: The workload_type of this DatabaseHaBackupDetails.
        :type: str
        """
        allowed_values = ["OLTP", "DW", "AJD", "APEX"]
        if not value_allowed_none_or_none_sentinel(workload_type, allowed_values):
            workload_type = 'UNKNOWN_ENUM_VALUE'
        self._workload_type = workload_type

    @property
    def database_name(self):
        """
        **[Required]** Gets the database_name of this DatabaseHaBackupDetails.
        The display name of the Managed Database.


        :return: The database_name of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._database_name

    @database_name.setter
    def database_name(self, database_name):
        """
        Sets the database_name of this DatabaseHaBackupDetails.
        The display name of the Managed Database.


        :param database_name: The database_name of this DatabaseHaBackupDetails.
        :type: str
        """
        self._database_name = database_name

    @property
    def database_id(self):
        """
        Gets the database_id of this DatabaseHaBackupDetails.
        The database ID of the Managed Database. Every database had its own ID and that value is captured here.


        :return: The database_id of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this DatabaseHaBackupDetails.
        The database ID of the Managed Database. Every database had its own ID and that value is captured here.


        :param database_id: The database_id of this DatabaseHaBackupDetails.
        :type: str
        """
        self._database_id = database_id

    @property
    def db_unique_name(self):
        """
        Gets the db_unique_name of this DatabaseHaBackupDetails.
        The database unique name of the Managed Database.


        :return: The db_unique_name of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._db_unique_name

    @db_unique_name.setter
    def db_unique_name(self, db_unique_name):
        """
        Sets the db_unique_name of this DatabaseHaBackupDetails.
        The database unique name of the Managed Database.


        :param db_unique_name: The db_unique_name of this DatabaseHaBackupDetails.
        :type: str
        """
        self._db_unique_name = db_unique_name

    @property
    def db_role(self):
        """
        **[Required]** Gets the db_role of this DatabaseHaBackupDetails.
        The database role of the Managed Database.

        Allowed values for this property are: "SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The db_role of this DatabaseHaBackupDetails.
        :rtype: str
        """
        return self._db_role

    @db_role.setter
    def db_role(self, db_role):
        """
        Sets the db_role of this DatabaseHaBackupDetails.
        The database role of the Managed Database.


        :param db_role: The db_role of this DatabaseHaBackupDetails.
        :type: str
        """
        allowed_values = ["SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC"]
        if not value_allowed_none_or_none_sentinel(db_role, allowed_values):
            db_role = 'UNKNOWN_ENUM_VALUE'
        self._db_role = db_role

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
