# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .discovered_cloud_db_system_component import DiscoveredCloudDbSystemComponent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DiscoveredCloudAsm(DiscoveredCloudDbSystemComponent):
    """
    The details of an ASM discovered in a cloud DB system discovery run.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DiscoveredCloudAsm object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.DiscoveredCloudAsm.component_type` attribute
        of this class is ``ASM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_id:
            The value to assign to the component_id property of this DiscoveredCloudAsm.
        :type component_id: str

        :param display_name:
            The value to assign to the display_name property of this DiscoveredCloudAsm.
        :type display_name: str

        :param component_name:
            The value to assign to the component_name property of this DiscoveredCloudAsm.
        :type component_name: str

        :param component_type:
            The value to assign to the component_type property of this DiscoveredCloudAsm.
            Allowed values for this property are: "ASM", "ASM_INSTANCE", "CLUSTER", "CLUSTER_INSTANCE", "DATABASE", "DATABASE_INSTANCE", "DATABASE_HOME", "DATABASE_NODE", "DBSYSTEM", "LISTENER", "PLUGGABLE_DATABASE"
        :type component_type: str

        :param resource_id:
            The value to assign to the resource_id property of this DiscoveredCloudAsm.
        :type resource_id: str

        :param dbaas_id:
            The value to assign to the dbaas_id property of this DiscoveredCloudAsm.
        :type dbaas_id: str

        :param is_selected_for_monitoring:
            The value to assign to the is_selected_for_monitoring property of this DiscoveredCloudAsm.
        :type is_selected_for_monitoring: bool

        :param status:
            The value to assign to the status property of this DiscoveredCloudAsm.
            Allowed values for this property are: "NEW", "EXISTING", "EXISTING_BASIC", "EXISTING_PE", "EXISTING_BASIC_PE", "MARKED_FOR_UPGRADE", "MARKED_FOR_MIGRATION", "MARKED_FOR_UPGRADE_MIGRATION", "MARKED_FOR_DELETION", "UNKNOWN"
        :type status: str

        :param associated_components:
            The value to assign to the associated_components property of this DiscoveredCloudAsm.
        :type associated_components: list[oci.database_management.models.AssociatedCloudComponent]

        :param grid_home:
            The value to assign to the grid_home property of this DiscoveredCloudAsm.
        :type grid_home: str

        :param is_flex_enabled:
            The value to assign to the is_flex_enabled property of this DiscoveredCloudAsm.
        :type is_flex_enabled: bool

        :param version:
            The value to assign to the version property of this DiscoveredCloudAsm.
        :type version: str

        :param asm_instances:
            The value to assign to the asm_instances property of this DiscoveredCloudAsm.
        :type asm_instances: list[oci.database_management.models.DiscoveredCloudAsmInstance]

        :param connector:
            The value to assign to the connector property of this DiscoveredCloudAsm.
        :type connector: oci.database_management.models.CloudDbSystemDiscoveryConnector

        """
        self.swagger_types = {
            'component_id': 'str',
            'display_name': 'str',
            'component_name': 'str',
            'component_type': 'str',
            'resource_id': 'str',
            'dbaas_id': 'str',
            'is_selected_for_monitoring': 'bool',
            'status': 'str',
            'associated_components': 'list[AssociatedCloudComponent]',
            'grid_home': 'str',
            'is_flex_enabled': 'bool',
            'version': 'str',
            'asm_instances': 'list[DiscoveredCloudAsmInstance]',
            'connector': 'CloudDbSystemDiscoveryConnector'
        }
        self.attribute_map = {
            'component_id': 'componentId',
            'display_name': 'displayName',
            'component_name': 'componentName',
            'component_type': 'componentType',
            'resource_id': 'resourceId',
            'dbaas_id': 'dbaasId',
            'is_selected_for_monitoring': 'isSelectedForMonitoring',
            'status': 'status',
            'associated_components': 'associatedComponents',
            'grid_home': 'gridHome',
            'is_flex_enabled': 'isFlexEnabled',
            'version': 'version',
            'asm_instances': 'asmInstances',
            'connector': 'connector'
        }
        self._component_id = None
        self._display_name = None
        self._component_name = None
        self._component_type = None
        self._resource_id = None
        self._dbaas_id = None
        self._is_selected_for_monitoring = None
        self._status = None
        self._associated_components = None
        self._grid_home = None
        self._is_flex_enabled = None
        self._version = None
        self._asm_instances = None
        self._connector = None
        self._component_type = 'ASM'

    @property
    def grid_home(self):
        """
        Gets the grid_home of this DiscoveredCloudAsm.
        The directory in which ASM is installed. This is the same directory in which Oracle Grid Infrastructure is installed.


        :return: The grid_home of this DiscoveredCloudAsm.
        :rtype: str
        """
        return self._grid_home

    @grid_home.setter
    def grid_home(self, grid_home):
        """
        Sets the grid_home of this DiscoveredCloudAsm.
        The directory in which ASM is installed. This is the same directory in which Oracle Grid Infrastructure is installed.


        :param grid_home: The grid_home of this DiscoveredCloudAsm.
        :type: str
        """
        self._grid_home = grid_home

    @property
    def is_flex_enabled(self):
        """
        Gets the is_flex_enabled of this DiscoveredCloudAsm.
        Indicates whether Oracle Flex ASM is enabled or not.


        :return: The is_flex_enabled of this DiscoveredCloudAsm.
        :rtype: bool
        """
        return self._is_flex_enabled

    @is_flex_enabled.setter
    def is_flex_enabled(self, is_flex_enabled):
        """
        Sets the is_flex_enabled of this DiscoveredCloudAsm.
        Indicates whether Oracle Flex ASM is enabled or not.


        :param is_flex_enabled: The is_flex_enabled of this DiscoveredCloudAsm.
        :type: bool
        """
        self._is_flex_enabled = is_flex_enabled

    @property
    def version(self):
        """
        Gets the version of this DiscoveredCloudAsm.
        The ASM version.


        :return: The version of this DiscoveredCloudAsm.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this DiscoveredCloudAsm.
        The ASM version.


        :param version: The version of this DiscoveredCloudAsm.
        :type: str
        """
        self._version = version

    @property
    def asm_instances(self):
        """
        Gets the asm_instances of this DiscoveredCloudAsm.
        The list of asm instances for the cloud Asm.


        :return: The asm_instances of this DiscoveredCloudAsm.
        :rtype: list[oci.database_management.models.DiscoveredCloudAsmInstance]
        """
        return self._asm_instances

    @asm_instances.setter
    def asm_instances(self, asm_instances):
        """
        Sets the asm_instances of this DiscoveredCloudAsm.
        The list of asm instances for the cloud Asm.


        :param asm_instances: The asm_instances of this DiscoveredCloudAsm.
        :type: list[oci.database_management.models.DiscoveredCloudAsmInstance]
        """
        self._asm_instances = asm_instances

    @property
    def connector(self):
        """
        Gets the connector of this DiscoveredCloudAsm.

        :return: The connector of this DiscoveredCloudAsm.
        :rtype: oci.database_management.models.CloudDbSystemDiscoveryConnector
        """
        return self._connector

    @connector.setter
    def connector(self, connector):
        """
        Sets the connector of this DiscoveredCloudAsm.

        :param connector: The connector of this DiscoveredCloudAsm.
        :type: oci.database_management.models.CloudDbSystemDiscoveryConnector
        """
        self._connector = connector

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
