# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalAsmConfiguration(object):
    """
    The configuration details of an ASM.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalAsmConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param init_parameters:
            The value to assign to the init_parameters property of this ExternalAsmConfiguration.
        :type init_parameters: list[oci.database_management.models.ExternalAsmInstanceParameters]

        """
        self.swagger_types = {
            'init_parameters': 'list[ExternalAsmInstanceParameters]'
        }
        self.attribute_map = {
            'init_parameters': 'initParameters'
        }
        self._init_parameters = None

    @property
    def init_parameters(self):
        """
        **[Required]** Gets the init_parameters of this ExternalAsmConfiguration.
        An array of initialization parameters for the external ASM instances.


        :return: The init_parameters of this ExternalAsmConfiguration.
        :rtype: list[oci.database_management.models.ExternalAsmInstanceParameters]
        """
        return self._init_parameters

    @init_parameters.setter
    def init_parameters(self, init_parameters):
        """
        Sets the init_parameters of this ExternalAsmConfiguration.
        An array of initialization parameters for the external ASM instances.


        :param init_parameters: The init_parameters of this ExternalAsmConfiguration.
        :type: list[oci.database_management.models.ExternalAsmInstanceParameters]
        """
        self._init_parameters = init_parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
