# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PerformanceMetricsData(object):
    """
    The list of Data Guard performance metrics for Managed Databases.
    """

    #: A constant which can be used with the db_role property of a PerformanceMetricsData.
    #: This constant has a value of "SNAPSHOT_STANDBY"
    DB_ROLE_SNAPSHOT_STANDBY = "SNAPSHOT_STANDBY"

    #: A constant which can be used with the db_role property of a PerformanceMetricsData.
    #: This constant has a value of "LOGICAL_STANDBY"
    DB_ROLE_LOGICAL_STANDBY = "LOGICAL_STANDBY"

    #: A constant which can be used with the db_role property of a PerformanceMetricsData.
    #: This constant has a value of "PHYSICAL_STANDBY"
    DB_ROLE_PHYSICAL_STANDBY = "PHYSICAL_STANDBY"

    #: A constant which can be used with the db_role property of a PerformanceMetricsData.
    #: This constant has a value of "PRIMARY"
    DB_ROLE_PRIMARY = "PRIMARY"

    #: A constant which can be used with the db_role property of a PerformanceMetricsData.
    #: This constant has a value of "FAR_SYNC"
    DB_ROLE_FAR_SYNC = "FAR_SYNC"

    def __init__(self, **kwargs):
        """
        Initializes a new PerformanceMetricsData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this PerformanceMetricsData.
        :type compartment_id: str

        :param resource_id:
            The value to assign to the resource_id property of this PerformanceMetricsData.
        :type resource_id: str

        :param primary_db_id:
            The value to assign to the primary_db_id property of this PerformanceMetricsData.
        :type primary_db_id: str

        :param primary_db_unique_name:
            The value to assign to the primary_db_unique_name property of this PerformanceMetricsData.
        :type primary_db_unique_name: str

        :param database_id:
            The value to assign to the database_id property of this PerformanceMetricsData.
        :type database_id: str

        :param db_unique_name:
            The value to assign to the db_unique_name property of this PerformanceMetricsData.
        :type db_unique_name: str

        :param deployment_type:
            The value to assign to the deployment_type property of this PerformanceMetricsData.
        :type deployment_type: str

        :param resource_name:
            The value to assign to the resource_name property of this PerformanceMetricsData.
        :type resource_name: str

        :param db_role:
            The value to assign to the db_role property of this PerformanceMetricsData.
            Allowed values for this property are: "SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type db_role: str

        :param metrics:
            The value to assign to the metrics property of this PerformanceMetricsData.
        :type metrics: list[oci.database_management.models.PerformanceMetrics]

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'resource_id': 'str',
            'primary_db_id': 'str',
            'primary_db_unique_name': 'str',
            'database_id': 'str',
            'db_unique_name': 'str',
            'deployment_type': 'str',
            'resource_name': 'str',
            'db_role': 'str',
            'metrics': 'list[PerformanceMetrics]'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'resource_id': 'resourceId',
            'primary_db_id': 'primaryDbId',
            'primary_db_unique_name': 'primaryDbUniqueName',
            'database_id': 'databaseId',
            'db_unique_name': 'dbUniqueName',
            'deployment_type': 'deploymentType',
            'resource_name': 'resourceName',
            'db_role': 'dbRole',
            'metrics': 'metrics'
        }
        self._compartment_id = None
        self._resource_id = None
        self._primary_db_id = None
        self._primary_db_unique_name = None
        self._database_id = None
        self._db_unique_name = None
        self._deployment_type = None
        self._resource_name = None
        self._db_role = None
        self._metrics = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this PerformanceMetricsData.
        The `OCID`__ of the compartment in which the Managed Database resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this PerformanceMetricsData.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PerformanceMetricsData.
        The `OCID`__ of the compartment in which the Managed Database resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this PerformanceMetricsData.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_id(self):
        """
        Gets the resource_id of this PerformanceMetricsData.
        The `OCID`__ of the Managed Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this PerformanceMetricsData.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this PerformanceMetricsData.
        The `OCID`__ of the Managed Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this PerformanceMetricsData.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def primary_db_id(self):
        """
        Gets the primary_db_id of this PerformanceMetricsData.
        The ID of the primary database.


        :return: The primary_db_id of this PerformanceMetricsData.
        :rtype: str
        """
        return self._primary_db_id

    @primary_db_id.setter
    def primary_db_id(self, primary_db_id):
        """
        Sets the primary_db_id of this PerformanceMetricsData.
        The ID of the primary database.


        :param primary_db_id: The primary_db_id of this PerformanceMetricsData.
        :type: str
        """
        self._primary_db_id = primary_db_id

    @property
    def primary_db_unique_name(self):
        """
        Gets the primary_db_unique_name of this PerformanceMetricsData.
        The primary database unique name of the Managed Database.


        :return: The primary_db_unique_name of this PerformanceMetricsData.
        :rtype: str
        """
        return self._primary_db_unique_name

    @primary_db_unique_name.setter
    def primary_db_unique_name(self, primary_db_unique_name):
        """
        Sets the primary_db_unique_name of this PerformanceMetricsData.
        The primary database unique name of the Managed Database.


        :param primary_db_unique_name: The primary_db_unique_name of this PerformanceMetricsData.
        :type: str
        """
        self._primary_db_unique_name = primary_db_unique_name

    @property
    def database_id(self):
        """
        Gets the database_id of this PerformanceMetricsData.
        The database ID of the Managed Database. Every database had its own ID and that value is captured here.


        :return: The database_id of this PerformanceMetricsData.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this PerformanceMetricsData.
        The database ID of the Managed Database. Every database had its own ID and that value is captured here.


        :param database_id: The database_id of this PerformanceMetricsData.
        :type: str
        """
        self._database_id = database_id

    @property
    def db_unique_name(self):
        """
        Gets the db_unique_name of this PerformanceMetricsData.
        The database unique name of the Managed Database.


        :return: The db_unique_name of this PerformanceMetricsData.
        :rtype: str
        """
        return self._db_unique_name

    @db_unique_name.setter
    def db_unique_name(self, db_unique_name):
        """
        Sets the db_unique_name of this PerformanceMetricsData.
        The database unique name of the Managed Database.


        :param db_unique_name: The db_unique_name of this PerformanceMetricsData.
        :type: str
        """
        self._db_unique_name = db_unique_name

    @property
    def deployment_type(self):
        """
        Gets the deployment_type of this PerformanceMetricsData.
        The deployment type of the Managed Database.


        :return: The deployment_type of this PerformanceMetricsData.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this PerformanceMetricsData.
        The deployment type of the Managed Database.


        :param deployment_type: The deployment_type of this PerformanceMetricsData.
        :type: str
        """
        self._deployment_type = deployment_type

    @property
    def resource_name(self):
        """
        Gets the resource_name of this PerformanceMetricsData.
        The resource name of the Managed Database.


        :return: The resource_name of this PerformanceMetricsData.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this PerformanceMetricsData.
        The resource name of the Managed Database.


        :param resource_name: The resource_name of this PerformanceMetricsData.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def db_role(self):
        """
        Gets the db_role of this PerformanceMetricsData.
        The database role of the Managed Database.

        Allowed values for this property are: "SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The db_role of this PerformanceMetricsData.
        :rtype: str
        """
        return self._db_role

    @db_role.setter
    def db_role(self, db_role):
        """
        Sets the db_role of this PerformanceMetricsData.
        The database role of the Managed Database.


        :param db_role: The db_role of this PerformanceMetricsData.
        :type: str
        """
        allowed_values = ["SNAPSHOT_STANDBY", "LOGICAL_STANDBY", "PHYSICAL_STANDBY", "PRIMARY", "FAR_SYNC"]
        if not value_allowed_none_or_none_sentinel(db_role, allowed_values):
            db_role = 'UNKNOWN_ENUM_VALUE'
        self._db_role = db_role

    @property
    def metrics(self):
        """
        Gets the metrics of this PerformanceMetricsData.
        The list of Data Guard performance metrics such as ApplyLag, TransportLag and RedoApplyRate for the Managed Databases.


        :return: The metrics of this PerformanceMetricsData.
        :rtype: list[oci.database_management.models.PerformanceMetrics]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this PerformanceMetricsData.
        The list of Data Guard performance metrics such as ApplyLag, TransportLag and RedoApplyRate for the Managed Databases.


        :param metrics: The metrics of this PerformanceMetricsData.
        :type: list[oci.database_management.models.PerformanceMetrics]
        """
        self._metrics = metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
