# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .migration_object_collection import MigrationObjectCollection
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlMigrationObjectCollection(MigrationObjectCollection):
    """
    Lists the database objects that participate in this migration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlMigrationObjectCollection object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.MySqlMigrationObjectCollection.database_combination` attribute
        of this class is ``MYSQL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_combination:
            The value to assign to the database_combination property of this MySqlMigrationObjectCollection.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param items:
            The value to assign to the items property of this MySqlMigrationObjectCollection.
        :type items: list[oci.database_migration.models.MySqlDatabaseObjectSummary]

        :param bulk_include_exclude_data:
            The value to assign to the bulk_include_exclude_data property of this MySqlMigrationObjectCollection.
        :type bulk_include_exclude_data: str

        """
        self.swagger_types = {
            'database_combination': 'str',
            'items': 'list[MySqlDatabaseObjectSummary]',
            'bulk_include_exclude_data': 'str'
        }
        self.attribute_map = {
            'database_combination': 'databaseCombination',
            'items': 'items',
            'bulk_include_exclude_data': 'bulkIncludeExcludeData'
        }
        self._database_combination = None
        self._items = None
        self._bulk_include_exclude_data = None
        self._database_combination = 'MYSQL'

    @property
    def items(self):
        """
        **[Required]** Gets the items of this MySqlMigrationObjectCollection.
        An array of database objects that are either included or excluded from the migration.


        :return: The items of this MySqlMigrationObjectCollection.
        :rtype: list[oci.database_migration.models.MySqlDatabaseObjectSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this MySqlMigrationObjectCollection.
        An array of database objects that are either included or excluded from the migration.


        :param items: The items of this MySqlMigrationObjectCollection.
        :type: list[oci.database_migration.models.MySqlDatabaseObjectSummary]
        """
        self._items = items

    @property
    def bulk_include_exclude_data(self):
        """
        Gets the bulk_include_exclude_data of this MySqlMigrationObjectCollection.
        Specifies the database objects to be excluded from the migration in bulk.
        The definition accepts input in a CSV format, newline separated for each entry.
        More details can be found in the documentation.


        :return: The bulk_include_exclude_data of this MySqlMigrationObjectCollection.
        :rtype: str
        """
        return self._bulk_include_exclude_data

    @bulk_include_exclude_data.setter
    def bulk_include_exclude_data(self, bulk_include_exclude_data):
        """
        Sets the bulk_include_exclude_data of this MySqlMigrationObjectCollection.
        Specifies the database objects to be excluded from the migration in bulk.
        The definition accepts input in a CSV format, newline separated for each entry.
        More details can be found in the documentation.


        :param bulk_include_exclude_data: The bulk_include_exclude_data of this MySqlMigrationObjectCollection.
        :type: str
        """
        self._bulk_include_exclude_data = bulk_include_exclude_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
