# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleInitialLoadSettings(object):
    """
    Optional settings for Data Pump Export and Import jobs
    """

    #: A constant which can be used with the job_mode property of a OracleInitialLoadSettings.
    #: This constant has a value of "FULL"
    JOB_MODE_FULL = "FULL"

    #: A constant which can be used with the job_mode property of a OracleInitialLoadSettings.
    #: This constant has a value of "SCHEMA"
    JOB_MODE_SCHEMA = "SCHEMA"

    #: A constant which can be used with the job_mode property of a OracleInitialLoadSettings.
    #: This constant has a value of "TABLE"
    JOB_MODE_TABLE = "TABLE"

    #: A constant which can be used with the job_mode property of a OracleInitialLoadSettings.
    #: This constant has a value of "TABLESPACE"
    JOB_MODE_TABLESPACE = "TABLESPACE"

    #: A constant which can be used with the job_mode property of a OracleInitialLoadSettings.
    #: This constant has a value of "TRANSPORTABLE"
    JOB_MODE_TRANSPORTABLE = "TRANSPORTABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new OracleInitialLoadSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_pump_parameters:
            The value to assign to the data_pump_parameters property of this OracleInitialLoadSettings.
        :type data_pump_parameters: oci.database_migration.models.DataPumpParameters

        :param tablespace_details:
            The value to assign to the tablespace_details property of this OracleInitialLoadSettings.
        :type tablespace_details: oci.database_migration.models.TargetTypeTablespaceDetails

        :param export_directory_object:
            The value to assign to the export_directory_object property of this OracleInitialLoadSettings.
        :type export_directory_object: oci.database_migration.models.DirectoryObject

        :param import_directory_object:
            The value to assign to the import_directory_object property of this OracleInitialLoadSettings.
        :type import_directory_object: oci.database_migration.models.DirectoryObject

        :param job_mode:
            The value to assign to the job_mode property of this OracleInitialLoadSettings.
            Allowed values for this property are: "FULL", "SCHEMA", "TABLE", "TABLESPACE", "TRANSPORTABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type job_mode: str

        :param metadata_remaps:
            The value to assign to the metadata_remaps property of this OracleInitialLoadSettings.
        :type metadata_remaps: list[oci.database_migration.models.MetadataRemap]

        """
        self.swagger_types = {
            'data_pump_parameters': 'DataPumpParameters',
            'tablespace_details': 'TargetTypeTablespaceDetails',
            'export_directory_object': 'DirectoryObject',
            'import_directory_object': 'DirectoryObject',
            'job_mode': 'str',
            'metadata_remaps': 'list[MetadataRemap]'
        }
        self.attribute_map = {
            'data_pump_parameters': 'dataPumpParameters',
            'tablespace_details': 'tablespaceDetails',
            'export_directory_object': 'exportDirectoryObject',
            'import_directory_object': 'importDirectoryObject',
            'job_mode': 'jobMode',
            'metadata_remaps': 'metadataRemaps'
        }
        self._data_pump_parameters = None
        self._tablespace_details = None
        self._export_directory_object = None
        self._import_directory_object = None
        self._job_mode = None
        self._metadata_remaps = None

    @property
    def data_pump_parameters(self):
        """
        Gets the data_pump_parameters of this OracleInitialLoadSettings.

        :return: The data_pump_parameters of this OracleInitialLoadSettings.
        :rtype: oci.database_migration.models.DataPumpParameters
        """
        return self._data_pump_parameters

    @data_pump_parameters.setter
    def data_pump_parameters(self, data_pump_parameters):
        """
        Sets the data_pump_parameters of this OracleInitialLoadSettings.

        :param data_pump_parameters: The data_pump_parameters of this OracleInitialLoadSettings.
        :type: oci.database_migration.models.DataPumpParameters
        """
        self._data_pump_parameters = data_pump_parameters

    @property
    def tablespace_details(self):
        """
        Gets the tablespace_details of this OracleInitialLoadSettings.

        :return: The tablespace_details of this OracleInitialLoadSettings.
        :rtype: oci.database_migration.models.TargetTypeTablespaceDetails
        """
        return self._tablespace_details

    @tablespace_details.setter
    def tablespace_details(self, tablespace_details):
        """
        Sets the tablespace_details of this OracleInitialLoadSettings.

        :param tablespace_details: The tablespace_details of this OracleInitialLoadSettings.
        :type: oci.database_migration.models.TargetTypeTablespaceDetails
        """
        self._tablespace_details = tablespace_details

    @property
    def export_directory_object(self):
        """
        Gets the export_directory_object of this OracleInitialLoadSettings.

        :return: The export_directory_object of this OracleInitialLoadSettings.
        :rtype: oci.database_migration.models.DirectoryObject
        """
        return self._export_directory_object

    @export_directory_object.setter
    def export_directory_object(self, export_directory_object):
        """
        Sets the export_directory_object of this OracleInitialLoadSettings.

        :param export_directory_object: The export_directory_object of this OracleInitialLoadSettings.
        :type: oci.database_migration.models.DirectoryObject
        """
        self._export_directory_object = export_directory_object

    @property
    def import_directory_object(self):
        """
        Gets the import_directory_object of this OracleInitialLoadSettings.

        :return: The import_directory_object of this OracleInitialLoadSettings.
        :rtype: oci.database_migration.models.DirectoryObject
        """
        return self._import_directory_object

    @import_directory_object.setter
    def import_directory_object(self, import_directory_object):
        """
        Sets the import_directory_object of this OracleInitialLoadSettings.

        :param import_directory_object: The import_directory_object of this OracleInitialLoadSettings.
        :type: oci.database_migration.models.DirectoryObject
        """
        self._import_directory_object = import_directory_object

    @property
    def job_mode(self):
        """
        **[Required]** Gets the job_mode of this OracleInitialLoadSettings.
        Oracle Job Mode

        Allowed values for this property are: "FULL", "SCHEMA", "TABLE", "TABLESPACE", "TRANSPORTABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The job_mode of this OracleInitialLoadSettings.
        :rtype: str
        """
        return self._job_mode

    @job_mode.setter
    def job_mode(self, job_mode):
        """
        Sets the job_mode of this OracleInitialLoadSettings.
        Oracle Job Mode


        :param job_mode: The job_mode of this OracleInitialLoadSettings.
        :type: str
        """
        allowed_values = ["FULL", "SCHEMA", "TABLE", "TABLESPACE", "TRANSPORTABLE"]
        if not value_allowed_none_or_none_sentinel(job_mode, allowed_values):
            job_mode = 'UNKNOWN_ENUM_VALUE'
        self._job_mode = job_mode

    @property
    def metadata_remaps(self):
        """
        Gets the metadata_remaps of this OracleInitialLoadSettings.
        Defines remapping to be applied to objects as they are processed.


        :return: The metadata_remaps of this OracleInitialLoadSettings.
        :rtype: list[oci.database_migration.models.MetadataRemap]
        """
        return self._metadata_remaps

    @metadata_remaps.setter
    def metadata_remaps(self, metadata_remaps):
        """
        Sets the metadata_remaps of this OracleInitialLoadSettings.
        Defines remapping to be applied to objects as they are processed.


        :param metadata_remaps: The metadata_remaps of this OracleInitialLoadSettings.
        :type: list[oci.database_migration.models.MetadataRemap]
        """
        self._metadata_remaps = metadata_remaps

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
