# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005

from .update_database_tools_identity_details import UpdateDatabaseToolsIdentityDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails(UpdateDatabaseToolsIdentityDetails):
    """
    Database Tools identity information to be updated for the Oracle Database resource principal identity type.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_tools.models.UpdateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.type` attribute
        of this class is ``ORACLE_DATABASE_RESOURCE_PRINCIPAL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type display_name: str

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type freeform_tags: dict(str, str)

        :param type:
            The value to assign to the type property of this UpdateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
            Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL"
        :type type: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'type': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'type': 'type'
        }
        self._display_name = None
        self._defined_tags = None
        self._freeform_tags = None
        self._type = None
        self._type = 'ORACLE_DATABASE_RESOURCE_PRINCIPAL'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
