# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NotificationSummary(object):
    """
    Notifications
    """

    #: A constant which can be used with the notification_type property of a NotificationSummary.
    #: This constant has a value of "CVE"
    NOTIFICATION_TYPE_CVE = "CVE"

    #: A constant which can be used with the notification_type property of a NotificationSummary.
    #: This constant has a value of "ADVISORY"
    NOTIFICATION_TYPE_ADVISORY = "ADVISORY"

    #: A constant which can be used with the notification_type property of a NotificationSummary.
    #: This constant has a value of "PATCH"
    NOTIFICATION_TYPE_PATCH = "PATCH"

    def __init__(self, **kwargs):
        """
        Initializes a new NotificationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param notification_type:
            The value to assign to the notification_type property of this NotificationSummary.
            Allowed values for this property are: "CVE", "ADVISORY", "PATCH", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type notification_type: str

        :param notification_text:
            The value to assign to the notification_text property of this NotificationSummary.
        :type notification_text: str

        :param id:
            The value to assign to the id property of this NotificationSummary.
        :type id: str

        :param time_published:
            The value to assign to the time_published property of this NotificationSummary.
        :type time_published: datetime

        """
        self.swagger_types = {
            'notification_type': 'str',
            'notification_text': 'str',
            'id': 'str',
            'time_published': 'datetime'
        }
        self.attribute_map = {
            'notification_type': 'notificationType',
            'notification_text': 'notificationText',
            'id': 'id',
            'time_published': 'timePublished'
        }
        self._notification_type = None
        self._notification_text = None
        self._id = None
        self._time_published = None

    @property
    def notification_type(self):
        """
        **[Required]** Gets the notification_type of this NotificationSummary.
        Notification type

        Allowed values for this property are: "CVE", "ADVISORY", "PATCH", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The notification_type of this NotificationSummary.
        :rtype: str
        """
        return self._notification_type

    @notification_type.setter
    def notification_type(self, notification_type):
        """
        Sets the notification_type of this NotificationSummary.
        Notification type


        :param notification_type: The notification_type of this NotificationSummary.
        :type: str
        """
        allowed_values = ["CVE", "ADVISORY", "PATCH"]
        if not value_allowed_none_or_none_sentinel(notification_type, allowed_values):
            notification_type = 'UNKNOWN_ENUM_VALUE'
        self._notification_type = notification_type

    @property
    def notification_text(self):
        """
        **[Required]** Gets the notification_text of this NotificationSummary.
        Notification text


        :return: The notification_text of this NotificationSummary.
        :rtype: str
        """
        return self._notification_text

    @notification_text.setter
    def notification_text(self, notification_text):
        """
        Sets the notification_text of this NotificationSummary.
        Notification text


        :param notification_text: The notification_text of this NotificationSummary.
        :type: str
        """
        self._notification_text = notification_text

    @property
    def id(self):
        """
        **[Required]** Gets the id of this NotificationSummary.
        Notification identifier.


        :return: The id of this NotificationSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NotificationSummary.
        Notification identifier.


        :param id: The id of this NotificationSummary.
        :type: str
        """
        self._id = id

    @property
    def time_published(self):
        """
        **[Required]** Gets the time_published of this NotificationSummary.
        Published date


        :return: The time_published of this NotificationSummary.
        :rtype: datetime
        """
        return self._time_published

    @time_published.setter
    def time_published(self, time_published):
        """
        Sets the time_published of this NotificationSummary.
        Published date


        :param time_published: The time_published of this NotificationSummary.
        :type: datetime
        """
        self._time_published = time_published

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
