# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOracleDbGcpKeyRingDetails(object):
    """
    This object is about to provide input params to create Oracle DB GCP Key-Ring Details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOracleDbGcpKeyRingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOracleDbGcpKeyRingDetails.
        :type compartment_id: str

        :param oracle_db_connector_id:
            The value to assign to the oracle_db_connector_id property of this CreateOracleDbGcpKeyRingDetails.
        :type oracle_db_connector_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateOracleDbGcpKeyRingDetails.
        :type display_name: str

        :param gcp_key_ring_id:
            The value to assign to the gcp_key_ring_id property of this CreateOracleDbGcpKeyRingDetails.
        :type gcp_key_ring_id: str

        :param type:
            The value to assign to the type property of this CreateOracleDbGcpKeyRingDetails.
        :type type: str

        :param location:
            The value to assign to the location property of this CreateOracleDbGcpKeyRingDetails.
        :type location: str

        :param properties:
            The value to assign to the properties property of this CreateOracleDbGcpKeyRingDetails.
        :type properties: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOracleDbGcpKeyRingDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOracleDbGcpKeyRingDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'oracle_db_connector_id': 'str',
            'display_name': 'str',
            'gcp_key_ring_id': 'str',
            'type': 'str',
            'location': 'str',
            'properties': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'oracle_db_connector_id': 'oracleDbConnectorId',
            'display_name': 'displayName',
            'gcp_key_ring_id': 'gcpKeyRingId',
            'type': 'type',
            'location': 'location',
            'properties': 'properties',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._oracle_db_connector_id = None
        self._display_name = None
        self._gcp_key_ring_id = None
        self._type = None
        self._location = None
        self._properties = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOracleDbGcpKeyRingDetails.
        The compartment `OCID`__ where the Oracle DB GCP Key Ring resource resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateOracleDbGcpKeyRingDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOracleDbGcpKeyRingDetails.
        The compartment `OCID`__ where the Oracle DB GCP Key Ring resource resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateOracleDbGcpKeyRingDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def oracle_db_connector_id(self):
        """
        **[Required]** Gets the oracle_db_connector_id of this CreateOracleDbGcpKeyRingDetails.
        The `OCID`__ of the compartment where the Oracle DB GCP Identity Connector resource resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_connector_id of this CreateOracleDbGcpKeyRingDetails.
        :rtype: str
        """
        return self._oracle_db_connector_id

    @oracle_db_connector_id.setter
    def oracle_db_connector_id(self, oracle_db_connector_id):
        """
        Sets the oracle_db_connector_id of this CreateOracleDbGcpKeyRingDetails.
        The `OCID`__ of the compartment where the Oracle DB GCP Identity Connector resource resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_connector_id: The oracle_db_connector_id of this CreateOracleDbGcpKeyRingDetails.
        :type: str
        """
        self._oracle_db_connector_id = oracle_db_connector_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateOracleDbGcpKeyRingDetails.
        Display name of DB GCP Key Ring resource.


        :return: The display_name of this CreateOracleDbGcpKeyRingDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOracleDbGcpKeyRingDetails.
        Display name of DB GCP Key Ring resource.


        :param display_name: The display_name of this CreateOracleDbGcpKeyRingDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def gcp_key_ring_id(self):
        """
        Gets the gcp_key_ring_id of this CreateOracleDbGcpKeyRingDetails.
        GCP Key Ring ID.


        :return: The gcp_key_ring_id of this CreateOracleDbGcpKeyRingDetails.
        :rtype: str
        """
        return self._gcp_key_ring_id

    @gcp_key_ring_id.setter
    def gcp_key_ring_id(self, gcp_key_ring_id):
        """
        Sets the gcp_key_ring_id of this CreateOracleDbGcpKeyRingDetails.
        GCP Key Ring ID.


        :param gcp_key_ring_id: The gcp_key_ring_id of this CreateOracleDbGcpKeyRingDetails.
        :type: str
        """
        self._gcp_key_ring_id = gcp_key_ring_id

    @property
    def type(self):
        """
        Gets the type of this CreateOracleDbGcpKeyRingDetails.
        Oracle DB GCP Key Ring resource Type.


        :return: The type of this CreateOracleDbGcpKeyRingDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateOracleDbGcpKeyRingDetails.
        Oracle DB GCP Key Ring resource Type.


        :param type: The type of this CreateOracleDbGcpKeyRingDetails.
        :type: str
        """
        self._type = type

    @property
    def location(self):
        """
        Gets the location of this CreateOracleDbGcpKeyRingDetails.
        Location of the GCP Key Ring resource.


        :return: The location of this CreateOracleDbGcpKeyRingDetails.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this CreateOracleDbGcpKeyRingDetails.
        Location of the GCP Key Ring resource.


        :param location: The location of this CreateOracleDbGcpKeyRingDetails.
        :type: str
        """
        self._location = location

    @property
    def properties(self):
        """
        Gets the properties of this CreateOracleDbGcpKeyRingDetails.
        Oracle DB GCP Key Ring resource's properties.


        :return: The properties of this CreateOracleDbGcpKeyRingDetails.
        :rtype: dict(str, str)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this CreateOracleDbGcpKeyRingDetails.
        Oracle DB GCP Key Ring resource's properties.


        :param properties: The properties of this CreateOracleDbGcpKeyRingDetails.
        :type: dict(str, str)
        """
        self._properties = properties

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOracleDbGcpKeyRingDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateOracleDbGcpKeyRingDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOracleDbGcpKeyRingDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateOracleDbGcpKeyRingDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOracleDbGcpKeyRingDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateOracleDbGcpKeyRingDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOracleDbGcpKeyRingDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateOracleDbGcpKeyRingDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
