# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RefreshOracleDbAzureVaultDetails(object):
    """
    Details for to refresh DB Azure Vault resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RefreshOracleDbAzureVaultDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param oracle_db_azure_connector_id:
            The value to assign to the oracle_db_azure_connector_id property of this RefreshOracleDbAzureVaultDetails.
        :type oracle_db_azure_connector_id: str

        """
        self.swagger_types = {
            'oracle_db_azure_connector_id': 'str'
        }
        self.attribute_map = {
            'oracle_db_azure_connector_id': 'oracleDbAzureConnectorId'
        }
        self._oracle_db_azure_connector_id = None

    @property
    def oracle_db_azure_connector_id(self):
        """
        Gets the oracle_db_azure_connector_id of this RefreshOracleDbAzureVaultDetails.
        The `OCID`__ of the Oracle DB Azure Vault resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_azure_connector_id of this RefreshOracleDbAzureVaultDetails.
        :rtype: str
        """
        return self._oracle_db_azure_connector_id

    @oracle_db_azure_connector_id.setter
    def oracle_db_azure_connector_id(self, oracle_db_azure_connector_id):
        """
        Sets the oracle_db_azure_connector_id of this RefreshOracleDbAzureVaultDetails.
        The `OCID`__ of the Oracle DB Azure Vault resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_azure_connector_id: The oracle_db_azure_connector_id of this RefreshOracleDbAzureVaultDetails.
        :type: str
        """
        self._oracle_db_azure_connector_id = oracle_db_azure_connector_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
