# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateMultiCloudResourceDiscoveryDetails(object):
    """
    This object is about to provide input params to update Multicloud Resource Discovery.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateMultiCloudResourceDiscoveryDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this UpdateMultiCloudResourceDiscoveryDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this UpdateMultiCloudResourceDiscoveryDetails.
        :type display_name: str

        :param oracle_db_connector_id:
            The value to assign to the oracle_db_connector_id property of this UpdateMultiCloudResourceDiscoveryDetails.
        :type oracle_db_connector_id: str

        :param resource_type:
            The value to assign to the resource_type property of this UpdateMultiCloudResourceDiscoveryDetails.
        :type resource_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateMultiCloudResourceDiscoveryDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateMultiCloudResourceDiscoveryDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'oracle_db_connector_id': 'str',
            'resource_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'oracle_db_connector_id': 'oracleDbConnectorId',
            'resource_type': 'resourceType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._oracle_db_connector_id = None
        self._resource_type = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this UpdateMultiCloudResourceDiscoveryDetails.
        The `OCID`__ of the compartment that contains Multicloud Resource Discovery resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this UpdateMultiCloudResourceDiscoveryDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this UpdateMultiCloudResourceDiscoveryDetails.
        The `OCID`__ of the compartment that contains Multicloud Resource Discovery resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this UpdateMultiCloudResourceDiscoveryDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateMultiCloudResourceDiscoveryDetails.
        Display name of the Multicloud Resource Discovery resource.


        :return: The display_name of this UpdateMultiCloudResourceDiscoveryDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateMultiCloudResourceDiscoveryDetails.
        Display name of the Multicloud Resource Discovery resource.


        :param display_name: The display_name of this UpdateMultiCloudResourceDiscoveryDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def oracle_db_connector_id(self):
        """
        Gets the oracle_db_connector_id of this UpdateMultiCloudResourceDiscoveryDetails.
        The `OCID`__ of the Oracle DB Connector resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_connector_id of this UpdateMultiCloudResourceDiscoveryDetails.
        :rtype: str
        """
        return self._oracle_db_connector_id

    @oracle_db_connector_id.setter
    def oracle_db_connector_id(self, oracle_db_connector_id):
        """
        Sets the oracle_db_connector_id of this UpdateMultiCloudResourceDiscoveryDetails.
        The `OCID`__ of the Oracle DB Connector resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_connector_id: The oracle_db_connector_id of this UpdateMultiCloudResourceDiscoveryDetails.
        :type: str
        """
        self._oracle_db_connector_id = oracle_db_connector_id

    @property
    def resource_type(self):
        """
        Gets the resource_type of this UpdateMultiCloudResourceDiscoveryDetails.
        Resource Type to discover.


        :return: The resource_type of this UpdateMultiCloudResourceDiscoveryDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this UpdateMultiCloudResourceDiscoveryDetails.
        Resource Type to discover.


        :param resource_type: The resource_type of this UpdateMultiCloudResourceDiscoveryDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateMultiCloudResourceDiscoveryDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateMultiCloudResourceDiscoveryDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateMultiCloudResourceDiscoveryDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateMultiCloudResourceDiscoveryDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateMultiCloudResourceDiscoveryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateMultiCloudResourceDiscoveryDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateMultiCloudResourceDiscoveryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateMultiCloudResourceDiscoveryDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
