# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220618


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DesktopAction(object):
    """
    Provides information about actions performed on a desktop, including type and time.
    """

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "API_START"
    ACTION_API_START = "API_START"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "API_STOP"
    ACTION_API_STOP = "API_STOP"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "AVAILABILITY_START"
    ACTION_AVAILABILITY_START = "AVAILABILITY_START"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "AVAILABILITY_STOP"
    ACTION_AVAILABILITY_STOP = "AVAILABILITY_STOP"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "DISCONNECTED_STOP"
    ACTION_DISCONNECTED_STOP = "DISCONNECTED_STOP"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "DISCONNECTED_DELETE"
    ACTION_DISCONNECTED_DELETE = "DISCONNECTED_DELETE"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "SCHEDULED_START"
    ACTION_SCHEDULED_START = "SCHEDULED_START"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "SCHEDULED_STOP"
    ACTION_SCHEDULED_STOP = "SCHEDULED_STOP"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "SYNCHRONIZE"
    ACTION_SYNCHRONIZE = "SYNCHRONIZE"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "CONNECTED"
    ACTION_CONNECTED = "CONNECTED"

    #: A constant which can be used with the action property of a DesktopAction.
    #: This constant has a value of "DISCONNECTED"
    ACTION_DISCONNECTED = "DISCONNECTED"

    def __init__(self, **kwargs):
        """
        Initializes a new DesktopAction object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action:
            The value to assign to the action property of this DesktopAction.
            Allowed values for this property are: "API_START", "API_STOP", "AVAILABILITY_START", "AVAILABILITY_STOP", "DISCONNECTED_STOP", "DISCONNECTED_DELETE", "SCHEDULED_START", "SCHEDULED_STOP", "SYNCHRONIZE", "CONNECTED", "DISCONNECTED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action: str

        :param time_applied:
            The value to assign to the time_applied property of this DesktopAction.
        :type time_applied: datetime

        """
        self.swagger_types = {
            'action': 'str',
            'time_applied': 'datetime'
        }
        self.attribute_map = {
            'action': 'action',
            'time_applied': 'timeApplied'
        }
        self._action = None
        self._time_applied = None

    @property
    def action(self):
        """
        **[Required]** Gets the action of this DesktopAction.
        An action performed on a desktop.

        Allowed values for this property are: "API_START", "API_STOP", "AVAILABILITY_START", "AVAILABILITY_STOP", "DISCONNECTED_STOP", "DISCONNECTED_DELETE", "SCHEDULED_START", "SCHEDULED_STOP", "SYNCHRONIZE", "CONNECTED", "DISCONNECTED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action of this DesktopAction.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this DesktopAction.
        An action performed on a desktop.


        :param action: The action of this DesktopAction.
        :type: str
        """
        allowed_values = ["API_START", "API_STOP", "AVAILABILITY_START", "AVAILABILITY_STOP", "DISCONNECTED_STOP", "DISCONNECTED_DELETE", "SCHEDULED_START", "SCHEDULED_STOP", "SYNCHRONIZE", "CONNECTED", "DISCONNECTED"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            action = 'UNKNOWN_ENUM_VALUE'
        self._action = action

    @property
    def time_applied(self):
        """
        **[Required]** Gets the time_applied of this DesktopAction.
        The time of an action performed on a desktop.


        :return: The time_applied of this DesktopAction.
        :rtype: datetime
        """
        return self._time_applied

    @time_applied.setter
    def time_applied(self, time_applied):
        """
        Sets the time_applied of this DesktopAction.
        The time of an action performed on a desktop.


        :param time_applied: The time_applied of this DesktopAction.
        :type: datetime
        """
        self._time_applied = time_applied

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
