# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220618


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDesktopImage(object):
    """
    The update details of the desktop image.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDesktopImage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param image_id:
            The value to assign to the image_id property of this UpdateDesktopImage.
        :type image_id: str

        """
        self.swagger_types = {
            'image_id': 'str'
        }
        self.attribute_map = {
            'image_id': 'imageId'
        }
        self._image_id = None

    @property
    def image_id(self):
        """
        **[Required]** Gets the image_id of this UpdateDesktopImage.
        The OCID of the desktop image.


        :return: The image_id of this UpdateDesktopImage.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """
        Sets the image_id of this UpdateDesktopImage.
        The OCID of the desktop image.


        :param image_id: The image_id of this UpdateDesktopImage.
        :type: str
        """
        self._image_id = image_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
