# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssignedConnectionDetails(object):
    """
    Details to about assigned connections.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssignedConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_name:
            The value to assign to the connection_name property of this AssignedConnectionDetails.
        :type connection_name: str

        :param connection_id:
            The value to assign to the connection_id property of this AssignedConnectionDetails.
        :type connection_id: str

        :param requested_by:
            The value to assign to the requested_by property of this AssignedConnectionDetails.
        :type requested_by: str

        """
        self.swagger_types = {
            'connection_name': 'str',
            'connection_id': 'str',
            'requested_by': 'str'
        }
        self.attribute_map = {
            'connection_name': 'connectionName',
            'connection_id': 'connectionId',
            'requested_by': 'requestedBy'
        }
        self._connection_name = None
        self._connection_id = None
        self._requested_by = None

    @property
    def connection_name(self):
        """
        Gets the connection_name of this AssignedConnectionDetails.
        Name of the connection.


        :return: The connection_name of this AssignedConnectionDetails.
        :rtype: str
        """
        return self._connection_name

    @connection_name.setter
    def connection_name(self, connection_name):
        """
        Sets the connection_name of this AssignedConnectionDetails.
        Name of the connection.


        :param connection_name: The connection_name of this AssignedConnectionDetails.
        :type: str
        """
        self._connection_name = connection_name

    @property
    def connection_id(self):
        """
        Gets the connection_id of this AssignedConnectionDetails.
        OCID of the connection.


        :return: The connection_id of this AssignedConnectionDetails.
        :rtype: str
        """
        return self._connection_id

    @connection_id.setter
    def connection_id(self, connection_id):
        """
        Sets the connection_id of this AssignedConnectionDetails.
        OCID of the connection.


        :param connection_id: The connection_id of this AssignedConnectionDetails.
        :type: str
        """
        self._connection_id = connection_id

    @property
    def requested_by(self):
        """
        Gets the requested_by of this AssignedConnectionDetails.
        Specifies who has made this connection.


        :return: The requested_by of this AssignedConnectionDetails.
        :rtype: str
        """
        return self._requested_by

    @requested_by.setter
    def requested_by(self, requested_by):
        """
        Sets the requested_by of this AssignedConnectionDetails.
        Specifies who has made this connection.


        :param requested_by: The requested_by of this AssignedConnectionDetails.
        :type: str
        """
        self._requested_by = requested_by

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
