# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataflowConnectionDetails(object):
    """
    Details of services to create private endpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataflowConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param dif_dependencies:
            The value to assign to the dif_dependencies property of this DataflowConnectionDetails.
        :type dif_dependencies: list[oci.dif.models.DifDependencyDetails]

        :param domain_names:
            The value to assign to the domain_names property of this DataflowConnectionDetails.
        :type domain_names: list[str]

        """
        self.swagger_types = {
            'dif_dependencies': 'list[DifDependencyDetails]',
            'domain_names': 'list[str]'
        }
        self.attribute_map = {
            'dif_dependencies': 'difDependencies',
            'domain_names': 'domainNames'
        }
        self._dif_dependencies = None
        self._domain_names = None

    @property
    def dif_dependencies(self):
        """
        Gets the dif_dependencies of this DataflowConnectionDetails.
        List of DIF Service Dependency Details to create private endpoint.


        :return: The dif_dependencies of this DataflowConnectionDetails.
        :rtype: list[oci.dif.models.DifDependencyDetails]
        """
        return self._dif_dependencies

    @dif_dependencies.setter
    def dif_dependencies(self, dif_dependencies):
        """
        Sets the dif_dependencies of this DataflowConnectionDetails.
        List of DIF Service Dependency Details to create private endpoint.


        :param dif_dependencies: The dif_dependencies of this DataflowConnectionDetails.
        :type: list[oci.dif.models.DifDependencyDetails]
        """
        self._dif_dependencies = dif_dependencies

    @property
    def domain_names(self):
        """
        Gets the domain_names of this DataflowConnectionDetails.
        An array of DNS zone names.


        :return: The domain_names of this DataflowConnectionDetails.
        :rtype: list[str]
        """
        return self._domain_names

    @domain_names.setter
    def domain_names(self, domain_names):
        """
        Sets the domain_names of this DataflowConnectionDetails.
        An array of DNS zone names.


        :param domain_names: The domain_names of this DataflowConnectionDetails.
        :type: list[str]
        """
        self._domain_names = domain_names

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
