# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GgcsConnectionDetails(object):
    """
    Details of GGCS connections to be created.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GgcsConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_name:
            The value to assign to the connection_name property of this GgcsConnectionDetails.
        :type connection_name: str

        :param dif_dependencies:
            The value to assign to the dif_dependencies property of this GgcsConnectionDetails.
        :type dif_dependencies: list[oci.dif.models.DifDependencyDetails]

        :param gg_admin_secret_id:
            The value to assign to the gg_admin_secret_id property of this GgcsConnectionDetails.
        :type gg_admin_secret_id: str

        :param connection_id:
            The value to assign to the connection_id property of this GgcsConnectionDetails.
        :type connection_id: str

        """
        self.swagger_types = {
            'connection_name': 'str',
            'dif_dependencies': 'list[DifDependencyDetails]',
            'gg_admin_secret_id': 'str',
            'connection_id': 'str'
        }
        self.attribute_map = {
            'connection_name': 'connectionName',
            'dif_dependencies': 'difDependencies',
            'gg_admin_secret_id': 'ggAdminSecretId',
            'connection_id': 'connectionId'
        }
        self._connection_name = None
        self._dif_dependencies = None
        self._gg_admin_secret_id = None
        self._connection_id = None

    @property
    def connection_name(self):
        """
        **[Required]** Gets the connection_name of this GgcsConnectionDetails.
        Name of the connection to be created.


        :return: The connection_name of this GgcsConnectionDetails.
        :rtype: str
        """
        return self._connection_name

    @connection_name.setter
    def connection_name(self, connection_name):
        """
        Sets the connection_name of this GgcsConnectionDetails.
        Name of the connection to be created.


        :param connection_name: The connection_name of this GgcsConnectionDetails.
        :type: str
        """
        self._connection_name = connection_name

    @property
    def dif_dependencies(self):
        """
        Gets the dif_dependencies of this GgcsConnectionDetails.
        List of Service Dependency Details for connection creation.


        :return: The dif_dependencies of this GgcsConnectionDetails.
        :rtype: list[oci.dif.models.DifDependencyDetails]
        """
        return self._dif_dependencies

    @dif_dependencies.setter
    def dif_dependencies(self, dif_dependencies):
        """
        Sets the dif_dependencies of this GgcsConnectionDetails.
        List of Service Dependency Details for connection creation.


        :param dif_dependencies: The dif_dependencies of this GgcsConnectionDetails.
        :type: list[oci.dif.models.DifDependencyDetails]
        """
        self._dif_dependencies = dif_dependencies

    @property
    def gg_admin_secret_id(self):
        """
        Gets the gg_admin_secret_id of this GgcsConnectionDetails.
        Vault secret OCID containing password that Oracle GoldenGate uses to connect the associated system of the given technology.


        :return: The gg_admin_secret_id of this GgcsConnectionDetails.
        :rtype: str
        """
        return self._gg_admin_secret_id

    @gg_admin_secret_id.setter
    def gg_admin_secret_id(self, gg_admin_secret_id):
        """
        Sets the gg_admin_secret_id of this GgcsConnectionDetails.
        Vault secret OCID containing password that Oracle GoldenGate uses to connect the associated system of the given technology.


        :param gg_admin_secret_id: The gg_admin_secret_id of this GgcsConnectionDetails.
        :type: str
        """
        self._gg_admin_secret_id = gg_admin_secret_id

    @property
    def connection_id(self):
        """
        Gets the connection_id of this GgcsConnectionDetails.
        OCID of pre-created Oracle GoldenGate connection.


        :return: The connection_id of this GgcsConnectionDetails.
        :rtype: str
        """
        return self._connection_id

    @connection_id.setter
    def connection_id(self, connection_id):
        """
        Sets the connection_id of this GgcsConnectionDetails.
        OCID of pre-created Oracle GoldenGate connection.


        :param connection_id: The connection_id of this GgcsConnectionDetails.
        :type: str
        """
        self._connection_id = connection_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
