# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GgcsDetail(object):
    """
    GGCS details required to provision deployments and connections.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GgcsDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this GgcsDetail.
        :type instance_id: str

        :param ocpu:
            The value to assign to the ocpu property of this GgcsDetail.
        :type ocpu: int

        :param subnet_id:
            The value to assign to the subnet_id property of this GgcsDetail.
        :type subnet_id: str

        :param public_subnet_id:
            The value to assign to the public_subnet_id property of this GgcsDetail.
        :type public_subnet_id: str

        :param password_secret_id:
            The value to assign to the password_secret_id property of this GgcsDetail.
        :type password_secret_id: str

        :param ogg_version:
            The value to assign to the ogg_version property of this GgcsDetail.
        :type ogg_version: str

        :param connections:
            The value to assign to the connections property of this GgcsDetail.
        :type connections: list[oci.dif.models.GgcsConnectionDetails]

        """
        self.swagger_types = {
            'instance_id': 'str',
            'ocpu': 'int',
            'subnet_id': 'str',
            'public_subnet_id': 'str',
            'password_secret_id': 'str',
            'ogg_version': 'str',
            'connections': 'list[GgcsConnectionDetails]'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'ocpu': 'ocpu',
            'subnet_id': 'subnetId',
            'public_subnet_id': 'publicSubnetId',
            'password_secret_id': 'passwordSecretId',
            'ogg_version': 'oggVersion',
            'connections': 'connections'
        }
        self._instance_id = None
        self._ocpu = None
        self._subnet_id = None
        self._public_subnet_id = None
        self._password_secret_id = None
        self._ogg_version = None
        self._connections = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this GgcsDetail.
        Id for the GGCS instance to provision.


        :return: The instance_id of this GgcsDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this GgcsDetail.
        Id for the GGCS instance to provision.


        :param instance_id: The instance_id of this GgcsDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def ocpu(self):
        """
        **[Required]** Gets the ocpu of this GgcsDetail.
        The Minimum number of OCPUs to be made available for this Deployment.


        :return: The ocpu of this GgcsDetail.
        :rtype: int
        """
        return self._ocpu

    @ocpu.setter
    def ocpu(self, ocpu):
        """
        Sets the ocpu of this GgcsDetail.
        The Minimum number of OCPUs to be made available for this Deployment.


        :param ocpu: The ocpu of this GgcsDetail.
        :type: int
        """
        self._ocpu = ocpu

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this GgcsDetail.
        The OCID of the subnet of the GGCS deployment's private endpoint.


        :return: The subnet_id of this GgcsDetail.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this GgcsDetail.
        The OCID of the subnet of the GGCS deployment's private endpoint.


        :param subnet_id: The subnet_id of this GgcsDetail.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def public_subnet_id(self):
        """
        Gets the public_subnet_id of this GgcsDetail.
        The OCID of a public subnet in the customer tenancy. Can be provided only for public GGCS deployments.


        :return: The public_subnet_id of this GgcsDetail.
        :rtype: str
        """
        return self._public_subnet_id

    @public_subnet_id.setter
    def public_subnet_id(self, public_subnet_id):
        """
        Sets the public_subnet_id of this GgcsDetail.
        The OCID of a public subnet in the customer tenancy. Can be provided only for public GGCS deployments.


        :param public_subnet_id: The public_subnet_id of this GgcsDetail.
        :type: str
        """
        self._public_subnet_id = public_subnet_id

    @property
    def password_secret_id(self):
        """
        **[Required]** Gets the password_secret_id of this GgcsDetail.
        The OCID of the Secret where the deployment password is stored.


        :return: The password_secret_id of this GgcsDetail.
        :rtype: str
        """
        return self._password_secret_id

    @password_secret_id.setter
    def password_secret_id(self, password_secret_id):
        """
        Sets the password_secret_id of this GgcsDetail.
        The OCID of the Secret where the deployment password is stored.


        :param password_secret_id: The password_secret_id of this GgcsDetail.
        :type: str
        """
        self._password_secret_id = password_secret_id

    @property
    def ogg_version(self):
        """
        Gets the ogg_version of this GgcsDetail.
        Version of OGG.


        :return: The ogg_version of this GgcsDetail.
        :rtype: str
        """
        return self._ogg_version

    @ogg_version.setter
    def ogg_version(self, ogg_version):
        """
        Sets the ogg_version of this GgcsDetail.
        Version of OGG.


        :param ogg_version: The ogg_version of this GgcsDetail.
        :type: str
        """
        self._ogg_version = ogg_version

    @property
    def connections(self):
        """
        Gets the connections of this GgcsDetail.
        Connection details to be associated with the Goldengate deployment.


        :return: The connections of this GgcsDetail.
        :rtype: list[oci.dif.models.GgcsConnectionDetails]
        """
        return self._connections

    @connections.setter
    def connections(self, connections):
        """
        Sets the connections of this GgcsDetail.
        Connection details to be associated with the Goldengate deployment.


        :param connections: The connections of this GgcsDetail.
        :type: list[oci.dif.models.GgcsConnectionDetails]
        """
        self._connections = connections

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
