# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DistributedDatabaseShard(object):
    """
    Globally distributed database shard.
    """

    #: A constant which can be used with the source property of a DistributedDatabaseShard.
    #: This constant has a value of "EXADB_XS"
    SOURCE_EXADB_XS = "EXADB_XS"

    def __init__(self, **kwargs):
        """
        Initializes a new DistributedDatabaseShard object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.distributed_database.models.DistributedDatabaseShardWithExadbXs`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this DistributedDatabaseShard.
            Allowed values for this property are: "EXADB_XS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type source: str

        :param name:
            The value to assign to the name property of this DistributedDatabaseShard.
        :type name: str

        :param time_created:
            The value to assign to the time_created property of this DistributedDatabaseShard.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DistributedDatabaseShard.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'source': 'str',
            'name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'source': 'source',
            'name': 'name',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._source = None
        self._name = None
        self._time_created = None
        self._time_updated = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['source']

        if type == 'EXADB_XS':
            return 'DistributedDatabaseShardWithExadbXs'
        else:
            return 'DistributedDatabaseShard'

    @property
    def source(self):
        """
        **[Required]** Gets the source of this DistributedDatabaseShard.
        The source of Globally distributed database type: Use EXADB_XS for the Globally distributed database with Exascale based distributed database.

        Allowed values for this property are: "EXADB_XS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The source of this DistributedDatabaseShard.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this DistributedDatabaseShard.
        The source of Globally distributed database type: Use EXADB_XS for the Globally distributed database with Exascale based distributed database.


        :param source: The source of this DistributedDatabaseShard.
        :type: str
        """
        allowed_values = ["EXADB_XS"]
        if not value_allowed_none_or_none_sentinel(source, allowed_values):
            source = 'UNKNOWN_ENUM_VALUE'
        self._source = source

    @property
    def name(self):
        """
        **[Required]** Gets the name of this DistributedDatabaseShard.
        Name of the shard.


        :return: The name of this DistributedDatabaseShard.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DistributedDatabaseShard.
        Name of the shard.


        :param name: The name of this DistributedDatabaseShard.
        :type: str
        """
        self._name = name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DistributedDatabaseShard.
        The time the shard was created. An RFC3339 formatted datetime string


        :return: The time_created of this DistributedDatabaseShard.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DistributedDatabaseShard.
        The time the shard was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this DistributedDatabaseShard.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DistributedDatabaseShard.
        The time the shard was last updated. An RFC3339 formatted datetime string


        :return: The time_updated of this DistributedDatabaseShard.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DistributedDatabaseShard.
        The time the shard was last updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this DistributedDatabaseShard.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
