# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WorkRequestSummary(object):
    """
    A summary of the status of a work request.
    """

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CREATE_DISTRIBUTED_DB"
    OPERATION_TYPE_CREATE_DISTRIBUTED_DB = "CREATE_DISTRIBUTED_DB"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "PATCH_DISTRIBUTED_DB_INSERT_SHARDS"
    OPERATION_TYPE_PATCH_DISTRIBUTED_DB_INSERT_SHARDS = "PATCH_DISTRIBUTED_DB_INSERT_SHARDS"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "PATCH_DISTRIBUTED_DB_REMOVE_SHARDS"
    OPERATION_TYPE_PATCH_DISTRIBUTED_DB_REMOVE_SHARDS = "PATCH_DISTRIBUTED_DB_REMOVE_SHARDS"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "PATCH_DISTRIBUTED_DB_MERGE_CATALOG_SHARDS"
    OPERATION_TYPE_PATCH_DISTRIBUTED_DB_MERGE_CATALOG_SHARDS = "PATCH_DISTRIBUTED_DB_MERGE_CATALOG_SHARDS"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "DELETE_DISTRIBUTED_DB"
    OPERATION_TYPE_DELETE_DISTRIBUTED_DB = "DELETE_DISTRIBUTED_DB"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CHANGE_DISTRIBUTED_DB_COMPARTMENT"
    OPERATION_TYPE_CHANGE_DISTRIBUTED_DB_COMPARTMENT = "CHANGE_DISTRIBUTED_DB_COMPARTMENT"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CONFIGURE_DISTRIBUTED_DB_GSMS"
    OPERATION_TYPE_CONFIGURE_DISTRIBUTED_DB_GSMS = "CONFIGURE_DISTRIBUTED_DB_GSMS"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CONFIGURE_DISTRIBUTED_DB_SHARDING"
    OPERATION_TYPE_CONFIGURE_DISTRIBUTED_DB_SHARDING = "CONFIGURE_DISTRIBUTED_DB_SHARDING"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "GENERATE_DISTRIBUTED_DB_GSM_CERT_SIGNING_REQ"
    OPERATION_TYPE_GENERATE_DISTRIBUTED_DB_GSM_CERT_SIGNING_REQ = "GENERATE_DISTRIBUTED_DB_GSM_CERT_SIGNING_REQ"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "ROTATE_DISTRIBUTED_DB_PASSWORDS"
    OPERATION_TYPE_ROTATE_DISTRIBUTED_DB_PASSWORDS = "ROTATE_DISTRIBUTED_DB_PASSWORDS"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "START_DISTRIBUTED_DB"
    OPERATION_TYPE_START_DISTRIBUTED_DB = "START_DISTRIBUTED_DB"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "STOP_DISTRIBUTED_DB"
    OPERATION_TYPE_STOP_DISTRIBUTED_DB = "STOP_DISTRIBUTED_DB"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "START_DISTRIBUTED_DB_SHARD"
    OPERATION_TYPE_START_DISTRIBUTED_DB_SHARD = "START_DISTRIBUTED_DB_SHARD"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "START_DISTRIBUTED_DB_CATALOG"
    OPERATION_TYPE_START_DISTRIBUTED_DB_CATALOG = "START_DISTRIBUTED_DB_CATALOG"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "STOP_DISTRIBUTED_DB_SHARD"
    OPERATION_TYPE_STOP_DISTRIBUTED_DB_SHARD = "STOP_DISTRIBUTED_DB_SHARD"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "STOP_DISTRIBUTED_DB_CATALOG"
    OPERATION_TYPE_STOP_DISTRIBUTED_DB_CATALOG = "STOP_DISTRIBUTED_DB_CATALOG"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "UPLOAD_DISTRIBUTED_DB_SIGNED_CERT_AND_GENERATE_WALLET"
    OPERATION_TYPE_UPLOAD_DISTRIBUTED_DB_SIGNED_CERT_AND_GENERATE_WALLET = "UPLOAD_DISTRIBUTED_DB_SIGNED_CERT_AND_GENERATE_WALLET"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CREATE_DISTRIBUTED_DB_SHARD"
    OPERATION_TYPE_CREATE_DISTRIBUTED_DB_SHARD = "CREATE_DISTRIBUTED_DB_SHARD"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CREATE_DISTRIBUTED_DB_CATALOG"
    OPERATION_TYPE_CREATE_DISTRIBUTED_DB_CATALOG = "CREATE_DISTRIBUTED_DB_CATALOG"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CREATE_DISTRIBUTED_DB_GSM"
    OPERATION_TYPE_CREATE_DISTRIBUTED_DB_GSM = "CREATE_DISTRIBUTED_DB_GSM"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "UPDATE_DISTRIBUTED_DB_CATALOG_SHARDS"
    OPERATION_TYPE_UPDATE_DISTRIBUTED_DB_CATALOG_SHARDS = "UPDATE_DISTRIBUTED_DB_CATALOG_SHARDS"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "VALIDATE_NETWORK"
    OPERATION_TYPE_VALIDATE_NETWORK = "VALIDATE_NETWORK"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "EXECUTE_VALIDATE_NETWORK_TESTS"
    OPERATION_TYPE_EXECUTE_VALIDATE_NETWORK_TESTS = "EXECUTE_VALIDATE_NETWORK_TESTS"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CREATE_PRIVATE_ENDPOINT"
    OPERATION_TYPE_CREATE_PRIVATE_ENDPOINT = "CREATE_PRIVATE_ENDPOINT"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "DELETE_PRIVATE_ENDPOINT"
    OPERATION_TYPE_DELETE_PRIVATE_ENDPOINT = "DELETE_PRIVATE_ENDPOINT"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CHANGE_PRIVATE_ENDPOINT_COMPARTMENT"
    OPERATION_TYPE_CHANGE_PRIVATE_ENDPOINT_COMPARTMENT = "CHANGE_PRIVATE_ENDPOINT_COMPARTMENT"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "REINSTATE_PROXY_INSTANCE"
    OPERATION_TYPE_REINSTATE_PROXY_INSTANCE = "REINSTATE_PROXY_INSTANCE"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "DELETE_DISTRIBUTED_DB_SHARD"
    OPERATION_TYPE_DELETE_DISTRIBUTED_DB_SHARD = "DELETE_DISTRIBUTED_DB_SHARD"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "DELETE_DISTRIBUTED_DB_CATALOG"
    OPERATION_TYPE_DELETE_DISTRIBUTED_DB_CATALOG = "DELETE_DISTRIBUTED_DB_CATALOG"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "DELETE_DISTRIBUTED_DB_GSM"
    OPERATION_TYPE_DELETE_DISTRIBUTED_DB_GSM = "DELETE_DISTRIBUTED_DB_GSM"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "ADD_GDSCONTROL_NODE"
    OPERATION_TYPE_ADD_GDSCONTROL_NODE = "ADD_GDSCONTROL_NODE"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "CHANGE_DISTRIBUTED_DB_BACKUP_CONFIG"
    OPERATION_TYPE_CHANGE_DISTRIBUTED_DB_BACKUP_CONFIG = "CHANGE_DISTRIBUTED_DB_BACKUP_CONFIG"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "ADD_DISTRIBUTED_DB_DG"
    OPERATION_TYPE_ADD_DISTRIBUTED_DB_DG = "ADD_DISTRIBUTED_DB_DG"

    #: A constant which can be used with the operation_type property of a WorkRequestSummary.
    #: This constant has a value of "REMOVE_DISTRIBUTED_DB_DG"
    OPERATION_TYPE_REMOVE_DISTRIBUTED_DB_DG = "REMOVE_DISTRIBUTED_DB_DG"

    #: A constant which can be used with the status property of a WorkRequestSummary.
    #: This constant has a value of "ACCEPTED"
    STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the status property of a WorkRequestSummary.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a WorkRequestSummary.
    #: This constant has a value of "WAITING"
    STATUS_WAITING = "WAITING"

    #: A constant which can be used with the status property of a WorkRequestSummary.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a WorkRequestSummary.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a WorkRequestSummary.
    #: This constant has a value of "CANCELING"
    STATUS_CANCELING = "CANCELING"

    #: A constant which can be used with the status property of a WorkRequestSummary.
    #: This constant has a value of "CANCELED"
    STATUS_CANCELED = "CANCELED"

    #: A constant which can be used with the status property of a WorkRequestSummary.
    #: This constant has a value of "NEEDS_ATTENTION"
    STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new WorkRequestSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation_type:
            The value to assign to the operation_type property of this WorkRequestSummary.
            Allowed values for this property are: "CREATE_DISTRIBUTED_DB", "PATCH_DISTRIBUTED_DB_INSERT_SHARDS", "PATCH_DISTRIBUTED_DB_REMOVE_SHARDS", "PATCH_DISTRIBUTED_DB_MERGE_CATALOG_SHARDS", "DELETE_DISTRIBUTED_DB", "CHANGE_DISTRIBUTED_DB_COMPARTMENT", "CONFIGURE_DISTRIBUTED_DB_GSMS", "CONFIGURE_DISTRIBUTED_DB_SHARDING", "GENERATE_DISTRIBUTED_DB_GSM_CERT_SIGNING_REQ", "ROTATE_DISTRIBUTED_DB_PASSWORDS", "START_DISTRIBUTED_DB", "STOP_DISTRIBUTED_DB", "START_DISTRIBUTED_DB_SHARD", "START_DISTRIBUTED_DB_CATALOG", "STOP_DISTRIBUTED_DB_SHARD", "STOP_DISTRIBUTED_DB_CATALOG", "UPLOAD_DISTRIBUTED_DB_SIGNED_CERT_AND_GENERATE_WALLET", "CREATE_DISTRIBUTED_DB_SHARD", "CREATE_DISTRIBUTED_DB_CATALOG", "CREATE_DISTRIBUTED_DB_GSM", "UPDATE_DISTRIBUTED_DB_CATALOG_SHARDS", "VALIDATE_NETWORK", "EXECUTE_VALIDATE_NETWORK_TESTS", "CREATE_PRIVATE_ENDPOINT", "DELETE_PRIVATE_ENDPOINT", "CHANGE_PRIVATE_ENDPOINT_COMPARTMENT", "REINSTATE_PROXY_INSTANCE", "DELETE_DISTRIBUTED_DB_SHARD", "DELETE_DISTRIBUTED_DB_CATALOG", "DELETE_DISTRIBUTED_DB_GSM", "ADD_GDSCONTROL_NODE", "CHANGE_DISTRIBUTED_DB_BACKUP_CONFIG", "ADD_DISTRIBUTED_DB_DG", "REMOVE_DISTRIBUTED_DB_DG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_type: str

        :param status:
            The value to assign to the status property of this WorkRequestSummary.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param id:
            The value to assign to the id property of this WorkRequestSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this WorkRequestSummary.
        :type compartment_id: str

        :param resources:
            The value to assign to the resources property of this WorkRequestSummary.
        :type resources: list[oci.distributed_database.models.WorkRequestResource]

        :param percent_complete:
            The value to assign to the percent_complete property of this WorkRequestSummary.
        :type percent_complete: float

        :param time_accepted:
            The value to assign to the time_accepted property of this WorkRequestSummary.
        :type time_accepted: datetime

        :param time_started:
            The value to assign to the time_started property of this WorkRequestSummary.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this WorkRequestSummary.
        :type time_finished: datetime

        """
        self.swagger_types = {
            'operation_type': 'str',
            'status': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'resources': 'list[WorkRequestResource]',
            'percent_complete': 'float',
            'time_accepted': 'datetime',
            'time_started': 'datetime',
            'time_finished': 'datetime'
        }
        self.attribute_map = {
            'operation_type': 'operationType',
            'status': 'status',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'resources': 'resources',
            'percent_complete': 'percentComplete',
            'time_accepted': 'timeAccepted',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished'
        }
        self._operation_type = None
        self._status = None
        self._id = None
        self._compartment_id = None
        self._resources = None
        self._percent_complete = None
        self._time_accepted = None
        self._time_started = None
        self._time_finished = None

    @property
    def operation_type(self):
        """
        **[Required]** Gets the operation_type of this WorkRequestSummary.
        Type of the work request

        Allowed values for this property are: "CREATE_DISTRIBUTED_DB", "PATCH_DISTRIBUTED_DB_INSERT_SHARDS", "PATCH_DISTRIBUTED_DB_REMOVE_SHARDS", "PATCH_DISTRIBUTED_DB_MERGE_CATALOG_SHARDS", "DELETE_DISTRIBUTED_DB", "CHANGE_DISTRIBUTED_DB_COMPARTMENT", "CONFIGURE_DISTRIBUTED_DB_GSMS", "CONFIGURE_DISTRIBUTED_DB_SHARDING", "GENERATE_DISTRIBUTED_DB_GSM_CERT_SIGNING_REQ", "ROTATE_DISTRIBUTED_DB_PASSWORDS", "START_DISTRIBUTED_DB", "STOP_DISTRIBUTED_DB", "START_DISTRIBUTED_DB_SHARD", "START_DISTRIBUTED_DB_CATALOG", "STOP_DISTRIBUTED_DB_SHARD", "STOP_DISTRIBUTED_DB_CATALOG", "UPLOAD_DISTRIBUTED_DB_SIGNED_CERT_AND_GENERATE_WALLET", "CREATE_DISTRIBUTED_DB_SHARD", "CREATE_DISTRIBUTED_DB_CATALOG", "CREATE_DISTRIBUTED_DB_GSM", "UPDATE_DISTRIBUTED_DB_CATALOG_SHARDS", "VALIDATE_NETWORK", "EXECUTE_VALIDATE_NETWORK_TESTS", "CREATE_PRIVATE_ENDPOINT", "DELETE_PRIVATE_ENDPOINT", "CHANGE_PRIVATE_ENDPOINT_COMPARTMENT", "REINSTATE_PROXY_INSTANCE", "DELETE_DISTRIBUTED_DB_SHARD", "DELETE_DISTRIBUTED_DB_CATALOG", "DELETE_DISTRIBUTED_DB_GSM", "ADD_GDSCONTROL_NODE", "CHANGE_DISTRIBUTED_DB_BACKUP_CONFIG", "ADD_DISTRIBUTED_DB_DG", "REMOVE_DISTRIBUTED_DB_DG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_type of this WorkRequestSummary.
        :rtype: str
        """
        return self._operation_type

    @operation_type.setter
    def operation_type(self, operation_type):
        """
        Sets the operation_type of this WorkRequestSummary.
        Type of the work request


        :param operation_type: The operation_type of this WorkRequestSummary.
        :type: str
        """
        allowed_values = ["CREATE_DISTRIBUTED_DB", "PATCH_DISTRIBUTED_DB_INSERT_SHARDS", "PATCH_DISTRIBUTED_DB_REMOVE_SHARDS", "PATCH_DISTRIBUTED_DB_MERGE_CATALOG_SHARDS", "DELETE_DISTRIBUTED_DB", "CHANGE_DISTRIBUTED_DB_COMPARTMENT", "CONFIGURE_DISTRIBUTED_DB_GSMS", "CONFIGURE_DISTRIBUTED_DB_SHARDING", "GENERATE_DISTRIBUTED_DB_GSM_CERT_SIGNING_REQ", "ROTATE_DISTRIBUTED_DB_PASSWORDS", "START_DISTRIBUTED_DB", "STOP_DISTRIBUTED_DB", "START_DISTRIBUTED_DB_SHARD", "START_DISTRIBUTED_DB_CATALOG", "STOP_DISTRIBUTED_DB_SHARD", "STOP_DISTRIBUTED_DB_CATALOG", "UPLOAD_DISTRIBUTED_DB_SIGNED_CERT_AND_GENERATE_WALLET", "CREATE_DISTRIBUTED_DB_SHARD", "CREATE_DISTRIBUTED_DB_CATALOG", "CREATE_DISTRIBUTED_DB_GSM", "UPDATE_DISTRIBUTED_DB_CATALOG_SHARDS", "VALIDATE_NETWORK", "EXECUTE_VALIDATE_NETWORK_TESTS", "CREATE_PRIVATE_ENDPOINT", "DELETE_PRIVATE_ENDPOINT", "CHANGE_PRIVATE_ENDPOINT_COMPARTMENT", "REINSTATE_PROXY_INSTANCE", "DELETE_DISTRIBUTED_DB_SHARD", "DELETE_DISTRIBUTED_DB_CATALOG", "DELETE_DISTRIBUTED_DB_GSM", "ADD_GDSCONTROL_NODE", "CHANGE_DISTRIBUTED_DB_BACKUP_CONFIG", "ADD_DISTRIBUTED_DB_DG", "REMOVE_DISTRIBUTED_DB_DG"]
        if not value_allowed_none_or_none_sentinel(operation_type, allowed_values):
            operation_type = 'UNKNOWN_ENUM_VALUE'
        self._operation_type = operation_type

    @property
    def status(self):
        """
        **[Required]** Gets the status of this WorkRequestSummary.
        Status of current work request.

        Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this WorkRequestSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this WorkRequestSummary.
        Status of current work request.


        :param status: The status of this WorkRequestSummary.
        :type: str
        """
        allowed_values = ["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def id(self):
        """
        **[Required]** Gets the id of this WorkRequestSummary.
        The id of the work request.


        :return: The id of this WorkRequestSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WorkRequestSummary.
        The id of the work request.


        :param id: The id of this WorkRequestSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this WorkRequestSummary.
        The ocid of the compartment that contains the work request. Work requests should be scoped to
        the same compartment as the resource the work request affects. If the work request affects multiple resources,
        and those resources are not in the same compartment, it is up to the service team to pick the primary
        resource whose compartment should be used


        :return: The compartment_id of this WorkRequestSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this WorkRequestSummary.
        The ocid of the compartment that contains the work request. Work requests should be scoped to
        the same compartment as the resource the work request affects. If the work request affects multiple resources,
        and those resources are not in the same compartment, it is up to the service team to pick the primary
        resource whose compartment should be used


        :param compartment_id: The compartment_id of this WorkRequestSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resources(self):
        """
        **[Required]** Gets the resources of this WorkRequestSummary.
        The resources affected by this work request.


        :return: The resources of this WorkRequestSummary.
        :rtype: list[oci.distributed_database.models.WorkRequestResource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this WorkRequestSummary.
        The resources affected by this work request.


        :param resources: The resources of this WorkRequestSummary.
        :type: list[oci.distributed_database.models.WorkRequestResource]
        """
        self._resources = resources

    @property
    def percent_complete(self):
        """
        **[Required]** Gets the percent_complete of this WorkRequestSummary.
        Percentage of the request completed.


        :return: The percent_complete of this WorkRequestSummary.
        :rtype: float
        """
        return self._percent_complete

    @percent_complete.setter
    def percent_complete(self, percent_complete):
        """
        Sets the percent_complete of this WorkRequestSummary.
        Percentage of the request completed.


        :param percent_complete: The percent_complete of this WorkRequestSummary.
        :type: float
        """
        self._percent_complete = percent_complete

    @property
    def time_accepted(self):
        """
        **[Required]** Gets the time_accepted of this WorkRequestSummary.
        The date and time the request was created, as described in
        `RFC 3339`__, section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_accepted of this WorkRequestSummary.
        :rtype: datetime
        """
        return self._time_accepted

    @time_accepted.setter
    def time_accepted(self, time_accepted):
        """
        Sets the time_accepted of this WorkRequestSummary.
        The date and time the request was created, as described in
        `RFC 3339`__, section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_accepted: The time_accepted of this WorkRequestSummary.
        :type: datetime
        """
        self._time_accepted = time_accepted

    @property
    def time_started(self):
        """
        Gets the time_started of this WorkRequestSummary.
        The date and time the request was started, as described in `RFC 3339`__,
        section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this WorkRequestSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this WorkRequestSummary.
        The date and time the request was started, as described in `RFC 3339`__,
        section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this WorkRequestSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        Gets the time_finished of this WorkRequestSummary.
        The date and time the object was finished, as described in `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_finished of this WorkRequestSummary.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this WorkRequestSummary.
        The date and time the object was finished, as described in `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_finished: The time_finished of this WorkRequestSummary.
        :type: datetime
        """
        self._time_finished = time_finished

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
