# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImageVariableDependsOn(object):
    """
    Depends On object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImageVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ImageVariableDependsOn.
        :type compartment_id: str

        :param shape:
            The value to assign to the shape property of this ImageVariableDependsOn.
        :type shape: str

        :param operating_system:
            The value to assign to the operating_system property of this ImageVariableDependsOn.
        :type operating_system: str

        :param operating_system_version:
            The value to assign to the operating_system_version property of this ImageVariableDependsOn.
        :type operating_system_version: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'shape': 'str',
            'operating_system': 'str',
            'operating_system_version': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'shape': 'shape',
            'operating_system': 'operatingSystem',
            'operating_system_version': 'operatingSystemVersion'
        }
        self._compartment_id = None
        self._shape = None
        self._operating_system = None
        self._operating_system_version = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ImageVariableDependsOn.
        OCID for the compartment.


        :return: The compartment_id of this ImageVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ImageVariableDependsOn.
        OCID for the compartment.


        :param compartment_id: The compartment_id of this ImageVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def shape(self):
        """
        Gets the shape of this ImageVariableDependsOn.
        Compute shape required for the image.


        :return: The shape of this ImageVariableDependsOn.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ImageVariableDependsOn.
        Compute shape required for the image.


        :param shape: The shape of this ImageVariableDependsOn.
        :type: str
        """
        self._shape = shape

    @property
    def operating_system(self):
        """
        Gets the operating_system of this ImageVariableDependsOn.
        Name of the required operating system.


        :return: The operating_system of this ImageVariableDependsOn.
        :rtype: str
        """
        return self._operating_system

    @operating_system.setter
    def operating_system(self, operating_system):
        """
        Sets the operating_system of this ImageVariableDependsOn.
        Name of the required operating system.


        :param operating_system: The operating_system of this ImageVariableDependsOn.
        :type: str
        """
        self._operating_system = operating_system

    @property
    def operating_system_version(self):
        """
        Gets the operating_system_version of this ImageVariableDependsOn.
        Required operating system version.


        :return: The operating_system_version of this ImageVariableDependsOn.
        :rtype: str
        """
        return self._operating_system_version

    @operating_system_version.setter
    def operating_system_version(self, operating_system_version):
        """
        Sets the operating_system_version of this ImageVariableDependsOn.
        Required operating system version.


        :param operating_system_version: The operating_system_version of this ImageVariableDependsOn.
        :type: str
        """
        self._operating_system_version = operating_system_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
