# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InventoryRecordPatchDetails(object):
    """
    Details about an installed patch on the target
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InventoryRecordPatchDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param patch_id:
            The value to assign to the patch_id property of this InventoryRecordPatchDetails.
        :type patch_id: str

        :param patch_name:
            The value to assign to the patch_name property of this InventoryRecordPatchDetails.
        :type patch_name: str

        :param patch_description:
            The value to assign to the patch_description property of this InventoryRecordPatchDetails.
        :type patch_description: str

        :param time_applied:
            The value to assign to the time_applied property of this InventoryRecordPatchDetails.
        :type time_applied: datetime

        :param patch_type:
            The value to assign to the patch_type property of this InventoryRecordPatchDetails.
        :type patch_type: str

        :param time_released:
            The value to assign to the time_released property of this InventoryRecordPatchDetails.
        :type time_released: datetime

        :param patch_level:
            The value to assign to the patch_level property of this InventoryRecordPatchDetails.
        :type patch_level: str

        """
        self.swagger_types = {
            'patch_id': 'str',
            'patch_name': 'str',
            'patch_description': 'str',
            'time_applied': 'datetime',
            'patch_type': 'str',
            'time_released': 'datetime',
            'patch_level': 'str'
        }
        self.attribute_map = {
            'patch_id': 'patchId',
            'patch_name': 'patchName',
            'patch_description': 'patchDescription',
            'time_applied': 'timeApplied',
            'patch_type': 'patchType',
            'time_released': 'timeReleased',
            'patch_level': 'patchLevel'
        }
        self._patch_id = None
        self._patch_name = None
        self._patch_description = None
        self._time_applied = None
        self._patch_type = None
        self._time_released = None
        self._patch_level = None

    @property
    def patch_id(self):
        """
        Gets the patch_id of this InventoryRecordPatchDetails.
        OCID of the installed patch


        :return: The patch_id of this InventoryRecordPatchDetails.
        :rtype: str
        """
        return self._patch_id

    @patch_id.setter
    def patch_id(self, patch_id):
        """
        Sets the patch_id of this InventoryRecordPatchDetails.
        OCID of the installed patch


        :param patch_id: The patch_id of this InventoryRecordPatchDetails.
        :type: str
        """
        self._patch_id = patch_id

    @property
    def patch_name(self):
        """
        **[Required]** Gets the patch_name of this InventoryRecordPatchDetails.
        Name of the installed patch


        :return: The patch_name of this InventoryRecordPatchDetails.
        :rtype: str
        """
        return self._patch_name

    @patch_name.setter
    def patch_name(self, patch_name):
        """
        Sets the patch_name of this InventoryRecordPatchDetails.
        Name of the installed patch


        :param patch_name: The patch_name of this InventoryRecordPatchDetails.
        :type: str
        """
        self._patch_name = patch_name

    @property
    def patch_description(self):
        """
        **[Required]** Gets the patch_description of this InventoryRecordPatchDetails.
        Description for the installed patch


        :return: The patch_description of this InventoryRecordPatchDetails.
        :rtype: str
        """
        return self._patch_description

    @patch_description.setter
    def patch_description(self, patch_description):
        """
        Sets the patch_description of this InventoryRecordPatchDetails.
        Description for the installed patch


        :param patch_description: The patch_description of this InventoryRecordPatchDetails.
        :type: str
        """
        self._patch_description = patch_description

    @property
    def time_applied(self):
        """
        **[Required]** Gets the time_applied of this InventoryRecordPatchDetails.
        Date on which the patch was applied to the target


        :return: The time_applied of this InventoryRecordPatchDetails.
        :rtype: datetime
        """
        return self._time_applied

    @time_applied.setter
    def time_applied(self, time_applied):
        """
        Sets the time_applied of this InventoryRecordPatchDetails.
        Date on which the patch was applied to the target


        :param time_applied: The time_applied of this InventoryRecordPatchDetails.
        :type: datetime
        """
        self._time_applied = time_applied

    @property
    def patch_type(self):
        """
        **[Required]** Gets the patch_type of this InventoryRecordPatchDetails.
        Type of patch applied


        :return: The patch_type of this InventoryRecordPatchDetails.
        :rtype: str
        """
        return self._patch_type

    @patch_type.setter
    def patch_type(self, patch_type):
        """
        Sets the patch_type of this InventoryRecordPatchDetails.
        Type of patch applied


        :param patch_type: The patch_type of this InventoryRecordPatchDetails.
        :type: str
        """
        self._patch_type = patch_type

    @property
    def time_released(self):
        """
        Gets the time_released of this InventoryRecordPatchDetails.
        The date on which patch was released.


        :return: The time_released of this InventoryRecordPatchDetails.
        :rtype: datetime
        """
        return self._time_released

    @time_released.setter
    def time_released(self, time_released):
        """
        Sets the time_released of this InventoryRecordPatchDetails.
        The date on which patch was released.


        :param time_released: The time_released of this InventoryRecordPatchDetails.
        :type: datetime
        """
        self._time_released = time_released

    @property
    def patch_level(self):
        """
        Gets the patch_level of this InventoryRecordPatchDetails.
        Patch Level.


        :return: The patch_level of this InventoryRecordPatchDetails.
        :rtype: str
        """
        return self._patch_level

    @patch_level.setter
    def patch_level(self, patch_level):
        """
        Sets the patch_level of this InventoryRecordPatchDetails.
        Patch Level.


        :param patch_level: The patch_level of this InventoryRecordPatchDetails.
        :type: str
        """
        self._patch_level = patch_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
