# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedEntityAggregation(object):
    """
    Aggregated summary information for ManagedEntity
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedEntityAggregation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param count:
            The value to assign to the count property of this ManagedEntityAggregation.
        :type count: int

        :param dimensions:
            The value to assign to the dimensions property of this ManagedEntityAggregation.
        :type dimensions: oci.fleet_apps_management.models.ManagedEntityDimension

        """
        self.swagger_types = {
            'count': 'int',
            'dimensions': 'ManagedEntityDimension'
        }
        self.attribute_map = {
            'count': 'count',
            'dimensions': 'dimensions'
        }
        self._count = None
        self._dimensions = None

    @property
    def count(self):
        """
        **[Required]** Gets the count of this ManagedEntityAggregation.
        Count of managed entities in a compartment.


        :return: The count of this ManagedEntityAggregation.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this ManagedEntityAggregation.
        Count of managed entities in a compartment.


        :param count: The count of this ManagedEntityAggregation.
        :type: int
        """
        self._count = count

    @property
    def dimensions(self):
        """
        **[Required]** Gets the dimensions of this ManagedEntityAggregation.

        :return: The dimensions of this ManagedEntityAggregation.
        :rtype: oci.fleet_apps_management.models.ManagedEntityDimension
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this ManagedEntityAggregation.

        :param dimensions: The dimensions of this ManagedEntityAggregation.
        :type: oci.fleet_apps_management.models.ManagedEntityDimension
        """
        self._dimensions = dimensions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
