# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceTagEnablementInfo(object):
    """
    Resource tag enablement Information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceTagEnablementInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_id:
            The value to assign to the resource_id property of this ResourceTagEnablementInfo.
        :type resource_id: str

        :param is_tagging_possible:
            The value to assign to the is_tagging_possible property of this ResourceTagEnablementInfo.
        :type is_tagging_possible: bool

        """
        self.swagger_types = {
            'resource_id': 'str',
            'is_tagging_possible': 'bool'
        }
        self.attribute_map = {
            'resource_id': 'resourceId',
            'is_tagging_possible': 'isTaggingPossible'
        }
        self._resource_id = None
        self._is_tagging_possible = None

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this ResourceTagEnablementInfo.
        The OCID of the resource.


        :return: The resource_id of this ResourceTagEnablementInfo.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this ResourceTagEnablementInfo.
        The OCID of the resource.


        :param resource_id: The resource_id of this ResourceTagEnablementInfo.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def is_tagging_possible(self):
        """
        **[Required]** Gets the is_tagging_possible of this ResourceTagEnablementInfo.
        A value that represents if the resource can be tagged with a Fleet name.


        :return: The is_tagging_possible of this ResourceTagEnablementInfo.
        :rtype: bool
        """
        return self._is_tagging_possible

    @is_tagging_possible.setter
    def is_tagging_possible(self, is_tagging_possible):
        """
        Sets the is_tagging_possible of this ResourceTagEnablementInfo.
        A value that represents if the resource can be tagged with a Fleet name.


        :param is_tagging_possible: The is_tagging_possible of this ResourceTagEnablementInfo.
        :type: bool
        """
        self._is_tagging_possible = is_tagging_possible

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
