# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .discovery_details import DiscoveryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadbStackDiscoveryDetails(DiscoveryDetails):
    """
    Details to create an 'EXADB_STACK' type Exadata Fleet Update Discovery.
    Currently, components allowed in an Exadata software stack are 'GUEST_OS' and 'GI'.
    At least two distinct component types are required for an Exadata software stack.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadbStackDiscoveryDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.ExadbStackDiscoveryDetails.type` attribute
        of this class is ``EXADB_STACK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ExadbStackDiscoveryDetails.
            Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK"
        :type type: str

        :param service_type:
            The value to assign to the service_type property of this ExadbStackDiscoveryDetails.
            Allowed values for this property are: "EXACS", "EXACC"
        :type service_type: str

        :param components:
            The value to assign to the components property of this ExadbStackDiscoveryDetails.
        :type components: list[oci.fleet_software_update.models.SoftwareComponentDiscoveryDetails]

        """
        self.swagger_types = {
            'type': 'str',
            'service_type': 'str',
            'components': 'list[SoftwareComponentDiscoveryDetails]'
        }
        self.attribute_map = {
            'type': 'type',
            'service_type': 'serviceType',
            'components': 'components'
        }
        self._type = None
        self._service_type = None
        self._components = None
        self._type = 'EXADB_STACK'

    @property
    def components(self):
        """
        **[Required]** Gets the components of this ExadbStackDiscoveryDetails.
        Discovery filter details of components in an Exadata software stack.


        :return: The components of this ExadbStackDiscoveryDetails.
        :rtype: list[oci.fleet_software_update.models.SoftwareComponentDiscoveryDetails]
        """
        return self._components

    @components.setter
    def components(self, components):
        """
        Sets the components of this ExadbStackDiscoveryDetails.
        Discovery filter details of components in an Exadata software stack.


        :param components: The components of this ExadbStackDiscoveryDetails.
        :type: list[oci.fleet_software_update.models.SoftwareComponentDiscoveryDetails]
        """
        self._components = components

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
