# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .guest_os_fleet_discovery_filter import GuestOsFleetDiscoveryFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuestOsResourceIdFilter(GuestOsFleetDiscoveryFilter):
    """
    The `OCIDs`__ of associated resources to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.

    __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
    """

    #: A constant which can be used with the entity_type property of a GuestOsResourceIdFilter.
    #: This constant has a value of "EXADATAINFRASTRUCTURE"
    ENTITY_TYPE_EXADATAINFRASTRUCTURE = "EXADATAINFRASTRUCTURE"

    #: A constant which can be used with the entity_type property of a GuestOsResourceIdFilter.
    #: This constant has a value of "CLOUDEXADATAINFRASTRUCTURE"
    ENTITY_TYPE_CLOUDEXADATAINFRASTRUCTURE = "CLOUDEXADATAINFRASTRUCTURE"

    #: A constant which can be used with the entity_type property of a GuestOsResourceIdFilter.
    #: This constant has a value of "VMCLUSTER"
    ENTITY_TYPE_VMCLUSTER = "VMCLUSTER"

    #: A constant which can be used with the entity_type property of a GuestOsResourceIdFilter.
    #: This constant has a value of "CLOUDVMCLUSTER"
    ENTITY_TYPE_CLOUDVMCLUSTER = "CLOUDVMCLUSTER"

    #: A constant which can be used with the entity_type property of a GuestOsResourceIdFilter.
    #: This constant has a value of "FSUCOLLECTION"
    ENTITY_TYPE_FSUCOLLECTION = "FSUCOLLECTION"

    #: A constant which can be used with the operator property of a GuestOsResourceIdFilter.
    #: This constant has a value of "AND"
    OPERATOR_AND = "AND"

    #: A constant which can be used with the operator property of a GuestOsResourceIdFilter.
    #: This constant has a value of "OR"
    OPERATOR_OR = "OR"

    def __init__(self, **kwargs):
        """
        Initializes a new GuestOsResourceIdFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GuestOsResourceIdFilter.type` attribute
        of this class is ``RESOURCE_ID`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GuestOsResourceIdFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "VERSION", "EXADATA_RELEASE_VERSION", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param mode:
            The value to assign to the mode property of this GuestOsResourceIdFilter.
            Allowed values for this property are: "INCLUDE", "EXCLUDE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mode: str

        :param entity_type:
            The value to assign to the entity_type property of this GuestOsResourceIdFilter.
            Allowed values for this property are: "EXADATAINFRASTRUCTURE", "CLOUDEXADATAINFRASTRUCTURE", "VMCLUSTER", "CLOUDVMCLUSTER", "FSUCOLLECTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type entity_type: str

        :param identifiers:
            The value to assign to the identifiers property of this GuestOsResourceIdFilter.
        :type identifiers: list[str]

        :param operator:
            The value to assign to the operator property of this GuestOsResourceIdFilter.
            Allowed values for this property are: "AND", "OR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operator: str

        """
        self.swagger_types = {
            'type': 'str',
            'mode': 'str',
            'entity_type': 'str',
            'identifiers': 'list[str]',
            'operator': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'mode': 'mode',
            'entity_type': 'entityType',
            'identifiers': 'identifiers',
            'operator': 'operator'
        }
        self._type = None
        self._mode = None
        self._entity_type = None
        self._identifiers = None
        self._operator = None
        self._type = 'RESOURCE_ID'

    @property
    def entity_type(self):
        """
        **[Required]** Gets the entity_type of this GuestOsResourceIdFilter.
        Type of associated resource.

        Allowed values for this property are: "EXADATAINFRASTRUCTURE", "CLOUDEXADATAINFRASTRUCTURE", "VMCLUSTER", "CLOUDVMCLUSTER", "FSUCOLLECTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The entity_type of this GuestOsResourceIdFilter.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this GuestOsResourceIdFilter.
        Type of associated resource.


        :param entity_type: The entity_type of this GuestOsResourceIdFilter.
        :type: str
        """
        allowed_values = ["EXADATAINFRASTRUCTURE", "CLOUDEXADATAINFRASTRUCTURE", "VMCLUSTER", "CLOUDVMCLUSTER", "FSUCOLLECTION"]
        if not value_allowed_none_or_none_sentinel(entity_type, allowed_values):
            entity_type = 'UNKNOWN_ENUM_VALUE'
        self._entity_type = entity_type

    @property
    def identifiers(self):
        """
        **[Required]** Gets the identifiers of this GuestOsResourceIdFilter.
        The `OCIDs`__ of associated resources to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.
        Specified resources must match the specified 'entityType'.
        FsuCollection of type 'GI' or 'GUEST_OS' can be specified.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The identifiers of this GuestOsResourceIdFilter.
        :rtype: list[str]
        """
        return self._identifiers

    @identifiers.setter
    def identifiers(self, identifiers):
        """
        Sets the identifiers of this GuestOsResourceIdFilter.
        The `OCIDs`__ of associated resources to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.
        Specified resources must match the specified 'entityType'.
        FsuCollection of type 'GI' or 'GUEST_OS' can be specified.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param identifiers: The identifiers of this GuestOsResourceIdFilter.
        :type: list[str]
        """
        self._identifiers = identifiers

    @property
    def operator(self):
        """
        Gets the operator of this GuestOsResourceIdFilter.
        Type of join for each element in this filter.

        Allowed values for this property are: "AND", "OR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operator of this GuestOsResourceIdFilter.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this GuestOsResourceIdFilter.
        Type of join for each element in this filter.


        :param operator: The operator of this GuestOsResourceIdFilter.
        :type: str
        """
        allowed_values = ["AND", "OR"]
        if not value_allowed_none_or_none_sentinel(operator, allowed_values):
            operator = 'UNKNOWN_ENUM_VALUE'
        self._operator = operator

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
