# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateToolDetails(object):
    """
    The data to create a Tool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateToolDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateToolDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateToolDetails.
        :type description: str

        :param agent_id:
            The value to assign to the agent_id property of this CreateToolDetails.
        :type agent_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateToolDetails.
        :type compartment_id: str

        :param tool_config:
            The value to assign to the tool_config property of this CreateToolDetails.
        :type tool_config: oci.generative_ai_agent.models.ToolConfig

        :param metadata:
            The value to assign to the metadata property of this CreateToolDetails.
        :type metadata: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateToolDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateToolDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'agent_id': 'str',
            'compartment_id': 'str',
            'tool_config': 'ToolConfig',
            'metadata': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'agent_id': 'agentId',
            'compartment_id': 'compartmentId',
            'tool_config': 'toolConfig',
            'metadata': 'metadata',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._agent_id = None
        self._compartment_id = None
        self._tool_config = None
        self._metadata = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateToolDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateToolDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateToolDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateToolDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this CreateToolDetails.
        Description about the Tool.


        :return: The description of this CreateToolDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateToolDetails.
        Description about the Tool.


        :param description: The description of this CreateToolDetails.
        :type: str
        """
        self._description = description

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this CreateToolDetails.
        The OCID of the agent that this Tool is attached to.


        :return: The agent_id of this CreateToolDetails.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this CreateToolDetails.
        The OCID of the agent that this Tool is attached to.


        :param agent_id: The agent_id of this CreateToolDetails.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateToolDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateToolDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateToolDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateToolDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def tool_config(self):
        """
        **[Required]** Gets the tool_config of this CreateToolDetails.

        :return: The tool_config of this CreateToolDetails.
        :rtype: oci.generative_ai_agent.models.ToolConfig
        """
        return self._tool_config

    @tool_config.setter
    def tool_config(self, tool_config):
        """
        Sets the tool_config of this CreateToolDetails.

        :param tool_config: The tool_config of this CreateToolDetails.
        :type: oci.generative_ai_agent.models.ToolConfig
        """
        self._tool_config = tool_config

    @property
    def metadata(self):
        """
        Gets the metadata of this CreateToolDetails.
        Key-value pairs to allow additional configurations.


        :return: The metadata of this CreateToolDetails.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this CreateToolDetails.
        Key-value pairs to allow additional configurations.


        :param metadata: The metadata of this CreateToolDetails.
        :type: dict(str, str)
        """
        self._metadata = metadata

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateToolDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateToolDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateToolDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateToolDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateToolDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateToolDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateToolDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateToolDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
