# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HttpEndpointAuthSource(object):
    """
    A credential source and configuration for a specific scope to HTTP Endpoint tools.
    """

    #: A constant which can be used with the http_endpoint_auth_scope property of a HttpEndpointAuthSource.
    #: This constant has a value of "AGENT"
    HTTP_ENDPOINT_AUTH_SCOPE_AGENT = "AGENT"

    def __init__(self, **kwargs):
        """
        Initializes a new HttpEndpointAuthSource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param http_endpoint_auth_scope:
            The value to assign to the http_endpoint_auth_scope property of this HttpEndpointAuthSource.
            Allowed values for this property are: "AGENT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type http_endpoint_auth_scope: str

        :param http_endpoint_auth_scope_config:
            The value to assign to the http_endpoint_auth_scope_config property of this HttpEndpointAuthSource.
        :type http_endpoint_auth_scope_config: oci.generative_ai_agent.models.HttpEndpointAuthScopeConfig

        """
        self.swagger_types = {
            'http_endpoint_auth_scope': 'str',
            'http_endpoint_auth_scope_config': 'HttpEndpointAuthScopeConfig'
        }
        self.attribute_map = {
            'http_endpoint_auth_scope': 'httpEndpointAuthScope',
            'http_endpoint_auth_scope_config': 'httpEndpointAuthScopeConfig'
        }
        self._http_endpoint_auth_scope = None
        self._http_endpoint_auth_scope_config = None

    @property
    def http_endpoint_auth_scope(self):
        """
        **[Required]** Gets the http_endpoint_auth_scope of this HttpEndpointAuthSource.
        Specifies the level from which credentials should be resolved.

        Allowed values for this property are: "AGENT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The http_endpoint_auth_scope of this HttpEndpointAuthSource.
        :rtype: str
        """
        return self._http_endpoint_auth_scope

    @http_endpoint_auth_scope.setter
    def http_endpoint_auth_scope(self, http_endpoint_auth_scope):
        """
        Sets the http_endpoint_auth_scope of this HttpEndpointAuthSource.
        Specifies the level from which credentials should be resolved.


        :param http_endpoint_auth_scope: The http_endpoint_auth_scope of this HttpEndpointAuthSource.
        :type: str
        """
        allowed_values = ["AGENT"]
        if not value_allowed_none_or_none_sentinel(http_endpoint_auth_scope, allowed_values):
            http_endpoint_auth_scope = 'UNKNOWN_ENUM_VALUE'
        self._http_endpoint_auth_scope = http_endpoint_auth_scope

    @property
    def http_endpoint_auth_scope_config(self):
        """
        **[Required]** Gets the http_endpoint_auth_scope_config of this HttpEndpointAuthSource.

        :return: The http_endpoint_auth_scope_config of this HttpEndpointAuthSource.
        :rtype: oci.generative_ai_agent.models.HttpEndpointAuthScopeConfig
        """
        return self._http_endpoint_auth_scope_config

    @http_endpoint_auth_scope_config.setter
    def http_endpoint_auth_scope_config(self, http_endpoint_auth_scope_config):
        """
        Sets the http_endpoint_auth_scope_config of this HttpEndpointAuthSource.

        :param http_endpoint_auth_scope_config: The http_endpoint_auth_scope_config of this HttpEndpointAuthSource.
        :type: oci.generative_ai_agent.models.HttpEndpointAuthScopeConfig
        """
        self._http_endpoint_auth_scope_config = http_endpoint_auth_scope_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
