# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .index_config import IndexConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciOpenSearchIndexConfig(IndexConfig):
    """
    The details of customer managed OCI OpenSearch.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciOpenSearchIndexConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.OciOpenSearchIndexConfig.index_config_type` attribute
        of this class is ``OCI_OPEN_SEARCH_INDEX_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param index_config_type:
            The value to assign to the index_config_type property of this OciOpenSearchIndexConfig.
            Allowed values for this property are: "DEFAULT_INDEX_CONFIG", "OCI_OPEN_SEARCH_INDEX_CONFIG", "OCI_DATABASE_CONFIG"
        :type index_config_type: str

        :param cluster_id:
            The value to assign to the cluster_id property of this OciOpenSearchIndexConfig.
        :type cluster_id: str

        :param secret_detail:
            The value to assign to the secret_detail property of this OciOpenSearchIndexConfig.
        :type secret_detail: oci.generative_ai_agent.models.SecretDetail

        :param indexes:
            The value to assign to the indexes property of this OciOpenSearchIndexConfig.
        :type indexes: list[oci.generative_ai_agent.models.Index]

        """
        self.swagger_types = {
            'index_config_type': 'str',
            'cluster_id': 'str',
            'secret_detail': 'SecretDetail',
            'indexes': 'list[Index]'
        }
        self.attribute_map = {
            'index_config_type': 'indexConfigType',
            'cluster_id': 'clusterId',
            'secret_detail': 'secretDetail',
            'indexes': 'indexes'
        }
        self._index_config_type = None
        self._cluster_id = None
        self._secret_detail = None
        self._indexes = None
        self._index_config_type = 'OCI_OPEN_SEARCH_INDEX_CONFIG'

    @property
    def cluster_id(self):
        """
        **[Required]** Gets the cluster_id of this OciOpenSearchIndexConfig.
        The `OCID`__ of the OpenSearch Cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The cluster_id of this OciOpenSearchIndexConfig.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this OciOpenSearchIndexConfig.
        The `OCID`__ of the OpenSearch Cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param cluster_id: The cluster_id of this OciOpenSearchIndexConfig.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def secret_detail(self):
        """
        **[Required]** Gets the secret_detail of this OciOpenSearchIndexConfig.

        :return: The secret_detail of this OciOpenSearchIndexConfig.
        :rtype: oci.generative_ai_agent.models.SecretDetail
        """
        return self._secret_detail

    @secret_detail.setter
    def secret_detail(self, secret_detail):
        """
        Sets the secret_detail of this OciOpenSearchIndexConfig.

        :param secret_detail: The secret_detail of this OciOpenSearchIndexConfig.
        :type: oci.generative_ai_agent.models.SecretDetail
        """
        self._secret_detail = secret_detail

    @property
    def indexes(self):
        """
        **[Required]** Gets the indexes of this OciOpenSearchIndexConfig.
        Index configuration for open search.


        :return: The indexes of this OciOpenSearchIndexConfig.
        :rtype: list[oci.generative_ai_agent.models.Index]
        """
        return self._indexes

    @indexes.setter
    def indexes(self, indexes):
        """
        Sets the indexes of this OciOpenSearchIndexConfig.
        Index configuration for open search.


        :param indexes: The indexes of this OciOpenSearchIndexConfig.
        :type: list[oci.generative_ai_agent.models.Index]
        """
        self._indexes = indexes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
