# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .tool_config import ToolConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RagToolConfig(ToolConfig):
    """
    The configuration for RAG Tool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RagToolConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.RagToolConfig.tool_config_type` attribute
        of this class is ``RAG_TOOL_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_config_type:
            The value to assign to the tool_config_type property of this RagToolConfig.
            Allowed values for this property are: "SQL_TOOL_CONFIG", "RAG_TOOL_CONFIG", "FUNCTION_CALLING_TOOL_CONFIG", "HTTP_ENDPOINT_TOOL_CONFIG", "AGENT_TOOL_CONFIG"
        :type tool_config_type: str

        :param knowledge_base_configs:
            The value to assign to the knowledge_base_configs property of this RagToolConfig.
        :type knowledge_base_configs: list[oci.generative_ai_agent.models.KnowledgeBaseConfig]

        :param generation_llm_customization:
            The value to assign to the generation_llm_customization property of this RagToolConfig.
        :type generation_llm_customization: oci.generative_ai_agent.models.LlmCustomization

        :param runtime_version:
            The value to assign to the runtime_version property of this RagToolConfig.
        :type runtime_version: str

        :param embedding_llm_customization:
            The value to assign to the embedding_llm_customization property of this RagToolConfig.
        :type embedding_llm_customization: oci.generative_ai_agent.models.LlmCustomization

        :param reranking_llm_customization:
            The value to assign to the reranking_llm_customization property of this RagToolConfig.
        :type reranking_llm_customization: oci.generative_ai_agent.models.LlmCustomization

        :param reasoning_llm_customization:
            The value to assign to the reasoning_llm_customization property of this RagToolConfig.
        :type reasoning_llm_customization: oci.generative_ai_agent.models.LlmCustomization

        """
        self.swagger_types = {
            'tool_config_type': 'str',
            'knowledge_base_configs': 'list[KnowledgeBaseConfig]',
            'generation_llm_customization': 'LlmCustomization',
            'runtime_version': 'str',
            'embedding_llm_customization': 'LlmCustomization',
            'reranking_llm_customization': 'LlmCustomization',
            'reasoning_llm_customization': 'LlmCustomization'
        }
        self.attribute_map = {
            'tool_config_type': 'toolConfigType',
            'knowledge_base_configs': 'knowledgeBaseConfigs',
            'generation_llm_customization': 'generationLlmCustomization',
            'runtime_version': 'runtimeVersion',
            'embedding_llm_customization': 'embeddingLlmCustomization',
            'reranking_llm_customization': 'rerankingLlmCustomization',
            'reasoning_llm_customization': 'reasoningLlmCustomization'
        }
        self._tool_config_type = None
        self._knowledge_base_configs = None
        self._generation_llm_customization = None
        self._runtime_version = None
        self._embedding_llm_customization = None
        self._reranking_llm_customization = None
        self._reasoning_llm_customization = None
        self._tool_config_type = 'RAG_TOOL_CONFIG'

    @property
    def knowledge_base_configs(self):
        """
        **[Required]** Gets the knowledge_base_configs of this RagToolConfig.
        The KnowledgeBase configurations that this RAG Tool uses


        :return: The knowledge_base_configs of this RagToolConfig.
        :rtype: list[oci.generative_ai_agent.models.KnowledgeBaseConfig]
        """
        return self._knowledge_base_configs

    @knowledge_base_configs.setter
    def knowledge_base_configs(self, knowledge_base_configs):
        """
        Sets the knowledge_base_configs of this RagToolConfig.
        The KnowledgeBase configurations that this RAG Tool uses


        :param knowledge_base_configs: The knowledge_base_configs of this RagToolConfig.
        :type: list[oci.generative_ai_agent.models.KnowledgeBaseConfig]
        """
        self._knowledge_base_configs = knowledge_base_configs

    @property
    def generation_llm_customization(self):
        """
        Gets the generation_llm_customization of this RagToolConfig.

        :return: The generation_llm_customization of this RagToolConfig.
        :rtype: oci.generative_ai_agent.models.LlmCustomization
        """
        return self._generation_llm_customization

    @generation_llm_customization.setter
    def generation_llm_customization(self, generation_llm_customization):
        """
        Sets the generation_llm_customization of this RagToolConfig.

        :param generation_llm_customization: The generation_llm_customization of this RagToolConfig.
        :type: oci.generative_ai_agent.models.LlmCustomization
        """
        self._generation_llm_customization = generation_llm_customization

    @property
    def runtime_version(self):
        """
        Gets the runtime_version of this RagToolConfig.
        The runtimeVersion of the system prompt.


        :return: The runtime_version of this RagToolConfig.
        :rtype: str
        """
        return self._runtime_version

    @runtime_version.setter
    def runtime_version(self, runtime_version):
        """
        Sets the runtime_version of this RagToolConfig.
        The runtimeVersion of the system prompt.


        :param runtime_version: The runtime_version of this RagToolConfig.
        :type: str
        """
        self._runtime_version = runtime_version

    @property
    def embedding_llm_customization(self):
        """
        Gets the embedding_llm_customization of this RagToolConfig.

        :return: The embedding_llm_customization of this RagToolConfig.
        :rtype: oci.generative_ai_agent.models.LlmCustomization
        """
        return self._embedding_llm_customization

    @embedding_llm_customization.setter
    def embedding_llm_customization(self, embedding_llm_customization):
        """
        Sets the embedding_llm_customization of this RagToolConfig.

        :param embedding_llm_customization: The embedding_llm_customization of this RagToolConfig.
        :type: oci.generative_ai_agent.models.LlmCustomization
        """
        self._embedding_llm_customization = embedding_llm_customization

    @property
    def reranking_llm_customization(self):
        """
        Gets the reranking_llm_customization of this RagToolConfig.

        :return: The reranking_llm_customization of this RagToolConfig.
        :rtype: oci.generative_ai_agent.models.LlmCustomization
        """
        return self._reranking_llm_customization

    @reranking_llm_customization.setter
    def reranking_llm_customization(self, reranking_llm_customization):
        """
        Sets the reranking_llm_customization of this RagToolConfig.

        :param reranking_llm_customization: The reranking_llm_customization of this RagToolConfig.
        :type: oci.generative_ai_agent.models.LlmCustomization
        """
        self._reranking_llm_customization = reranking_llm_customization

    @property
    def reasoning_llm_customization(self):
        """
        Gets the reasoning_llm_customization of this RagToolConfig.

        :return: The reasoning_llm_customization of this RagToolConfig.
        :rtype: oci.generative_ai_agent.models.LlmCustomization
        """
        return self._reasoning_llm_customization

    @reasoning_llm_customization.setter
    def reasoning_llm_customization(self, reasoning_llm_customization):
        """
        Sets the reasoning_llm_customization of this RagToolConfig.

        :param reasoning_llm_customization: The reasoning_llm_customization of this RagToolConfig.
        :type: oci.generative_ai_agent.models.LlmCustomization
        """
        self._reasoning_llm_customization = reasoning_llm_customization

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
