# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .tool_config import ToolConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlToolConfig(ToolConfig):
    """
    The configuration for SQL Tool.
    """

    #: A constant which can be used with the dialect property of a SqlToolConfig.
    #: This constant has a value of "SQL_LITE"
    DIALECT_SQL_LITE = "SQL_LITE"

    #: A constant which can be used with the dialect property of a SqlToolConfig.
    #: This constant has a value of "ORACLE_SQL"
    DIALECT_ORACLE_SQL = "ORACLE_SQL"

    #: A constant which can be used with the model_size property of a SqlToolConfig.
    #: This constant has a value of "SMALL"
    MODEL_SIZE_SMALL = "SMALL"

    #: A constant which can be used with the model_size property of a SqlToolConfig.
    #: This constant has a value of "LARGE"
    MODEL_SIZE_LARGE = "LARGE"

    def __init__(self, **kwargs):
        """
        Initializes a new SqlToolConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.SqlToolConfig.tool_config_type` attribute
        of this class is ``SQL_TOOL_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_config_type:
            The value to assign to the tool_config_type property of this SqlToolConfig.
            Allowed values for this property are: "SQL_TOOL_CONFIG", "RAG_TOOL_CONFIG", "FUNCTION_CALLING_TOOL_CONFIG", "HTTP_ENDPOINT_TOOL_CONFIG", "AGENT_TOOL_CONFIG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type tool_config_type: str

        :param icl_examples:
            The value to assign to the icl_examples property of this SqlToolConfig.
        :type icl_examples: oci.generative_ai_agent.models.InputLocation

        :param database_schema:
            The value to assign to the database_schema property of this SqlToolConfig.
        :type database_schema: oci.generative_ai_agent.models.InputLocation

        :param should_enable_sql_execution:
            The value to assign to the should_enable_sql_execution property of this SqlToolConfig.
        :type should_enable_sql_execution: bool

        :param dialect:
            The value to assign to the dialect property of this SqlToolConfig.
            Allowed values for this property are: "SQL_LITE", "ORACLE_SQL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type dialect: str

        :param model_size:
            The value to assign to the model_size property of this SqlToolConfig.
            Allowed values for this property are: "SMALL", "LARGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type model_size: str

        :param should_enable_self_correction:
            The value to assign to the should_enable_self_correction property of this SqlToolConfig.
        :type should_enable_self_correction: bool

        :param table_and_column_description:
            The value to assign to the table_and_column_description property of this SqlToolConfig.
        :type table_and_column_description: oci.generative_ai_agent.models.InputLocation

        :param generation_llm_customization:
            The value to assign to the generation_llm_customization property of this SqlToolConfig.
        :type generation_llm_customization: oci.generative_ai_agent.models.LlmCustomization

        :param database_connection:
            The value to assign to the database_connection property of this SqlToolConfig.
        :type database_connection: oci.generative_ai_agent.models.DatabaseConnection

        :param runtime_version:
            The value to assign to the runtime_version property of this SqlToolConfig.
        :type runtime_version: str

        """
        self.swagger_types = {
            'tool_config_type': 'str',
            'icl_examples': 'InputLocation',
            'database_schema': 'InputLocation',
            'should_enable_sql_execution': 'bool',
            'dialect': 'str',
            'model_size': 'str',
            'should_enable_self_correction': 'bool',
            'table_and_column_description': 'InputLocation',
            'generation_llm_customization': 'LlmCustomization',
            'database_connection': 'DatabaseConnection',
            'runtime_version': 'str'
        }
        self.attribute_map = {
            'tool_config_type': 'toolConfigType',
            'icl_examples': 'iclExamples',
            'database_schema': 'databaseSchema',
            'should_enable_sql_execution': 'shouldEnableSqlExecution',
            'dialect': 'dialect',
            'model_size': 'modelSize',
            'should_enable_self_correction': 'shouldEnableSelfCorrection',
            'table_and_column_description': 'tableAndColumnDescription',
            'generation_llm_customization': 'generationLlmCustomization',
            'database_connection': 'databaseConnection',
            'runtime_version': 'runtimeVersion'
        }
        self._tool_config_type = None
        self._icl_examples = None
        self._database_schema = None
        self._should_enable_sql_execution = None
        self._dialect = None
        self._model_size = None
        self._should_enable_self_correction = None
        self._table_and_column_description = None
        self._generation_llm_customization = None
        self._database_connection = None
        self._runtime_version = None
        self._tool_config_type = 'SQL_TOOL_CONFIG'

    @property
    def icl_examples(self):
        """
        Gets the icl_examples of this SqlToolConfig.

        :return: The icl_examples of this SqlToolConfig.
        :rtype: oci.generative_ai_agent.models.InputLocation
        """
        return self._icl_examples

    @icl_examples.setter
    def icl_examples(self, icl_examples):
        """
        Sets the icl_examples of this SqlToolConfig.

        :param icl_examples: The icl_examples of this SqlToolConfig.
        :type: oci.generative_ai_agent.models.InputLocation
        """
        self._icl_examples = icl_examples

    @property
    def database_schema(self):
        """
        Gets the database_schema of this SqlToolConfig.

        :return: The database_schema of this SqlToolConfig.
        :rtype: oci.generative_ai_agent.models.InputLocation
        """
        return self._database_schema

    @database_schema.setter
    def database_schema(self, database_schema):
        """
        Sets the database_schema of this SqlToolConfig.

        :param database_schema: The database_schema of this SqlToolConfig.
        :type: oci.generative_ai_agent.models.InputLocation
        """
        self._database_schema = database_schema

    @property
    def should_enable_sql_execution(self):
        """
        Gets the should_enable_sql_execution of this SqlToolConfig.
        To enable/disable SQL execution.


        :return: The should_enable_sql_execution of this SqlToolConfig.
        :rtype: bool
        """
        return self._should_enable_sql_execution

    @should_enable_sql_execution.setter
    def should_enable_sql_execution(self, should_enable_sql_execution):
        """
        Sets the should_enable_sql_execution of this SqlToolConfig.
        To enable/disable SQL execution.


        :param should_enable_sql_execution: The should_enable_sql_execution of this SqlToolConfig.
        :type: bool
        """
        self._should_enable_sql_execution = should_enable_sql_execution

    @property
    def dialect(self):
        """
        **[Required]** Gets the dialect of this SqlToolConfig.
        Dialect to be used for SQL generation.

        Allowed values for this property are: "SQL_LITE", "ORACLE_SQL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The dialect of this SqlToolConfig.
        :rtype: str
        """
        return self._dialect

    @dialect.setter
    def dialect(self, dialect):
        """
        Sets the dialect of this SqlToolConfig.
        Dialect to be used for SQL generation.


        :param dialect: The dialect of this SqlToolConfig.
        :type: str
        """
        allowed_values = ["SQL_LITE", "ORACLE_SQL"]
        if not value_allowed_none_or_none_sentinel(dialect, allowed_values):
            dialect = 'UNKNOWN_ENUM_VALUE'
        self._dialect = dialect

    @property
    def model_size(self):
        """
        Gets the model_size of this SqlToolConfig.
        Size of the model.

        Allowed values for this property are: "SMALL", "LARGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The model_size of this SqlToolConfig.
        :rtype: str
        """
        return self._model_size

    @model_size.setter
    def model_size(self, model_size):
        """
        Sets the model_size of this SqlToolConfig.
        Size of the model.


        :param model_size: The model_size of this SqlToolConfig.
        :type: str
        """
        allowed_values = ["SMALL", "LARGE"]
        if not value_allowed_none_or_none_sentinel(model_size, allowed_values):
            model_size = 'UNKNOWN_ENUM_VALUE'
        self._model_size = model_size

    @property
    def should_enable_self_correction(self):
        """
        Gets the should_enable_self_correction of this SqlToolConfig.
        To enable/disable self correction.


        :return: The should_enable_self_correction of this SqlToolConfig.
        :rtype: bool
        """
        return self._should_enable_self_correction

    @should_enable_self_correction.setter
    def should_enable_self_correction(self, should_enable_self_correction):
        """
        Sets the should_enable_self_correction of this SqlToolConfig.
        To enable/disable self correction.


        :param should_enable_self_correction: The should_enable_self_correction of this SqlToolConfig.
        :type: bool
        """
        self._should_enable_self_correction = should_enable_self_correction

    @property
    def table_and_column_description(self):
        """
        Gets the table_and_column_description of this SqlToolConfig.

        :return: The table_and_column_description of this SqlToolConfig.
        :rtype: oci.generative_ai_agent.models.InputLocation
        """
        return self._table_and_column_description

    @table_and_column_description.setter
    def table_and_column_description(self, table_and_column_description):
        """
        Sets the table_and_column_description of this SqlToolConfig.

        :param table_and_column_description: The table_and_column_description of this SqlToolConfig.
        :type: oci.generative_ai_agent.models.InputLocation
        """
        self._table_and_column_description = table_and_column_description

    @property
    def generation_llm_customization(self):
        """
        Gets the generation_llm_customization of this SqlToolConfig.

        :return: The generation_llm_customization of this SqlToolConfig.
        :rtype: oci.generative_ai_agent.models.LlmCustomization
        """
        return self._generation_llm_customization

    @generation_llm_customization.setter
    def generation_llm_customization(self, generation_llm_customization):
        """
        Sets the generation_llm_customization of this SqlToolConfig.

        :param generation_llm_customization: The generation_llm_customization of this SqlToolConfig.
        :type: oci.generative_ai_agent.models.LlmCustomization
        """
        self._generation_llm_customization = generation_llm_customization

    @property
    def database_connection(self):
        """
        Gets the database_connection of this SqlToolConfig.

        :return: The database_connection of this SqlToolConfig.
        :rtype: oci.generative_ai_agent.models.DatabaseConnection
        """
        return self._database_connection

    @database_connection.setter
    def database_connection(self, database_connection):
        """
        Sets the database_connection of this SqlToolConfig.

        :param database_connection: The database_connection of this SqlToolConfig.
        :type: oci.generative_ai_agent.models.DatabaseConnection
        """
        self._database_connection = database_connection

    @property
    def runtime_version(self):
        """
        Gets the runtime_version of this SqlToolConfig.
        The runtimeVersion of the system prompt.


        :return: The runtime_version of this SqlToolConfig.
        :rtype: str
        """
        return self._runtime_version

    @runtime_version.setter
    def runtime_version(self, runtime_version):
        """
        Sets the runtime_version of this SqlToolConfig.
        The runtimeVersion of the system prompt.


        :param runtime_version: The runtime_version of this SqlToolConfig.
        :type: str
        """
        self._runtime_version = runtime_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
