# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CitationOptionsV2(object):
    """
    Options for controlling citation generation in RAG flows.
    """

    #: A constant which can be used with the mode property of a CitationOptionsV2.
    #: This constant has a value of "FAST"
    MODE_FAST = "FAST"

    #: A constant which can be used with the mode property of a CitationOptionsV2.
    #: This constant has a value of "ACCURATE"
    MODE_ACCURATE = "ACCURATE"

    #: A constant which can be used with the mode property of a CitationOptionsV2.
    #: This constant has a value of "OFF"
    MODE_OFF = "OFF"

    def __init__(self, **kwargs):
        """
        Initializes a new CitationOptionsV2 object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param mode:
            The value to assign to the mode property of this CitationOptionsV2.
            Allowed values for this property are: "FAST", "ACCURATE", "OFF"
        :type mode: str

        """
        self.swagger_types = {
            'mode': 'str'
        }
        self.attribute_map = {
            'mode': 'mode'
        }
        self._mode = None

    @property
    def mode(self):
        """
        Gets the mode of this CitationOptionsV2.
        Dictates the approach taken to generating citations as part of the RAG flow. Defaults to \"accurate\".   - \"ACCURATE\": More precise citation generation.   - \"FAST\": Faster but may be less precise.   - \"OFF\": Disables citation generation.   Note: `command-r7b-12-2024` and `command-a-03-2025` only support \"FAST\" and \"OFF\".

        Allowed values for this property are: "FAST", "ACCURATE", "OFF"


        :return: The mode of this CitationOptionsV2.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """
        Sets the mode of this CitationOptionsV2.
        Dictates the approach taken to generating citations as part of the RAG flow. Defaults to \"accurate\".   - \"ACCURATE\": More precise citation generation.   - \"FAST\": Faster but may be less precise.   - \"OFF\": Disables citation generation.   Note: `command-r7b-12-2024` and `command-a-03-2025` only support \"FAST\" and \"OFF\".


        :param mode: The mode of this CitationOptionsV2.
        :type: str
        """
        allowed_values = ["FAST", "ACCURATE", "OFF"]
        if not value_allowed_none_or_none_sentinel(mode, allowed_values):
            raise ValueError(
                f"Invalid value for `mode`, must be None or one of {allowed_values}"
            )
        self._mode = mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
