# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .base_chat_response import BaseChatResponse
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereChatResponse(BaseChatResponse):
    """
    The response to the chat conversation.
    """

    #: A constant which can be used with the finish_reason property of a CohereChatResponse.
    #: This constant has a value of "COMPLETE"
    FINISH_REASON_COMPLETE = "COMPLETE"

    #: A constant which can be used with the finish_reason property of a CohereChatResponse.
    #: This constant has a value of "ERROR_TOXIC"
    FINISH_REASON_ERROR_TOXIC = "ERROR_TOXIC"

    #: A constant which can be used with the finish_reason property of a CohereChatResponse.
    #: This constant has a value of "ERROR_LIMIT"
    FINISH_REASON_ERROR_LIMIT = "ERROR_LIMIT"

    #: A constant which can be used with the finish_reason property of a CohereChatResponse.
    #: This constant has a value of "ERROR"
    FINISH_REASON_ERROR = "ERROR"

    #: A constant which can be used with the finish_reason property of a CohereChatResponse.
    #: This constant has a value of "USER_CANCEL"
    FINISH_REASON_USER_CANCEL = "USER_CANCEL"

    #: A constant which can be used with the finish_reason property of a CohereChatResponse.
    #: This constant has a value of "MAX_TOKENS"
    FINISH_REASON_MAX_TOKENS = "MAX_TOKENS"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereChatResponse object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereChatResponse.api_format` attribute
        of this class is ``COHERE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param api_format:
            The value to assign to the api_format property of this CohereChatResponse.
            Allowed values for this property are: "COHERE", "GENERIC", "COHEREV2", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type api_format: str

        :param text:
            The value to assign to the text property of this CohereChatResponse.
        :type text: str

        :param chat_history:
            The value to assign to the chat_history property of this CohereChatResponse.
        :type chat_history: list[oci.generative_ai_inference.models.CohereMessage]

        :param citations:
            The value to assign to the citations property of this CohereChatResponse.
        :type citations: list[oci.generative_ai_inference.models.Citation]

        :param is_search_required:
            The value to assign to the is_search_required property of this CohereChatResponse.
        :type is_search_required: bool

        :param finish_reason:
            The value to assign to the finish_reason property of this CohereChatResponse.
            Allowed values for this property are: "COMPLETE", "ERROR_TOXIC", "ERROR_LIMIT", "ERROR", "USER_CANCEL", "MAX_TOKENS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type finish_reason: str

        :param error_message:
            The value to assign to the error_message property of this CohereChatResponse.
        :type error_message: str

        :param search_queries:
            The value to assign to the search_queries property of this CohereChatResponse.
        :type search_queries: list[oci.generative_ai_inference.models.SearchQuery]

        :param documents:
            The value to assign to the documents property of this CohereChatResponse.
        :type documents: list[object]

        :param tool_calls:
            The value to assign to the tool_calls property of this CohereChatResponse.
        :type tool_calls: list[oci.generative_ai_inference.models.CohereToolCall]

        :param prompt:
            The value to assign to the prompt property of this CohereChatResponse.
        :type prompt: str

        :param usage:
            The value to assign to the usage property of this CohereChatResponse.
        :type usage: oci.generative_ai_inference.models.Usage

        """
        self.swagger_types = {
            'api_format': 'str',
            'text': 'str',
            'chat_history': 'list[CohereMessage]',
            'citations': 'list[Citation]',
            'is_search_required': 'bool',
            'finish_reason': 'str',
            'error_message': 'str',
            'search_queries': 'list[SearchQuery]',
            'documents': 'list[object]',
            'tool_calls': 'list[CohereToolCall]',
            'prompt': 'str',
            'usage': 'Usage'
        }
        self.attribute_map = {
            'api_format': 'apiFormat',
            'text': 'text',
            'chat_history': 'chatHistory',
            'citations': 'citations',
            'is_search_required': 'isSearchRequired',
            'finish_reason': 'finishReason',
            'error_message': 'errorMessage',
            'search_queries': 'searchQueries',
            'documents': 'documents',
            'tool_calls': 'toolCalls',
            'prompt': 'prompt',
            'usage': 'usage'
        }
        self._api_format = None
        self._text = None
        self._chat_history = None
        self._citations = None
        self._is_search_required = None
        self._finish_reason = None
        self._error_message = None
        self._search_queries = None
        self._documents = None
        self._tool_calls = None
        self._prompt = None
        self._usage = None
        self._api_format = 'COHERE'

    @property
    def text(self):
        """
        **[Required]** Gets the text of this CohereChatResponse.
        Contents of the response that the model generates.


        :return: The text of this CohereChatResponse.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this CohereChatResponse.
        Contents of the response that the model generates.


        :param text: The text of this CohereChatResponse.
        :type: str
        """
        self._text = text

    @property
    def chat_history(self):
        """
        Gets the chat_history of this CohereChatResponse.
        The list of previous messages between the user and the model. The chat history gives the model context for responding to the user's inputs.


        :return: The chat_history of this CohereChatResponse.
        :rtype: list[oci.generative_ai_inference.models.CohereMessage]
        """
        return self._chat_history

    @chat_history.setter
    def chat_history(self, chat_history):
        """
        Sets the chat_history of this CohereChatResponse.
        The list of previous messages between the user and the model. The chat history gives the model context for responding to the user's inputs.


        :param chat_history: The chat_history of this CohereChatResponse.
        :type: list[oci.generative_ai_inference.models.CohereMessage]
        """
        self._chat_history = chat_history

    @property
    def citations(self):
        """
        Gets the citations of this CohereChatResponse.
        Inline citations for the generated response.


        :return: The citations of this CohereChatResponse.
        :rtype: list[oci.generative_ai_inference.models.Citation]
        """
        return self._citations

    @citations.setter
    def citations(self, citations):
        """
        Sets the citations of this CohereChatResponse.
        Inline citations for the generated response.


        :param citations: The citations of this CohereChatResponse.
        :type: list[oci.generative_ai_inference.models.Citation]
        """
        self._citations = citations

    @property
    def is_search_required(self):
        """
        Gets the is_search_required of this CohereChatResponse.
        If set to true, a search for documents is required.


        :return: The is_search_required of this CohereChatResponse.
        :rtype: bool
        """
        return self._is_search_required

    @is_search_required.setter
    def is_search_required(self, is_search_required):
        """
        Sets the is_search_required of this CohereChatResponse.
        If set to true, a search for documents is required.


        :param is_search_required: The is_search_required of this CohereChatResponse.
        :type: bool
        """
        self._is_search_required = is_search_required

    @property
    def finish_reason(self):
        """
        **[Required]** Gets the finish_reason of this CohereChatResponse.
        Why the generation stopped.

        Allowed values for this property are: "COMPLETE", "ERROR_TOXIC", "ERROR_LIMIT", "ERROR", "USER_CANCEL", "MAX_TOKENS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The finish_reason of this CohereChatResponse.
        :rtype: str
        """
        return self._finish_reason

    @finish_reason.setter
    def finish_reason(self, finish_reason):
        """
        Sets the finish_reason of this CohereChatResponse.
        Why the generation stopped.


        :param finish_reason: The finish_reason of this CohereChatResponse.
        :type: str
        """
        allowed_values = ["COMPLETE", "ERROR_TOXIC", "ERROR_LIMIT", "ERROR", "USER_CANCEL", "MAX_TOKENS"]
        if not value_allowed_none_or_none_sentinel(finish_reason, allowed_values):
            finish_reason = 'UNKNOWN_ENUM_VALUE'
        self._finish_reason = finish_reason

    @property
    def error_message(self):
        """
        Gets the error_message of this CohereChatResponse.
        If there is an error during the streaming scenario, then the `errorMessage` parameter contains details for the error.


        :return: The error_message of this CohereChatResponse.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this CohereChatResponse.
        If there is an error during the streaming scenario, then the `errorMessage` parameter contains details for the error.


        :param error_message: The error_message of this CohereChatResponse.
        :type: str
        """
        self._error_message = error_message

    @property
    def search_queries(self):
        """
        Gets the search_queries of this CohereChatResponse.
        The generated search queries.


        :return: The search_queries of this CohereChatResponse.
        :rtype: list[oci.generative_ai_inference.models.SearchQuery]
        """
        return self._search_queries

    @search_queries.setter
    def search_queries(self, search_queries):
        """
        Sets the search_queries of this CohereChatResponse.
        The generated search queries.


        :param search_queries: The search_queries of this CohereChatResponse.
        :type: list[oci.generative_ai_inference.models.SearchQuery]
        """
        self._search_queries = search_queries

    @property
    def documents(self):
        """
        Gets the documents of this CohereChatResponse.
        The documents that the model can refer to when generating a response. Each document is a JSON string that represents the field and values of the document.

        Example:
        '[
          {
            \"id\": \"doc_0\",
            \"snippet\": \"Emperor penguins are the tallest.\",
            \"title\": \"Tall penguins\"
          },
          {
            \"id\": \"doc_1\",
            \"snippet\": \"Emperor penguins only live in Antarctica.\",
            \"title\": \"Penguin habitats\"
          }
        ]'


        :return: The documents of this CohereChatResponse.
        :rtype: list[object]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this CohereChatResponse.
        The documents that the model can refer to when generating a response. Each document is a JSON string that represents the field and values of the document.

        Example:
        '[
          {
            \"id\": \"doc_0\",
            \"snippet\": \"Emperor penguins are the tallest.\",
            \"title\": \"Tall penguins\"
          },
          {
            \"id\": \"doc_1\",
            \"snippet\": \"Emperor penguins only live in Antarctica.\",
            \"title\": \"Penguin habitats\"
          }
        ]'


        :param documents: The documents of this CohereChatResponse.
        :type: list[object]
        """
        self._documents = documents

    @property
    def tool_calls(self):
        """
        Gets the tool_calls of this CohereChatResponse.
        A list of tool calls generated by the model.


        :return: The tool_calls of this CohereChatResponse.
        :rtype: list[oci.generative_ai_inference.models.CohereToolCall]
        """
        return self._tool_calls

    @tool_calls.setter
    def tool_calls(self, tool_calls):
        """
        Sets the tool_calls of this CohereChatResponse.
        A list of tool calls generated by the model.


        :param tool_calls: The tool_calls of this CohereChatResponse.
        :type: list[oci.generative_ai_inference.models.CohereToolCall]
        """
        self._tool_calls = tool_calls

    @property
    def prompt(self):
        """
        Gets the prompt of this CohereChatResponse.
        The full prompt that was sent to the model if isEcho is true when request.


        :return: The prompt of this CohereChatResponse.
        :rtype: str
        """
        return self._prompt

    @prompt.setter
    def prompt(self, prompt):
        """
        Sets the prompt of this CohereChatResponse.
        The full prompt that was sent to the model if isEcho is true when request.


        :param prompt: The prompt of this CohereChatResponse.
        :type: str
        """
        self._prompt = prompt

    @property
    def usage(self):
        """
        Gets the usage of this CohereChatResponse.

        :return: The usage of this CohereChatResponse.
        :rtype: oci.generative_ai_inference.models.Usage
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """
        Sets the usage of this CohereChatResponse.

        :param usage: The usage of this CohereChatResponse.
        :type: oci.generative_ai_inference.models.Usage
        """
        self._usage = usage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
