# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .cohere_content_v2 import CohereContentV2
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereImageContentV2(CohereContentV2):
    """
    Represents a single instance of Chat Image content
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CohereImageContentV2 object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereImageContentV2.type` attribute
        of this class is ``IMAGE_URL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CohereImageContentV2.
            Allowed values for this property are: "TEXT", "IMAGE_URL", "DOCUMENT", "THINKING"
        :type type: str

        :param image_url:
            The value to assign to the image_url property of this CohereImageContentV2.
        :type image_url: oci.generative_ai_inference.models.CohereImageUrlV2

        """
        self.swagger_types = {
            'type': 'str',
            'image_url': 'CohereImageUrlV2'
        }
        self.attribute_map = {
            'type': 'type',
            'image_url': 'imageUrl'
        }
        self._type = None
        self._image_url = None
        self._type = 'IMAGE_URL'

    @property
    def image_url(self):
        """
        Gets the image_url of this CohereImageContentV2.

        :return: The image_url of this CohereImageContentV2.
        :rtype: oci.generative_ai_inference.models.CohereImageUrlV2
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """
        Sets the image_url of this CohereImageContentV2.

        :param image_url: The image_url of this CohereImageContentV2.
        :type: oci.generative_ai_inference.models.CohereImageUrlV2
        """
        self._image_url = image_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
