# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereThinkingV2(object):
    """
    Configuration for reasoning features.
    """

    #: A constant which can be used with the type property of a CohereThinkingV2.
    #: This constant has a value of "ENABLED"
    TYPE_ENABLED = "ENABLED"

    #: A constant which can be used with the type property of a CohereThinkingV2.
    #: This constant has a value of "DISABLED"
    TYPE_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereThinkingV2 object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CohereThinkingV2.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type type: str

        :param token_budget:
            The value to assign to the token_budget property of this CohereThinkingV2.
        :type token_budget: int

        """
        self.swagger_types = {
            'type': 'str',
            'token_budget': 'int'
        }
        self.attribute_map = {
            'type': 'type',
            'token_budget': 'tokenBudget'
        }
        self._type = None
        self._token_budget = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CohereThinkingV2.
        Reasoning is enabled by default for models that support it, but can be turned off by setting type = disbaled.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The type of this CohereThinkingV2.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CohereThinkingV2.
        Reasoning is enabled by default for models that support it, but can be turned off by setting type = disbaled.


        :param type: The type of this CohereThinkingV2.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def token_budget(self):
        """
        Gets the token_budget of this CohereThinkingV2.
        The maximum number of tokens the model can use for thinking, which must be set to a positive integer. The model will stop thinking if it reaches the thinking token budget and will proceed with the response.


        :return: The token_budget of this CohereThinkingV2.
        :rtype: int
        """
        return self._token_budget

    @token_budget.setter
    def token_budget(self, token_budget):
        """
        Sets the token_budget of this CohereThinkingV2.
        The maximum number of tokens the model can use for thinking, which must be set to a positive integer. The model will stop thinking if it reaches the thinking token budget and will proceed with the response.


        :param token_budget: The token_budget of this CohereThinkingV2.
        :type: int
        """
        self._token_budget = token_budget

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
