# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Usage(object):
    """
    Usage statistics for the completion request.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Usage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param completion_tokens:
            The value to assign to the completion_tokens property of this Usage.
        :type completion_tokens: int

        :param prompt_tokens:
            The value to assign to the prompt_tokens property of this Usage.
        :type prompt_tokens: int

        :param total_tokens:
            The value to assign to the total_tokens property of this Usage.
        :type total_tokens: int

        :param completion_tokens_details:
            The value to assign to the completion_tokens_details property of this Usage.
        :type completion_tokens_details: oci.generative_ai_inference.models.CompletionTokensDetails

        :param prompt_tokens_details:
            The value to assign to the prompt_tokens_details property of this Usage.
        :type prompt_tokens_details: oci.generative_ai_inference.models.PromptTokensDetails

        """
        self.swagger_types = {
            'completion_tokens': 'int',
            'prompt_tokens': 'int',
            'total_tokens': 'int',
            'completion_tokens_details': 'CompletionTokensDetails',
            'prompt_tokens_details': 'PromptTokensDetails'
        }
        self.attribute_map = {
            'completion_tokens': 'completionTokens',
            'prompt_tokens': 'promptTokens',
            'total_tokens': 'totalTokens',
            'completion_tokens_details': 'completionTokensDetails',
            'prompt_tokens_details': 'promptTokensDetails'
        }
        self._completion_tokens = None
        self._prompt_tokens = None
        self._total_tokens = None
        self._completion_tokens_details = None
        self._prompt_tokens_details = None

    @property
    def completion_tokens(self):
        """
        Gets the completion_tokens of this Usage.
        Number of tokens in the generated completion.


        :return: The completion_tokens of this Usage.
        :rtype: int
        """
        return self._completion_tokens

    @completion_tokens.setter
    def completion_tokens(self, completion_tokens):
        """
        Sets the completion_tokens of this Usage.
        Number of tokens in the generated completion.


        :param completion_tokens: The completion_tokens of this Usage.
        :type: int
        """
        self._completion_tokens = completion_tokens

    @property
    def prompt_tokens(self):
        """
        Gets the prompt_tokens of this Usage.
        Number of tokens in the prompt.


        :return: The prompt_tokens of this Usage.
        :rtype: int
        """
        return self._prompt_tokens

    @prompt_tokens.setter
    def prompt_tokens(self, prompt_tokens):
        """
        Sets the prompt_tokens of this Usage.
        Number of tokens in the prompt.


        :param prompt_tokens: The prompt_tokens of this Usage.
        :type: int
        """
        self._prompt_tokens = prompt_tokens

    @property
    def total_tokens(self):
        """
        Gets the total_tokens of this Usage.
        Total number of tokens used in the request (prompt + completion).


        :return: The total_tokens of this Usage.
        :rtype: int
        """
        return self._total_tokens

    @total_tokens.setter
    def total_tokens(self, total_tokens):
        """
        Sets the total_tokens of this Usage.
        Total number of tokens used in the request (prompt + completion).


        :param total_tokens: The total_tokens of this Usage.
        :type: int
        """
        self._total_tokens = total_tokens

    @property
    def completion_tokens_details(self):
        """
        Gets the completion_tokens_details of this Usage.

        :return: The completion_tokens_details of this Usage.
        :rtype: oci.generative_ai_inference.models.CompletionTokensDetails
        """
        return self._completion_tokens_details

    @completion_tokens_details.setter
    def completion_tokens_details(self, completion_tokens_details):
        """
        Sets the completion_tokens_details of this Usage.

        :param completion_tokens_details: The completion_tokens_details of this Usage.
        :type: oci.generative_ai_inference.models.CompletionTokensDetails
        """
        self._completion_tokens_details = completion_tokens_details

    @property
    def prompt_tokens_details(self):
        """
        Gets the prompt_tokens_details of this Usage.

        :return: The prompt_tokens_details of this Usage.
        :rtype: oci.generative_ai_inference.models.PromptTokensDetails
        """
        return self._prompt_tokens_details

    @prompt_tokens_details.setter
    def prompt_tokens_details(self, prompt_tokens_details):
        """
        Sets the prompt_tokens_details of this Usage.

        :param prompt_tokens_details: The prompt_tokens_details of this Usage.
        :type: oci.generative_ai_inference.models.PromptTokensDetails
        """
        self._prompt_tokens_details = prompt_tokens_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
