# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineRunningProcessSummary(object):
    """
    Each replication process and their summary details.
    """

    #: A constant which can be used with the process_type property of a PipelineRunningProcessSummary.
    #: This constant has a value of "EXTRACT"
    PROCESS_TYPE_EXTRACT = "EXTRACT"

    #: A constant which can be used with the process_type property of a PipelineRunningProcessSummary.
    #: This constant has a value of "REPLICAT"
    PROCESS_TYPE_REPLICAT = "REPLICAT"

    #: A constant which can be used with the status property of a PipelineRunningProcessSummary.
    #: This constant has a value of "STOPPED"
    STATUS_STOPPED = "STOPPED"

    #: A constant which can be used with the status property of a PipelineRunningProcessSummary.
    #: This constant has a value of "RUNNING"
    STATUS_RUNNING = "RUNNING"

    #: A constant which can be used with the status property of a PipelineRunningProcessSummary.
    #: This constant has a value of "ERROR"
    STATUS_ERROR = "ERROR"

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineRunningProcessSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this PipelineRunningProcessSummary.
        :type name: str

        :param process_type:
            The value to assign to the process_type property of this PipelineRunningProcessSummary.
            Allowed values for this property are: "EXTRACT", "REPLICAT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type process_type: str

        :param status:
            The value to assign to the status property of this PipelineRunningProcessSummary.
            Allowed values for this property are: "STOPPED", "RUNNING", "ERROR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param last_record_lag_in_seconds:
            The value to assign to the last_record_lag_in_seconds property of this PipelineRunningProcessSummary.
        :type last_record_lag_in_seconds: float

        :param time_last_processed:
            The value to assign to the time_last_processed property of this PipelineRunningProcessSummary.
        :type time_last_processed: datetime

        """
        self.swagger_types = {
            'name': 'str',
            'process_type': 'str',
            'status': 'str',
            'last_record_lag_in_seconds': 'float',
            'time_last_processed': 'datetime'
        }
        self.attribute_map = {
            'name': 'name',
            'process_type': 'processType',
            'status': 'status',
            'last_record_lag_in_seconds': 'lastRecordLagInSeconds',
            'time_last_processed': 'timeLastProcessed'
        }
        self._name = None
        self._process_type = None
        self._status = None
        self._last_record_lag_in_seconds = None
        self._time_last_processed = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this PipelineRunningProcessSummary.
        An object's Display Name.


        :return: The name of this PipelineRunningProcessSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PipelineRunningProcessSummary.
        An object's Display Name.


        :param name: The name of this PipelineRunningProcessSummary.
        :type: str
        """
        self._name = name

    @property
    def process_type(self):
        """
        **[Required]** Gets the process_type of this PipelineRunningProcessSummary.
        The type of process running in a replication. For example, Extract or Replicat. This option applies when retrieving running processes.

        Allowed values for this property are: "EXTRACT", "REPLICAT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The process_type of this PipelineRunningProcessSummary.
        :rtype: str
        """
        return self._process_type

    @process_type.setter
    def process_type(self, process_type):
        """
        Sets the process_type of this PipelineRunningProcessSummary.
        The type of process running in a replication. For example, Extract or Replicat. This option applies when retrieving running processes.


        :param process_type: The process_type of this PipelineRunningProcessSummary.
        :type: str
        """
        allowed_values = ["EXTRACT", "REPLICAT"]
        if not value_allowed_none_or_none_sentinel(process_type, allowed_values):
            process_type = 'UNKNOWN_ENUM_VALUE'
        self._process_type = process_type

    @property
    def status(self):
        """
        **[Required]** Gets the status of this PipelineRunningProcessSummary.
        The status of the Extract or Replicat process. This option applies when retrieving running processes.

        Allowed values for this property are: "STOPPED", "RUNNING", "ERROR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this PipelineRunningProcessSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this PipelineRunningProcessSummary.
        The status of the Extract or Replicat process. This option applies when retrieving running processes.


        :param status: The status of this PipelineRunningProcessSummary.
        :type: str
        """
        allowed_values = ["STOPPED", "RUNNING", "ERROR"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def last_record_lag_in_seconds(self):
        """
        **[Required]** Gets the last_record_lag_in_seconds of this PipelineRunningProcessSummary.
        The latency, in seconds, of a process running in a replication. This option applies when retrieving running processes.


        :return: The last_record_lag_in_seconds of this PipelineRunningProcessSummary.
        :rtype: float
        """
        return self._last_record_lag_in_seconds

    @last_record_lag_in_seconds.setter
    def last_record_lag_in_seconds(self, last_record_lag_in_seconds):
        """
        Sets the last_record_lag_in_seconds of this PipelineRunningProcessSummary.
        The latency, in seconds, of a process running in a replication. This option applies when retrieving running processes.


        :param last_record_lag_in_seconds: The last_record_lag_in_seconds of this PipelineRunningProcessSummary.
        :type: float
        """
        self._last_record_lag_in_seconds = last_record_lag_in_seconds

    @property
    def time_last_processed(self):
        """
        **[Required]** Gets the time_last_processed of this PipelineRunningProcessSummary.
        The date and time the last record was processed by an Extract or Replicat. This option applies when retrieving running processes.
        The format is defined by `RFC3339`__, such as `2024-07-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_last_processed of this PipelineRunningProcessSummary.
        :rtype: datetime
        """
        return self._time_last_processed

    @time_last_processed.setter
    def time_last_processed(self, time_last_processed):
        """
        Sets the time_last_processed of this PipelineRunningProcessSummary.
        The date and time the last record was processed by an Extract or Replicat. This option applies when retrieving running processes.
        The format is defined by `RFC3339`__, such as `2024-07-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_last_processed: The time_last_processed of this PipelineRunningProcessSummary.
        :type: datetime
        """
        self._time_last_processed = time_last_processed

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
