# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AccountMgmtInfo(object):
    """
    Schema for AccountMgmtInfo resource.
    """

    #: A constant which can be used with the idcs_prevented_operations property of a AccountMgmtInfo.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a AccountMgmtInfo.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a AccountMgmtInfo.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    #: A constant which can be used with the sync_situation property of a AccountMgmtInfo.
    #: This constant has a value of "Found"
    SYNC_SITUATION_FOUND = "Found"

    #: A constant which can be used with the sync_situation property of a AccountMgmtInfo.
    #: This constant has a value of "Matched"
    SYNC_SITUATION_MATCHED = "Matched"

    #: A constant which can be used with the sync_situation property of a AccountMgmtInfo.
    #: This constant has a value of "Unmatched"
    SYNC_SITUATION_UNMATCHED = "Unmatched"

    #: A constant which can be used with the sync_situation property of a AccountMgmtInfo.
    #: This constant has a value of "Lost"
    SYNC_SITUATION_LOST = "Lost"

    #: A constant which can be used with the sync_situation property of a AccountMgmtInfo.
    #: This constant has a value of "Disputed"
    SYNC_SITUATION_DISPUTED = "Disputed"

    #: A constant which can be used with the sync_situation property of a AccountMgmtInfo.
    #: This constant has a value of "Confirmed"
    SYNC_SITUATION_CONFIRMED = "Confirmed"

    #: A constant which can be used with the operation_context property of a AccountMgmtInfo.
    #: This constant has a value of "LifeCycleEvent"
    OPERATION_CONTEXT_LIFE_CYCLE_EVENT = "LifeCycleEvent"

    def __init__(self, **kwargs):
        """
        Initializes a new AccountMgmtInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AccountMgmtInfo.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this AccountMgmtInfo.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this AccountMgmtInfo.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this AccountMgmtInfo.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this AccountMgmtInfo.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this AccountMgmtInfo.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this AccountMgmtInfo.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this AccountMgmtInfo.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this AccountMgmtInfo.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this AccountMgmtInfo.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this AccountMgmtInfo.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this AccountMgmtInfo.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this AccountMgmtInfo.
        :type tenancy_ocid: str

        :param uid:
            The value to assign to the uid property of this AccountMgmtInfo.
        :type uid: str

        :param name:
            The value to assign to the name property of this AccountMgmtInfo.
        :type name: str

        :param composite_key:
            The value to assign to the composite_key property of this AccountMgmtInfo.
        :type composite_key: str

        :param active:
            The value to assign to the active property of this AccountMgmtInfo.
        :type active: bool

        :param account_type:
            The value to assign to the account_type property of this AccountMgmtInfo.
        :type account_type: str

        :param is_account:
            The value to assign to the is_account property of this AccountMgmtInfo.
        :type is_account: bool

        :param favorite:
            The value to assign to the favorite property of this AccountMgmtInfo.
        :type favorite: bool

        :param do_not_perform_action_on_target:
            The value to assign to the do_not_perform_action_on_target property of this AccountMgmtInfo.
        :type do_not_perform_action_on_target: bool

        :param do_not_back_fill_grants:
            The value to assign to the do_not_back_fill_grants property of this AccountMgmtInfo.
        :type do_not_back_fill_grants: bool

        :param last_accessed:
            The value to assign to the last_accessed property of this AccountMgmtInfo.
        :type last_accessed: str

        :param sync_timestamp:
            The value to assign to the sync_timestamp property of this AccountMgmtInfo.
        :type sync_timestamp: str

        :param sync_situation:
            The value to assign to the sync_situation property of this AccountMgmtInfo.
            Allowed values for this property are: "Found", "Matched", "Unmatched", "Lost", "Disputed", "Confirmed", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type sync_situation: str

        :param sync_response:
            The value to assign to the sync_response property of this AccountMgmtInfo.
        :type sync_response: str

        :param preview_only:
            The value to assign to the preview_only property of this AccountMgmtInfo.
        :type preview_only: bool

        :param operation_context:
            The value to assign to the operation_context property of this AccountMgmtInfo.
            Allowed values for this property are: "LifeCycleEvent", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_context: str

        :param object_class:
            The value to assign to the object_class property of this AccountMgmtInfo.
        :type object_class: oci.identity_domains.models.AccountMgmtInfoObjectClass

        :param resource_type:
            The value to assign to the resource_type property of this AccountMgmtInfo.
        :type resource_type: oci.identity_domains.models.AccountMgmtInfoResourceType

        :param matching_owners:
            The value to assign to the matching_owners property of this AccountMgmtInfo.
        :type matching_owners: list[oci.identity_domains.models.AccountMgmtInfoMatchingOwners]

        :param user_wallet_artifact:
            The value to assign to the user_wallet_artifact property of this AccountMgmtInfo.
        :type user_wallet_artifact: oci.identity_domains.models.AccountMgmtInfoUserWalletArtifact

        :param app:
            The value to assign to the app property of this AccountMgmtInfo.
        :type app: oci.identity_domains.models.AccountMgmtInfoApp

        :param owner:
            The value to assign to the owner property of this AccountMgmtInfo.
        :type owner: oci.identity_domains.models.AccountMgmtInfoOwner

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'uid': 'str',
            'name': 'str',
            'composite_key': 'str',
            'active': 'bool',
            'account_type': 'str',
            'is_account': 'bool',
            'favorite': 'bool',
            'do_not_perform_action_on_target': 'bool',
            'do_not_back_fill_grants': 'bool',
            'last_accessed': 'str',
            'sync_timestamp': 'str',
            'sync_situation': 'str',
            'sync_response': 'str',
            'preview_only': 'bool',
            'operation_context': 'str',
            'object_class': 'AccountMgmtInfoObjectClass',
            'resource_type': 'AccountMgmtInfoResourceType',
            'matching_owners': 'list[AccountMgmtInfoMatchingOwners]',
            'user_wallet_artifact': 'AccountMgmtInfoUserWalletArtifact',
            'app': 'AccountMgmtInfoApp',
            'owner': 'AccountMgmtInfoOwner'
        }
        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'uid': 'uid',
            'name': 'name',
            'composite_key': 'compositeKey',
            'active': 'active',
            'account_type': 'accountType',
            'is_account': 'isAccount',
            'favorite': 'favorite',
            'do_not_perform_action_on_target': 'doNotPerformActionOnTarget',
            'do_not_back_fill_grants': 'doNotBackFillGrants',
            'last_accessed': 'lastAccessed',
            'sync_timestamp': 'syncTimestamp',
            'sync_situation': 'syncSituation',
            'sync_response': 'syncResponse',
            'preview_only': 'previewOnly',
            'operation_context': 'operationContext',
            'object_class': 'objectClass',
            'resource_type': 'resourceType',
            'matching_owners': 'matchingOwners',
            'user_wallet_artifact': 'userWalletArtifact',
            'app': 'app',
            'owner': 'owner'
        }
        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._uid = None
        self._name = None
        self._composite_key = None
        self._active = None
        self._account_type = None
        self._is_account = None
        self._favorite = None
        self._do_not_perform_action_on_target = None
        self._do_not_back_fill_grants = None
        self._last_accessed = None
        self._sync_timestamp = None
        self._sync_situation = None
        self._sync_response = None
        self._preview_only = None
        self._operation_context = None
        self._object_class = None
        self._resource_type = None
        self._matching_owners = None
        self._user_wallet_artifact = None
        self._app = None
        self._owner = None

    @property
    def id(self):
        """
        Gets the id of this AccountMgmtInfo.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this AccountMgmtInfo.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AccountMgmtInfo.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this AccountMgmtInfo.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this AccountMgmtInfo.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this AccountMgmtInfo.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this AccountMgmtInfo.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this AccountMgmtInfo.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this AccountMgmtInfo.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this AccountMgmtInfo.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this AccountMgmtInfo.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this AccountMgmtInfo.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this AccountMgmtInfo.

        :return: The meta of this AccountMgmtInfo.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this AccountMgmtInfo.

        :param meta: The meta of this AccountMgmtInfo.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this AccountMgmtInfo.

        :return: The idcs_created_by of this AccountMgmtInfo.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this AccountMgmtInfo.

        :param idcs_created_by: The idcs_created_by of this AccountMgmtInfo.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this AccountMgmtInfo.

        :return: The idcs_last_modified_by of this AccountMgmtInfo.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this AccountMgmtInfo.

        :param idcs_last_modified_by: The idcs_last_modified_by of this AccountMgmtInfo.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this AccountMgmtInfo.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this AccountMgmtInfo.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this AccountMgmtInfo.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this AccountMgmtInfo.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this AccountMgmtInfo.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this AccountMgmtInfo.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this AccountMgmtInfo.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this AccountMgmtInfo.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this AccountMgmtInfo.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this AccountMgmtInfo.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this AccountMgmtInfo.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this AccountMgmtInfo.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this AccountMgmtInfo.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this AccountMgmtInfo.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this AccountMgmtInfo.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this AccountMgmtInfo.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this AccountMgmtInfo.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this AccountMgmtInfo.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this AccountMgmtInfo.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this AccountMgmtInfo.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this AccountMgmtInfo.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this AccountMgmtInfo.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this AccountMgmtInfo.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this AccountMgmtInfo.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this AccountMgmtInfo.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this AccountMgmtInfo.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this AccountMgmtInfo.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this AccountMgmtInfo.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def uid(self):
        """
        Gets the uid of this AccountMgmtInfo.
        Unique identifier of the Account

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The uid of this AccountMgmtInfo.
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """
        Sets the uid of this AccountMgmtInfo.
        Unique identifier of the Account

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param uid: The uid of this AccountMgmtInfo.
        :type: str
        """
        self._uid = uid

    @property
    def name(self):
        """
        Gets the name of this AccountMgmtInfo.
        Name of the Account

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name of this AccountMgmtInfo.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AccountMgmtInfo.
        Name of the Account

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param name: The name of this AccountMgmtInfo.
        :type: str
        """
        self._name = name

    @property
    def composite_key(self):
        """
        Gets the composite_key of this AccountMgmtInfo.
        Unique key for this AccountMgmtInfo, which is used to prevent duplicate AccountMgmtInfo resources. Key is composed of a subset of app, owner and accountType.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: server


        :return: The composite_key of this AccountMgmtInfo.
        :rtype: str
        """
        return self._composite_key

    @composite_key.setter
    def composite_key(self, composite_key):
        """
        Sets the composite_key of this AccountMgmtInfo.
        Unique key for this AccountMgmtInfo, which is used to prevent duplicate AccountMgmtInfo resources. Key is composed of a subset of app, owner and accountType.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: server


        :param composite_key: The composite_key of this AccountMgmtInfo.
        :type: str
        """
        self._composite_key = composite_key

    @property
    def active(self):
        """
        Gets the active of this AccountMgmtInfo.
        If true, the account is activated

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The active of this AccountMgmtInfo.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this AccountMgmtInfo.
        If true, the account is activated

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param active: The active of this AccountMgmtInfo.
        :type: bool
        """
        self._active = active

    @property
    def account_type(self):
        """
        Gets the account_type of this AccountMgmtInfo.
        Type of Account

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The account_type of this AccountMgmtInfo.
        :rtype: str
        """
        return self._account_type

    @account_type.setter
    def account_type(self, account_type):
        """
        Sets the account_type of this AccountMgmtInfo.
        Type of Account

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param account_type: The account_type of this AccountMgmtInfo.
        :type: str
        """
        self._account_type = account_type

    @property
    def is_account(self):
        """
        Gets the is_account of this AccountMgmtInfo.
        If true, indicates that this managed object is an account, which is an identity that represents a user in the context of a specific application

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_account of this AccountMgmtInfo.
        :rtype: bool
        """
        return self._is_account

    @is_account.setter
    def is_account(self, is_account):
        """
        Sets the is_account of this AccountMgmtInfo.
        If true, indicates that this managed object is an account, which is an identity that represents a user in the context of a specific application

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_account: The is_account of this AccountMgmtInfo.
        :type: bool
        """
        self._is_account = is_account

    @property
    def favorite(self):
        """
        Gets the favorite of this AccountMgmtInfo.
        If true, this account has been marked as a favorite of the User who owns it

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The favorite of this AccountMgmtInfo.
        :rtype: bool
        """
        return self._favorite

    @favorite.setter
    def favorite(self, favorite):
        """
        Sets the favorite of this AccountMgmtInfo.
        If true, this account has been marked as a favorite of the User who owns it

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param favorite: The favorite of this AccountMgmtInfo.
        :type: bool
        """
        self._favorite = favorite

    @property
    def do_not_perform_action_on_target(self):
        """
        Gets the do_not_perform_action_on_target of this AccountMgmtInfo.
        If true, the operation will not be performed on the target

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The do_not_perform_action_on_target of this AccountMgmtInfo.
        :rtype: bool
        """
        return self._do_not_perform_action_on_target

    @do_not_perform_action_on_target.setter
    def do_not_perform_action_on_target(self, do_not_perform_action_on_target):
        """
        Sets the do_not_perform_action_on_target of this AccountMgmtInfo.
        If true, the operation will not be performed on the target

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param do_not_perform_action_on_target: The do_not_perform_action_on_target of this AccountMgmtInfo.
        :type: bool
        """
        self._do_not_perform_action_on_target = do_not_perform_action_on_target

    @property
    def do_not_back_fill_grants(self):
        """
        Gets the do_not_back_fill_grants of this AccountMgmtInfo.
        If true, a back-fill grant will not be created for a connected managed app as part of account creation.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The do_not_back_fill_grants of this AccountMgmtInfo.
        :rtype: bool
        """
        return self._do_not_back_fill_grants

    @do_not_back_fill_grants.setter
    def do_not_back_fill_grants(self, do_not_back_fill_grants):
        """
        Sets the do_not_back_fill_grants of this AccountMgmtInfo.
        If true, a back-fill grant will not be created for a connected managed app as part of account creation.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param do_not_back_fill_grants: The do_not_back_fill_grants of this AccountMgmtInfo.
        :type: bool
        """
        self._do_not_back_fill_grants = do_not_back_fill_grants

    @property
    def last_accessed(self):
        """
        Gets the last_accessed of this AccountMgmtInfo.
        Last accessed timestamp of an application

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: dateTime
         - uniqueness: none


        :return: The last_accessed of this AccountMgmtInfo.
        :rtype: str
        """
        return self._last_accessed

    @last_accessed.setter
    def last_accessed(self, last_accessed):
        """
        Sets the last_accessed of this AccountMgmtInfo.
        Last accessed timestamp of an application

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: dateTime
         - uniqueness: none


        :param last_accessed: The last_accessed of this AccountMgmtInfo.
        :type: str
        """
        self._last_accessed = last_accessed

    @property
    def sync_timestamp(self):
        """
        Gets the sync_timestamp of this AccountMgmtInfo.
        Last sync timestamp of the account

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: dateTime
         - uniqueness: none


        :return: The sync_timestamp of this AccountMgmtInfo.
        :rtype: str
        """
        return self._sync_timestamp

    @sync_timestamp.setter
    def sync_timestamp(self, sync_timestamp):
        """
        Sets the sync_timestamp of this AccountMgmtInfo.
        Last sync timestamp of the account

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: dateTime
         - uniqueness: none


        :param sync_timestamp: The sync_timestamp of this AccountMgmtInfo.
        :type: str
        """
        self._sync_timestamp = sync_timestamp

    @property
    def sync_situation(self):
        """
        Gets the sync_situation of this AccountMgmtInfo.
        Last recorded sync situation for the account

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "Found", "Matched", "Unmatched", "Lost", "Disputed", "Confirmed", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The sync_situation of this AccountMgmtInfo.
        :rtype: str
        """
        return self._sync_situation

    @sync_situation.setter
    def sync_situation(self, sync_situation):
        """
        Sets the sync_situation of this AccountMgmtInfo.
        Last recorded sync situation for the account

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param sync_situation: The sync_situation of this AccountMgmtInfo.
        :type: str
        """
        allowed_values = ["Found", "Matched", "Unmatched", "Lost", "Disputed", "Confirmed"]
        if not value_allowed_none_or_none_sentinel(sync_situation, allowed_values):
            sync_situation = 'UNKNOWN_ENUM_VALUE'
        self._sync_situation = sync_situation

    @property
    def sync_response(self):
        """
        Gets the sync_response of this AccountMgmtInfo.
        Last recorded sync response for the account

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The sync_response of this AccountMgmtInfo.
        :rtype: str
        """
        return self._sync_response

    @sync_response.setter
    def sync_response(self, sync_response):
        """
        Sets the sync_response of this AccountMgmtInfo.
        Last recorded sync response for the account

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param sync_response: The sync_response of this AccountMgmtInfo.
        :type: str
        """
        self._sync_response = sync_response

    @property
    def preview_only(self):
        """
        Gets the preview_only of this AccountMgmtInfo.
        If true, then the response to the account creation operation on a connected managed app returns a preview of the account data that is evaluated by the attribute value generation policy. Note that an account will not be created on the target application when this attribute is set to true.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The preview_only of this AccountMgmtInfo.
        :rtype: bool
        """
        return self._preview_only

    @preview_only.setter
    def preview_only(self, preview_only):
        """
        Sets the preview_only of this AccountMgmtInfo.
        If true, then the response to the account creation operation on a connected managed app returns a preview of the account data that is evaluated by the attribute value generation policy. Note that an account will not be created on the target application when this attribute is set to true.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param preview_only: The preview_only of this AccountMgmtInfo.
        :type: bool
        """
        self._preview_only = preview_only

    @property
    def operation_context(self):
        """
        Gets the operation_context of this AccountMgmtInfo.
        The context in which the operation is performed on the account.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - idcsSearchable: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "LifeCycleEvent", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_context of this AccountMgmtInfo.
        :rtype: str
        """
        return self._operation_context

    @operation_context.setter
    def operation_context(self, operation_context):
        """
        Sets the operation_context of this AccountMgmtInfo.
        The context in which the operation is performed on the account.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - idcsSearchable: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param operation_context: The operation_context of this AccountMgmtInfo.
        :type: str
        """
        allowed_values = ["LifeCycleEvent"]
        if not value_allowed_none_or_none_sentinel(operation_context, allowed_values):
            operation_context = 'UNKNOWN_ENUM_VALUE'
        self._operation_context = operation_context

    @property
    def object_class(self):
        """
        Gets the object_class of this AccountMgmtInfo.

        :return: The object_class of this AccountMgmtInfo.
        :rtype: oci.identity_domains.models.AccountMgmtInfoObjectClass
        """
        return self._object_class

    @object_class.setter
    def object_class(self, object_class):
        """
        Sets the object_class of this AccountMgmtInfo.

        :param object_class: The object_class of this AccountMgmtInfo.
        :type: oci.identity_domains.models.AccountMgmtInfoObjectClass
        """
        self._object_class = object_class

    @property
    def resource_type(self):
        """
        Gets the resource_type of this AccountMgmtInfo.

        :return: The resource_type of this AccountMgmtInfo.
        :rtype: oci.identity_domains.models.AccountMgmtInfoResourceType
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this AccountMgmtInfo.

        :param resource_type: The resource_type of this AccountMgmtInfo.
        :type: oci.identity_domains.models.AccountMgmtInfoResourceType
        """
        self._resource_type = resource_type

    @property
    def matching_owners(self):
        """
        Gets the matching_owners of this AccountMgmtInfo.
        Matching owning users of the account

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The matching_owners of this AccountMgmtInfo.
        :rtype: list[oci.identity_domains.models.AccountMgmtInfoMatchingOwners]
        """
        return self._matching_owners

    @matching_owners.setter
    def matching_owners(self, matching_owners):
        """
        Sets the matching_owners of this AccountMgmtInfo.
        Matching owning users of the account

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param matching_owners: The matching_owners of this AccountMgmtInfo.
        :type: list[oci.identity_domains.models.AccountMgmtInfoMatchingOwners]
        """
        self._matching_owners = matching_owners

    @property
    def user_wallet_artifact(self):
        """
        Gets the user_wallet_artifact of this AccountMgmtInfo.

        :return: The user_wallet_artifact of this AccountMgmtInfo.
        :rtype: oci.identity_domains.models.AccountMgmtInfoUserWalletArtifact
        """
        return self._user_wallet_artifact

    @user_wallet_artifact.setter
    def user_wallet_artifact(self, user_wallet_artifact):
        """
        Sets the user_wallet_artifact of this AccountMgmtInfo.

        :param user_wallet_artifact: The user_wallet_artifact of this AccountMgmtInfo.
        :type: oci.identity_domains.models.AccountMgmtInfoUserWalletArtifact
        """
        self._user_wallet_artifact = user_wallet_artifact

    @property
    def app(self):
        """
        **[Required]** Gets the app of this AccountMgmtInfo.

        :return: The app of this AccountMgmtInfo.
        :rtype: oci.identity_domains.models.AccountMgmtInfoApp
        """
        return self._app

    @app.setter
    def app(self, app):
        """
        Sets the app of this AccountMgmtInfo.

        :param app: The app of this AccountMgmtInfo.
        :type: oci.identity_domains.models.AccountMgmtInfoApp
        """
        self._app = app

    @property
    def owner(self):
        """
        Gets the owner of this AccountMgmtInfo.

        :return: The owner of this AccountMgmtInfo.
        :rtype: oci.identity_domains.models.AccountMgmtInfoOwner
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this AccountMgmtInfo.

        :param owner: The owner of this AccountMgmtInfo.
        :type: oci.identity_domains.models.AccountMgmtInfoOwner
        """
        self._owner = owner

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
