# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class App(object):
    """
    Schema for App resource.
    """

    #: A constant which can be used with the idcs_prevented_operations property of a App.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a App.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a App.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    #: A constant which can be used with the login_mechanism property of a App.
    #: This constant has a value of "OIDC"
    LOGIN_MECHANISM_OIDC = "OIDC"

    #: A constant which can be used with the login_mechanism property of a App.
    #: This constant has a value of "SAML"
    LOGIN_MECHANISM_SAML = "SAML"

    #: A constant which can be used with the login_mechanism property of a App.
    #: This constant has a value of "FORMFILL"
    LOGIN_MECHANISM_FORMFILL = "FORMFILL"

    #: A constant which can be used with the login_mechanism property of a App.
    #: This constant has a value of "RADIUS"
    LOGIN_MECHANISM_RADIUS = "RADIUS"

    #: A constant which can be used with the client_type property of a App.
    #: This constant has a value of "confidential"
    CLIENT_TYPE_CONFIDENTIAL = "confidential"

    #: A constant which can be used with the client_type property of a App.
    #: This constant has a value of "public"
    CLIENT_TYPE_PUBLIC = "public"

    #: A constant which can be used with the client_type property of a App.
    #: This constant has a value of "trusted"
    CLIENT_TYPE_TRUSTED = "trusted"

    #: A constant which can be used with the allowed_operations property of a App.
    #: This constant has a value of "introspect"
    ALLOWED_OPERATIONS_INTROSPECT = "introspect"

    #: A constant which can be used with the allowed_operations property of a App.
    #: This constant has a value of "onBehalfOfUser"
    ALLOWED_OPERATIONS_ON_BEHALF_OF_USER = "onBehalfOfUser"

    #: A constant which can be used with the client_ip_checking property of a App.
    #: This constant has a value of "anywhere"
    CLIENT_IP_CHECKING_ANYWHERE = "anywhere"

    #: A constant which can be used with the client_ip_checking property of a App.
    #: This constant has a value of "whitelisted"
    CLIENT_IP_CHECKING_WHITELISTED = "whitelisted"

    #: A constant which can be used with the trust_scope property of a App.
    #: This constant has a value of "Explicit"
    TRUST_SCOPE_EXPLICIT = "Explicit"

    #: A constant which can be used with the trust_scope property of a App.
    #: This constant has a value of "Account"
    TRUST_SCOPE_ACCOUNT = "Account"

    #: A constant which can be used with the trust_scope property of a App.
    #: This constant has a value of "Tags"
    TRUST_SCOPE_TAGS = "Tags"

    #: A constant which can be used with the trust_scope property of a App.
    #: This constant has a value of "Default"
    TRUST_SCOPE_DEFAULT = "Default"

    def __init__(self, **kwargs):
        """
        Initializes a new App object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this App.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this App.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this App.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this App.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this App.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this App.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this App.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this App.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this App.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this App.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this App.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this App.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this App.
        :type tenancy_ocid: str

        :param meter_as_opc_service:
            The value to assign to the meter_as_opc_service property of this App.
        :type meter_as_opc_service: bool

        :param name:
            The value to assign to the name property of this App.
        :type name: str

        :param client_secret:
            The value to assign to the client_secret property of this App.
        :type client_secret: str

        :param hashed_client_secret:
            The value to assign to the hashed_client_secret property of this App.
        :type hashed_client_secret: str

        :param display_name:
            The value to assign to the display_name property of this App.
        :type display_name: str

        :param description:
            The value to assign to the description property of this App.
        :type description: str

        :param id_token_enc_algo:
            The value to assign to the id_token_enc_algo property of this App.
        :type id_token_enc_algo: str

        :param delegated_service_names:
            The value to assign to the delegated_service_names property of this App.
        :type delegated_service_names: list[str]

        :param active:
            The value to assign to the active property of this App.
        :type active: bool

        :param app_icon:
            The value to assign to the app_icon property of this App.
        :type app_icon: str

        :param app_thumbnail:
            The value to assign to the app_thumbnail property of this App.
        :type app_thumbnail: str

        :param migrated:
            The value to assign to the migrated property of this App.
        :type migrated: bool

        :param infrastructure:
            The value to assign to the infrastructure property of this App.
        :type infrastructure: bool

        :param is_login_target:
            The value to assign to the is_login_target property of this App.
        :type is_login_target: bool

        :param show_in_my_apps:
            The value to assign to the show_in_my_apps property of this App.
        :type show_in_my_apps: bool

        :param login_mechanism:
            The value to assign to the login_mechanism property of this App.
            Allowed values for this property are: "OIDC", "SAML", "FORMFILL", "RADIUS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type login_mechanism: str

        :param landing_page_url:
            The value to assign to the landing_page_url property of this App.
        :type landing_page_url: str

        :param product_logo_url:
            The value to assign to the product_logo_url property of this App.
        :type product_logo_url: str

        :param privacy_policy_url:
            The value to assign to the privacy_policy_url property of this App.
        :type privacy_policy_url: str

        :param terms_of_service_url:
            The value to assign to the terms_of_service_url property of this App.
        :type terms_of_service_url: str

        :param contact_email_address:
            The value to assign to the contact_email_address property of this App.
        :type contact_email_address: str

        :param product_name:
            The value to assign to the product_name property of this App.
        :type product_name: str

        :param home_page_url:
            The value to assign to the home_page_url property of this App.
        :type home_page_url: str

        :param is_form_fill:
            The value to assign to the is_form_fill property of this App.
        :type is_form_fill: bool

        :param is_o_auth_client:
            The value to assign to the is_o_auth_client property of this App.
        :type is_o_auth_client: bool

        :param is_radius_app:
            The value to assign to the is_radius_app property of this App.
        :type is_radius_app: bool

        :param client_type:
            The value to assign to the client_type property of this App.
            Allowed values for this property are: "confidential", "public", "trusted", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type client_type: str

        :param redirect_uris:
            The value to assign to the redirect_uris property of this App.
        :type redirect_uris: list[str]

        :param all_url_schemes_allowed:
            The value to assign to the all_url_schemes_allowed property of this App.
        :type all_url_schemes_allowed: bool

        :param logout_uri:
            The value to assign to the logout_uri property of this App.
        :type logout_uri: str

        :param post_logout_redirect_uris:
            The value to assign to the post_logout_redirect_uris property of this App.
        :type post_logout_redirect_uris: list[str]

        :param allowed_grants:
            The value to assign to the allowed_grants property of this App.
        :type allowed_grants: list[str]

        :param allowed_operations:
            The value to assign to the allowed_operations property of this App.
            Allowed values for items in this list are: "introspect", "onBehalfOfUser", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type allowed_operations: list[str]

        :param client_ip_checking:
            The value to assign to the client_ip_checking property of this App.
            Allowed values for this property are: "anywhere", "whitelisted", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type client_ip_checking: str

        :param is_opc_service:
            The value to assign to the is_opc_service property of this App.
        :type is_opc_service: bool

        :param is_unmanaged_app:
            The value to assign to the is_unmanaged_app property of this App.
        :type is_unmanaged_app: bool

        :param allow_access_control:
            The value to assign to the allow_access_control property of this App.
        :type allow_access_control: bool

        :param is_o_auth_resource:
            The value to assign to the is_o_auth_resource property of this App.
        :type is_o_auth_resource: bool

        :param access_token_expiry:
            The value to assign to the access_token_expiry property of this App.
        :type access_token_expiry: int

        :param refresh_token_expiry:
            The value to assign to the refresh_token_expiry property of this App.
        :type refresh_token_expiry: int

        :param allow_offline:
            The value to assign to the allow_offline property of this App.
        :type allow_offline: bool

        :param callback_service_url:
            The value to assign to the callback_service_url property of this App.
        :type callback_service_url: str

        :param audience:
            The value to assign to the audience property of this App.
        :type audience: str

        :param is_mobile_target:
            The value to assign to the is_mobile_target property of this App.
        :type is_mobile_target: bool

        :param login_page_url:
            The value to assign to the login_page_url property of this App.
        :type login_page_url: str

        :param linking_callback_url:
            The value to assign to the linking_callback_url property of this App.
        :type linking_callback_url: str

        :param logout_page_url:
            The value to assign to the logout_page_url property of this App.
        :type logout_page_url: str

        :param error_page_url:
            The value to assign to the error_page_url property of this App.
        :type error_page_url: str

        :param is_saml_service_provider:
            The value to assign to the is_saml_service_provider property of this App.
        :type is_saml_service_provider: bool

        :param is_web_tier_policy:
            The value to assign to the is_web_tier_policy property of this App.
        :type is_web_tier_policy: bool

        :param is_kerberos_realm:
            The value to assign to the is_kerberos_realm property of this App.
        :type is_kerberos_realm: bool

        :param icon:
            The value to assign to the icon property of this App.
        :type icon: str

        :param is_alias_app:
            The value to assign to the is_alias_app property of this App.
        :type is_alias_app: bool

        :param is_managed_app:
            The value to assign to the is_managed_app property of this App.
        :type is_managed_app: bool

        :param service_type_urn:
            The value to assign to the service_type_urn property of this App.
        :type service_type_urn: str

        :param service_type_version:
            The value to assign to the service_type_version property of this App.
        :type service_type_version: str

        :param is_obligation_capable:
            The value to assign to the is_obligation_capable property of this App.
        :type is_obligation_capable: bool

        :param ready_to_upgrade:
            The value to assign to the ready_to_upgrade property of this App.
        :type ready_to_upgrade: bool

        :param trust_scope:
            The value to assign to the trust_scope property of this App.
            Allowed values for this property are: "Explicit", "Account", "Tags", "Default", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type trust_scope: str

        :param is_database_service:
            The value to assign to the is_database_service property of this App.
        :type is_database_service: bool

        :param secondary_audiences:
            The value to assign to the secondary_audiences property of this App.
        :type secondary_audiences: list[str]

        :param is_enterprise_app:
            The value to assign to the is_enterprise_app property of this App.
        :type is_enterprise_app: bool

        :param bypass_consent:
            The value to assign to the bypass_consent property of this App.
        :type bypass_consent: bool

        :param disable_kmsi_token_authentication:
            The value to assign to the disable_kmsi_token_authentication property of this App.
        :type disable_kmsi_token_authentication: bool

        :param is_multicloud_service_app:
            The value to assign to the is_multicloud_service_app property of this App.
        :type is_multicloud_service_app: bool

        :param radius_policy:
            The value to assign to the radius_policy property of this App.
        :type radius_policy: oci.identity_domains.models.AppRadiusPolicy

        :param apps_network_perimeters:
            The value to assign to the apps_network_perimeters property of this App.
        :type apps_network_perimeters: list[oci.identity_domains.models.AppAppsNetworkPerimeters]

        :param cloud_control_properties:
            The value to assign to the cloud_control_properties property of this App.
        :type cloud_control_properties: list[oci.identity_domains.models.AppCloudControlProperties]

        :param editable_attributes:
            The value to assign to the editable_attributes property of this App.
        :type editable_attributes: list[oci.identity_domains.models.AppEditableAttributes]

        :param terms_of_use:
            The value to assign to the terms_of_use property of this App.
        :type terms_of_use: oci.identity_domains.models.AppTermsOfUse

        :param protectable_secondary_audiences:
            The value to assign to the protectable_secondary_audiences property of this App.
        :type protectable_secondary_audiences: list[oci.identity_domains.models.AppProtectableSecondaryAudiences]

        :param idp_policy:
            The value to assign to the idp_policy property of this App.
        :type idp_policy: oci.identity_domains.models.AppIdpPolicy

        :param allowed_tags:
            The value to assign to the allowed_tags property of this App.
        :type allowed_tags: list[oci.identity_domains.models.AppAllowedTags]

        :param app_signon_policy:
            The value to assign to the app_signon_policy property of this App.
        :type app_signon_policy: oci.identity_domains.models.AppAppSignonPolicy

        :param trust_policies:
            The value to assign to the trust_policies property of this App.
        :type trust_policies: list[oci.identity_domains.models.AppTrustPolicies]

        :param signon_policy:
            The value to assign to the signon_policy property of this App.
        :type signon_policy: oci.identity_domains.models.AppSignonPolicy

        :param identity_providers:
            The value to assign to the identity_providers property of this App.
        :type identity_providers: list[oci.identity_domains.models.AppIdentityProviders]

        :param accounts:
            The value to assign to the accounts property of this App.
        :type accounts: list[oci.identity_domains.models.AppAccounts]

        :param grants:
            The value to assign to the grants property of this App.
        :type grants: list[oci.identity_domains.models.AppGrants]

        :param service_params:
            The value to assign to the service_params property of this App.
        :type service_params: list[oci.identity_domains.models.AppServiceParams]

        :param attr_rendering_metadata:
            The value to assign to the attr_rendering_metadata property of this App.
        :type attr_rendering_metadata: list[oci.identity_domains.models.AppAttrRenderingMetadata]

        :param based_on_template:
            The value to assign to the based_on_template property of this App.
        :type based_on_template: oci.identity_domains.models.AppBasedOnTemplate

        :param granted_app_roles:
            The value to assign to the granted_app_roles property of this App.
        :type granted_app_roles: list[oci.identity_domains.models.AppGrantedAppRoles]

        :param saml_service_provider:
            The value to assign to the saml_service_provider property of this App.
        :type saml_service_provider: oci.identity_domains.models.AppSamlServiceProvider

        :param allowed_scopes:
            The value to assign to the allowed_scopes property of this App.
        :type allowed_scopes: list[oci.identity_domains.models.AppAllowedScopes]

        :param certificates:
            The value to assign to the certificates property of this App.
        :type certificates: list[oci.identity_domains.models.AppCertificates]

        :param alias_apps:
            The value to assign to the alias_apps property of this App.
        :type alias_apps: list[oci.identity_domains.models.AppAliasApps]

        :param as_opc_service:
            The value to assign to the as_opc_service property of this App.
        :type as_opc_service: oci.identity_domains.models.AppAsOPCService

        :param admin_roles:
            The value to assign to the admin_roles property of this App.
        :type admin_roles: list[oci.identity_domains.models.AppAdminRoles]

        :param user_roles:
            The value to assign to the user_roles property of this App.
        :type user_roles: list[oci.identity_domains.models.AppUserRoles]

        :param scopes:
            The value to assign to the scopes property of this App.
        :type scopes: list[oci.identity_domains.models.AppScopes]

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app: oci.identity_domains.models.AppExtensionRadiusAppApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app: oci.identity_domains.models.AppExtensionSamlServiceProviderApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app: oci.identity_domains.models.AppExtensionWebTierPolicyApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app: oci.identity_domains.models.AppExtensionManagedappApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template: oci.identity_domains.models.AppExtensionFormFillAppTemplateAppTemplate

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app: oci.identity_domains.models.AppExtensionOpcServiceApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app: oci.identity_domains.models.AppExtensionKerberosRealmApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app: oci.identity_domains.models.AppExtensionRequestableApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app: oci.identity_domains.models.AppExtensionFormFillAppApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app: oci.identity_domains.models.AppExtensionDbcsApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app: oci.identity_domains.models.AppExtensionEnterpriseAppApp

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags: oci.identity_domains.models.ExtensionOCITags

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app:
            The value to assign to the urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app property of this App.
        :type urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app: oci.identity_domains.models.AppExtensionMulticloudServiceAppApp

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'meter_as_opc_service': 'bool',
            'name': 'str',
            'client_secret': 'str',
            'hashed_client_secret': 'str',
            'display_name': 'str',
            'description': 'str',
            'id_token_enc_algo': 'str',
            'delegated_service_names': 'list[str]',
            'active': 'bool',
            'app_icon': 'str',
            'app_thumbnail': 'str',
            'migrated': 'bool',
            'infrastructure': 'bool',
            'is_login_target': 'bool',
            'show_in_my_apps': 'bool',
            'login_mechanism': 'str',
            'landing_page_url': 'str',
            'product_logo_url': 'str',
            'privacy_policy_url': 'str',
            'terms_of_service_url': 'str',
            'contact_email_address': 'str',
            'product_name': 'str',
            'home_page_url': 'str',
            'is_form_fill': 'bool',
            'is_o_auth_client': 'bool',
            'is_radius_app': 'bool',
            'client_type': 'str',
            'redirect_uris': 'list[str]',
            'all_url_schemes_allowed': 'bool',
            'logout_uri': 'str',
            'post_logout_redirect_uris': 'list[str]',
            'allowed_grants': 'list[str]',
            'allowed_operations': 'list[str]',
            'client_ip_checking': 'str',
            'is_opc_service': 'bool',
            'is_unmanaged_app': 'bool',
            'allow_access_control': 'bool',
            'is_o_auth_resource': 'bool',
            'access_token_expiry': 'int',
            'refresh_token_expiry': 'int',
            'allow_offline': 'bool',
            'callback_service_url': 'str',
            'audience': 'str',
            'is_mobile_target': 'bool',
            'login_page_url': 'str',
            'linking_callback_url': 'str',
            'logout_page_url': 'str',
            'error_page_url': 'str',
            'is_saml_service_provider': 'bool',
            'is_web_tier_policy': 'bool',
            'is_kerberos_realm': 'bool',
            'icon': 'str',
            'is_alias_app': 'bool',
            'is_managed_app': 'bool',
            'service_type_urn': 'str',
            'service_type_version': 'str',
            'is_obligation_capable': 'bool',
            'ready_to_upgrade': 'bool',
            'trust_scope': 'str',
            'is_database_service': 'bool',
            'secondary_audiences': 'list[str]',
            'is_enterprise_app': 'bool',
            'bypass_consent': 'bool',
            'disable_kmsi_token_authentication': 'bool',
            'is_multicloud_service_app': 'bool',
            'radius_policy': 'AppRadiusPolicy',
            'apps_network_perimeters': 'list[AppAppsNetworkPerimeters]',
            'cloud_control_properties': 'list[AppCloudControlProperties]',
            'editable_attributes': 'list[AppEditableAttributes]',
            'terms_of_use': 'AppTermsOfUse',
            'protectable_secondary_audiences': 'list[AppProtectableSecondaryAudiences]',
            'idp_policy': 'AppIdpPolicy',
            'allowed_tags': 'list[AppAllowedTags]',
            'app_signon_policy': 'AppAppSignonPolicy',
            'trust_policies': 'list[AppTrustPolicies]',
            'signon_policy': 'AppSignonPolicy',
            'identity_providers': 'list[AppIdentityProviders]',
            'accounts': 'list[AppAccounts]',
            'grants': 'list[AppGrants]',
            'service_params': 'list[AppServiceParams]',
            'attr_rendering_metadata': 'list[AppAttrRenderingMetadata]',
            'based_on_template': 'AppBasedOnTemplate',
            'granted_app_roles': 'list[AppGrantedAppRoles]',
            'saml_service_provider': 'AppSamlServiceProvider',
            'allowed_scopes': 'list[AppAllowedScopes]',
            'certificates': 'list[AppCertificates]',
            'alias_apps': 'list[AppAliasApps]',
            'as_opc_service': 'AppAsOPCService',
            'admin_roles': 'list[AppAdminRoles]',
            'user_roles': 'list[AppUserRoles]',
            'scopes': 'list[AppScopes]',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app': 'AppExtensionRadiusAppApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app': 'AppExtensionSamlServiceProviderApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app': 'AppExtensionWebTierPolicyApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app': 'AppExtensionManagedappApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template': 'AppExtensionFormFillAppTemplateAppTemplate',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app': 'AppExtensionOpcServiceApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app': 'AppExtensionKerberosRealmApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app': 'AppExtensionRequestableApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app': 'AppExtensionFormFillAppApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app': 'AppExtensionDbcsApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app': 'AppExtensionEnterpriseAppApp',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags': 'ExtensionOCITags',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app': 'AppExtensionMulticloudServiceAppApp'
        }
        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'meter_as_opc_service': 'meterAsOPCService',
            'name': 'name',
            'client_secret': 'clientSecret',
            'hashed_client_secret': 'hashedClientSecret',
            'display_name': 'displayName',
            'description': 'description',
            'id_token_enc_algo': 'idTokenEncAlgo',
            'delegated_service_names': 'delegatedServiceNames',
            'active': 'active',
            'app_icon': 'appIcon',
            'app_thumbnail': 'appThumbnail',
            'migrated': 'migrated',
            'infrastructure': 'infrastructure',
            'is_login_target': 'isLoginTarget',
            'show_in_my_apps': 'showInMyApps',
            'login_mechanism': 'loginMechanism',
            'landing_page_url': 'landingPageUrl',
            'product_logo_url': 'productLogoUrl',
            'privacy_policy_url': 'privacyPolicyUrl',
            'terms_of_service_url': 'termsOfServiceUrl',
            'contact_email_address': 'contactEmailAddress',
            'product_name': 'productName',
            'home_page_url': 'homePageUrl',
            'is_form_fill': 'isFormFill',
            'is_o_auth_client': 'isOAuthClient',
            'is_radius_app': 'isRadiusApp',
            'client_type': 'clientType',
            'redirect_uris': 'redirectUris',
            'all_url_schemes_allowed': 'allUrlSchemesAllowed',
            'logout_uri': 'logoutUri',
            'post_logout_redirect_uris': 'postLogoutRedirectUris',
            'allowed_grants': 'allowedGrants',
            'allowed_operations': 'allowedOperations',
            'client_ip_checking': 'clientIPChecking',
            'is_opc_service': 'isOPCService',
            'is_unmanaged_app': 'isUnmanagedApp',
            'allow_access_control': 'allowAccessControl',
            'is_o_auth_resource': 'isOAuthResource',
            'access_token_expiry': 'accessTokenExpiry',
            'refresh_token_expiry': 'refreshTokenExpiry',
            'allow_offline': 'allowOffline',
            'callback_service_url': 'callbackServiceUrl',
            'audience': 'audience',
            'is_mobile_target': 'isMobileTarget',
            'login_page_url': 'loginPageUrl',
            'linking_callback_url': 'linkingCallbackUrl',
            'logout_page_url': 'logoutPageUrl',
            'error_page_url': 'errorPageUrl',
            'is_saml_service_provider': 'isSamlServiceProvider',
            'is_web_tier_policy': 'isWebTierPolicy',
            'is_kerberos_realm': 'isKerberosRealm',
            'icon': 'icon',
            'is_alias_app': 'isAliasApp',
            'is_managed_app': 'isManagedApp',
            'service_type_urn': 'serviceTypeURN',
            'service_type_version': 'serviceTypeVersion',
            'is_obligation_capable': 'isObligationCapable',
            'ready_to_upgrade': 'readyToUpgrade',
            'trust_scope': 'trustScope',
            'is_database_service': 'isDatabaseService',
            'secondary_audiences': 'secondaryAudiences',
            'is_enterprise_app': 'isEnterpriseApp',
            'bypass_consent': 'bypassConsent',
            'disable_kmsi_token_authentication': 'disableKmsiTokenAuthentication',
            'is_multicloud_service_app': 'isMulticloudServiceApp',
            'radius_policy': 'radiusPolicy',
            'apps_network_perimeters': 'appsNetworkPerimeters',
            'cloud_control_properties': 'cloudControlProperties',
            'editable_attributes': 'editableAttributes',
            'terms_of_use': 'termsOfUse',
            'protectable_secondary_audiences': 'protectableSecondaryAudiences',
            'idp_policy': 'idpPolicy',
            'allowed_tags': 'allowedTags',
            'app_signon_policy': 'appSignonPolicy',
            'trust_policies': 'trustPolicies',
            'signon_policy': 'signonPolicy',
            'identity_providers': 'identityProviders',
            'accounts': 'accounts',
            'grants': 'grants',
            'service_params': 'serviceParams',
            'attr_rendering_metadata': 'attrRenderingMetadata',
            'based_on_template': 'basedOnTemplate',
            'granted_app_roles': 'grantedAppRoles',
            'saml_service_provider': 'samlServiceProvider',
            'allowed_scopes': 'allowedScopes',
            'certificates': 'certificates',
            'alias_apps': 'aliasApps',
            'as_opc_service': 'asOPCService',
            'admin_roles': 'adminRoles',
            'user_roles': 'userRoles',
            'scopes': 'scopes',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:radiusApp:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:samlServiceProvider:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:webTierPolicy:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:managedapp:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:formFillAppTemplate:AppTemplate',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:opcService:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:kerberosRealm:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:requestable:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:formFillApp:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:dbcs:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:enterpriseApp:App',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:OCITags',
            'urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app': 'urn:ietf:params:scim:schemas:oracle:idcs:extension:multicloudServiceApp:App'
        }
        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._meter_as_opc_service = None
        self._name = None
        self._client_secret = None
        self._hashed_client_secret = None
        self._display_name = None
        self._description = None
        self._id_token_enc_algo = None
        self._delegated_service_names = None
        self._active = None
        self._app_icon = None
        self._app_thumbnail = None
        self._migrated = None
        self._infrastructure = None
        self._is_login_target = None
        self._show_in_my_apps = None
        self._login_mechanism = None
        self._landing_page_url = None
        self._product_logo_url = None
        self._privacy_policy_url = None
        self._terms_of_service_url = None
        self._contact_email_address = None
        self._product_name = None
        self._home_page_url = None
        self._is_form_fill = None
        self._is_o_auth_client = None
        self._is_radius_app = None
        self._client_type = None
        self._redirect_uris = None
        self._all_url_schemes_allowed = None
        self._logout_uri = None
        self._post_logout_redirect_uris = None
        self._allowed_grants = None
        self._allowed_operations = None
        self._client_ip_checking = None
        self._is_opc_service = None
        self._is_unmanaged_app = None
        self._allow_access_control = None
        self._is_o_auth_resource = None
        self._access_token_expiry = None
        self._refresh_token_expiry = None
        self._allow_offline = None
        self._callback_service_url = None
        self._audience = None
        self._is_mobile_target = None
        self._login_page_url = None
        self._linking_callback_url = None
        self._logout_page_url = None
        self._error_page_url = None
        self._is_saml_service_provider = None
        self._is_web_tier_policy = None
        self._is_kerberos_realm = None
        self._icon = None
        self._is_alias_app = None
        self._is_managed_app = None
        self._service_type_urn = None
        self._service_type_version = None
        self._is_obligation_capable = None
        self._ready_to_upgrade = None
        self._trust_scope = None
        self._is_database_service = None
        self._secondary_audiences = None
        self._is_enterprise_app = None
        self._bypass_consent = None
        self._disable_kmsi_token_authentication = None
        self._is_multicloud_service_app = None
        self._radius_policy = None
        self._apps_network_perimeters = None
        self._cloud_control_properties = None
        self._editable_attributes = None
        self._terms_of_use = None
        self._protectable_secondary_audiences = None
        self._idp_policy = None
        self._allowed_tags = None
        self._app_signon_policy = None
        self._trust_policies = None
        self._signon_policy = None
        self._identity_providers = None
        self._accounts = None
        self._grants = None
        self._service_params = None
        self._attr_rendering_metadata = None
        self._based_on_template = None
        self._granted_app_roles = None
        self._saml_service_provider = None
        self._allowed_scopes = None
        self._certificates = None
        self._alias_apps = None
        self._as_opc_service = None
        self._admin_roles = None
        self._user_roles = None
        self._scopes = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags = None
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app = None

    @property
    def id(self):
        """
        Gets the id of this App.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this App.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this App.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this App.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this App.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this App.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this App.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this App.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this App.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this App.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this App.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this App.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this App.

        :return: The meta of this App.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this App.

        :param meta: The meta of this App.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this App.

        :return: The idcs_created_by of this App.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this App.

        :param idcs_created_by: The idcs_created_by of this App.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this App.

        :return: The idcs_last_modified_by of this App.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this App.

        :param idcs_last_modified_by: The idcs_last_modified_by of this App.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this App.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this App.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this App.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this App.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this App.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this App.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this App.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this App.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this App.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this App.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this App.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this App.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this App.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this App.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this App.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this App.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this App.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this App.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this App.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this App.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this App.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this App.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this App.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this App.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this App.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this App.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this App.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this App.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def meter_as_opc_service(self):
        """
        Gets the meter_as_opc_service of this App.
        Indicates whether the application is billed as an OPCService. If true, customer is not billed for runtime operations of the app.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: boolean
         - uniqueness: none


        :return: The meter_as_opc_service of this App.
        :rtype: bool
        """
        return self._meter_as_opc_service

    @meter_as_opc_service.setter
    def meter_as_opc_service(self, meter_as_opc_service):
        """
        Sets the meter_as_opc_service of this App.
        Indicates whether the application is billed as an OPCService. If true, customer is not billed for runtime operations of the app.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: boolean
         - uniqueness: none


        :param meter_as_opc_service: The meter_as_opc_service of this App.
        :type: bool
        """
        self._meter_as_opc_service = meter_as_opc_service

    @property
    def name(self):
        """
        Gets the name of this App.
        Name of the application. Also serves as username if the application authenticates to Oracle Public Cloud infrastructure. This name may not be user-friendly and cannot be changed once an App is created.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :return: The name of this App.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this App.
        Name of the application. Also serves as username if the application authenticates to Oracle Public Cloud infrastructure. This name may not be user-friendly and cannot be changed once an App is created.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :param name: The name of this App.
        :type: str
        """
        self._name = name

    @property
    def client_secret(self):
        """
        Gets the client_secret of this App.
        This value is the credential of this App, which this App supplies as a password when this App authenticates to the Oracle Public Cloud infrastructure. This value is also the client secret of this App when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - idcsSensitive: none
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The client_secret of this App.
        :rtype: str
        """
        return self._client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        """
        Sets the client_secret of this App.
        This value is the credential of this App, which this App supplies as a password when this App authenticates to the Oracle Public Cloud infrastructure. This value is also the client secret of this App when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - idcsSensitive: none
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param client_secret: The client_secret of this App.
        :type: str
        """
        self._client_secret = client_secret

    @property
    def hashed_client_secret(self):
        """
        Gets the hashed_client_secret of this App.
        Hashed Client Secret. This hash-value is used to verify the 'clientSecret' credential of this App

        **Added In:** 2106240046

        **SCIM++ Properties:**
         - idcsSearchable: false
         - idcsSensitive: hash_sc
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The hashed_client_secret of this App.
        :rtype: str
        """
        return self._hashed_client_secret

    @hashed_client_secret.setter
    def hashed_client_secret(self, hashed_client_secret):
        """
        Sets the hashed_client_secret of this App.
        Hashed Client Secret. This hash-value is used to verify the 'clientSecret' credential of this App

        **Added In:** 2106240046

        **SCIM++ Properties:**
         - idcsSearchable: false
         - idcsSensitive: hash_sc
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param hashed_client_secret: The hashed_client_secret of this App.
        :type: str
        """
        self._hashed_client_secret = hashed_client_secret

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this App.
        Display name of the application. Display name is intended to be user-friendly, and an administrator can change the value at any time.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: always
         - type: string
         - uniqueness: server


        :return: The display_name of this App.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this App.
        Display name of the application. Display name is intended to be user-friendly, and an administrator can change the value at any time.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: always
         - type: string
         - uniqueness: server


        :param display_name: The display_name of this App.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this App.
        Description of the application.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The description of this App.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this App.
        Description of the application.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param description: The description of this App.
        :type: str
        """
        self._description = description

    @property
    def id_token_enc_algo(self):
        """
        Gets the id_token_enc_algo of this App.
        Encryption Alogrithm to use for encrypting ID token.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The id_token_enc_algo of this App.
        :rtype: str
        """
        return self._id_token_enc_algo

    @id_token_enc_algo.setter
    def id_token_enc_algo(self, id_token_enc_algo):
        """
        Sets the id_token_enc_algo of this App.
        Encryption Alogrithm to use for encrypting ID token.

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param id_token_enc_algo: The id_token_enc_algo of this App.
        :type: str
        """
        self._id_token_enc_algo = id_token_enc_algo

    @property
    def delegated_service_names(self):
        """
        Gets the delegated_service_names of this App.
        Service Names allow to use OCI signature for client authentication instead of client credentials

        **Added In:** 2207040824

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The delegated_service_names of this App.
        :rtype: list[str]
        """
        return self._delegated_service_names

    @delegated_service_names.setter
    def delegated_service_names(self, delegated_service_names):
        """
        Sets the delegated_service_names of this App.
        Service Names allow to use OCI signature for client authentication instead of client credentials

        **Added In:** 2207040824

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param delegated_service_names: The delegated_service_names of this App.
        :type: list[str]
        """
        self._delegated_service_names = delegated_service_names

    @property
    def active(self):
        """
        Gets the active of this App.
        If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The active of this App.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this App.
        If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param active: The active of this App.
        :type: bool
        """
        self._active = active

    @property
    def app_icon(self):
        """
        Gets the app_icon of this App.
        Application icon.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The app_icon of this App.
        :rtype: str
        """
        return self._app_icon

    @app_icon.setter
    def app_icon(self, app_icon):
        """
        Sets the app_icon of this App.
        Application icon.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param app_icon: The app_icon of this App.
        :type: str
        """
        self._app_icon = app_icon

    @property
    def app_thumbnail(self):
        """
        Gets the app_thumbnail of this App.
        Application thumbnail.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The app_thumbnail of this App.
        :rtype: str
        """
        return self._app_thumbnail

    @app_thumbnail.setter
    def app_thumbnail(self, app_thumbnail):
        """
        Sets the app_thumbnail of this App.
        Application thumbnail.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param app_thumbnail: The app_thumbnail of this App.
        :type: str
        """
        self._app_thumbnail = app_thumbnail

    @property
    def migrated(self):
        """
        Gets the migrated of this App.
        If true, this App was migrated from an earlier version of Oracle Public Cloud infrastructure (and may therefore require special handling from runtime services such as OAuth or SAML). If false, this App requires no special handling from runtime services.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The migrated of this App.
        :rtype: bool
        """
        return self._migrated

    @migrated.setter
    def migrated(self, migrated):
        """
        Sets the migrated of this App.
        If true, this App was migrated from an earlier version of Oracle Public Cloud infrastructure (and may therefore require special handling from runtime services such as OAuth or SAML). If false, this App requires no special handling from runtime services.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param migrated: The migrated of this App.
        :type: bool
        """
        self._migrated = migrated

    @property
    def infrastructure(self):
        """
        Gets the infrastructure of this App.
        If true, this App is an internal infrastructure App.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The infrastructure of this App.
        :rtype: bool
        """
        return self._infrastructure

    @infrastructure.setter
    def infrastructure(self, infrastructure):
        """
        Sets the infrastructure of this App.
        If true, this App is an internal infrastructure App.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param infrastructure: The infrastructure of this App.
        :type: bool
        """
        self._infrastructure = infrastructure

    @property
    def is_login_target(self):
        """
        Gets the is_login_target of this App.
        If true, this App allows runtime services to log end users into this App automatically.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_login_target of this App.
        :rtype: bool
        """
        return self._is_login_target

    @is_login_target.setter
    def is_login_target(self, is_login_target):
        """
        Sets the is_login_target of this App.
        If true, this App allows runtime services to log end users into this App automatically.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_login_target: The is_login_target of this App.
        :type: bool
        """
        self._is_login_target = is_login_target

    @property
    def show_in_my_apps(self):
        """
        Gets the show_in_my_apps of this App.
        If true, this app will be displayed in the MyApps page of each end-user who has access to the App.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The show_in_my_apps of this App.
        :rtype: bool
        """
        return self._show_in_my_apps

    @show_in_my_apps.setter
    def show_in_my_apps(self, show_in_my_apps):
        """
        Sets the show_in_my_apps of this App.
        If true, this app will be displayed in the MyApps page of each end-user who has access to the App.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param show_in_my_apps: The show_in_my_apps of this App.
        :type: bool
        """
        self._show_in_my_apps = show_in_my_apps

    @property
    def login_mechanism(self):
        """
        Gets the login_mechanism of this App.
        The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "OIDC", "SAML", "FORMFILL", "RADIUS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The login_mechanism of this App.
        :rtype: str
        """
        return self._login_mechanism

    @login_mechanism.setter
    def login_mechanism(self, login_mechanism):
        """
        Sets the login_mechanism of this App.
        The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param login_mechanism: The login_mechanism of this App.
        :type: str
        """
        allowed_values = ["OIDC", "SAML", "FORMFILL", "RADIUS"]
        if not value_allowed_none_or_none_sentinel(login_mechanism, allowed_values):
            login_mechanism = 'UNKNOWN_ENUM_VALUE'
        self._login_mechanism = login_mechanism

    @property
    def landing_page_url(self):
        """
        Gets the landing_page_url of this App.
        The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The landing_page_url of this App.
        :rtype: str
        """
        return self._landing_page_url

    @landing_page_url.setter
    def landing_page_url(self, landing_page_url):
        """
        Sets the landing_page_url of this App.
        The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param landing_page_url: The landing_page_url of this App.
        :type: str
        """
        self._landing_page_url = landing_page_url

    @property
    def product_logo_url(self):
        """
        Gets the product_logo_url of this App.
        Application Logo URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The product_logo_url of this App.
        :rtype: str
        """
        return self._product_logo_url

    @product_logo_url.setter
    def product_logo_url(self, product_logo_url):
        """
        Sets the product_logo_url of this App.
        Application Logo URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param product_logo_url: The product_logo_url of this App.
        :type: str
        """
        self._product_logo_url = product_logo_url

    @property
    def privacy_policy_url(self):
        """
        Gets the privacy_policy_url of this App.
        Privacy Policy URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The privacy_policy_url of this App.
        :rtype: str
        """
        return self._privacy_policy_url

    @privacy_policy_url.setter
    def privacy_policy_url(self, privacy_policy_url):
        """
        Sets the privacy_policy_url of this App.
        Privacy Policy URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param privacy_policy_url: The privacy_policy_url of this App.
        :type: str
        """
        self._privacy_policy_url = privacy_policy_url

    @property
    def terms_of_service_url(self):
        """
        Gets the terms_of_service_url of this App.
        Terms of Service URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The terms_of_service_url of this App.
        :rtype: str
        """
        return self._terms_of_service_url

    @terms_of_service_url.setter
    def terms_of_service_url(self, terms_of_service_url):
        """
        Sets the terms_of_service_url of this App.
        Terms of Service URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param terms_of_service_url: The terms_of_service_url of this App.
        :type: str
        """
        self._terms_of_service_url = terms_of_service_url

    @property
    def contact_email_address(self):
        """
        Gets the contact_email_address of this App.
        Contact Email Address

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The contact_email_address of this App.
        :rtype: str
        """
        return self._contact_email_address

    @contact_email_address.setter
    def contact_email_address(self, contact_email_address):
        """
        Sets the contact_email_address of this App.
        Contact Email Address

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param contact_email_address: The contact_email_address of this App.
        :type: str
        """
        self._contact_email_address = contact_email_address

    @property
    def product_name(self):
        """
        Gets the product_name of this App.
        Product Name

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The product_name of this App.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """
        Sets the product_name of this App.
        Product Name

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param product_name: The product_name of this App.
        :type: str
        """
        self._product_name = product_name

    @property
    def home_page_url(self):
        """
        Gets the home_page_url of this App.
        Home Page URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The home_page_url of this App.
        :rtype: str
        """
        return self._home_page_url

    @home_page_url.setter
    def home_page_url(self, home_page_url):
        """
        Sets the home_page_url of this App.
        Home Page URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param home_page_url: The home_page_url of this App.
        :type: str
        """
        self._home_page_url = home_page_url

    @property
    def is_form_fill(self):
        """
        Gets the is_form_fill of this App.
        If true, this application acts as FormFill Application

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_form_fill of this App.
        :rtype: bool
        """
        return self._is_form_fill

    @is_form_fill.setter
    def is_form_fill(self, is_form_fill):
        """
        Sets the is_form_fill of this App.
        If true, this application acts as FormFill Application

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_form_fill: The is_form_fill of this App.
        :type: bool
        """
        self._is_form_fill = is_form_fill

    @property
    def is_o_auth_client(self):
        """
        Gets the is_o_auth_client of this App.
        If true, this application acts as an OAuth Client

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_o_auth_client of this App.
        :rtype: bool
        """
        return self._is_o_auth_client

    @is_o_auth_client.setter
    def is_o_auth_client(self, is_o_auth_client):
        """
        Sets the is_o_auth_client of this App.
        If true, this application acts as an OAuth Client

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_o_auth_client: The is_o_auth_client of this App.
        :type: bool
        """
        self._is_o_auth_client = is_o_auth_client

    @property
    def is_radius_app(self):
        """
        Gets the is_radius_app of this App.
        If true, this application acts as an Radius App

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_radius_app of this App.
        :rtype: bool
        """
        return self._is_radius_app

    @is_radius_app.setter
    def is_radius_app(self, is_radius_app):
        """
        Sets the is_radius_app of this App.
        If true, this application acts as an Radius App

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_radius_app: The is_radius_app of this App.
        :type: bool
        """
        self._is_radius_app = is_radius_app

    @property
    def client_type(self):
        """
        Gets the client_type of this App.
        Specifies the type of access that this App has when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "confidential", "public", "trusted", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The client_type of this App.
        :rtype: str
        """
        return self._client_type

    @client_type.setter
    def client_type(self, client_type):
        """
        Sets the client_type of this App.
        Specifies the type of access that this App has when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param client_type: The client_type of this App.
        :type: str
        """
        allowed_values = ["confidential", "public", "trusted"]
        if not value_allowed_none_or_none_sentinel(client_type, allowed_values):
            client_type = 'UNKNOWN_ENUM_VALUE'
        self._client_type = client_type

    @property
    def redirect_uris(self):
        """
        Gets the redirect_uris of this App.
        OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The redirect_uris of this App.
        :rtype: list[str]
        """
        return self._redirect_uris

    @redirect_uris.setter
    def redirect_uris(self, redirect_uris):
        """
        Sets the redirect_uris of this App.
        OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param redirect_uris: The redirect_uris of this App.
        :type: list[str]
        """
        self._redirect_uris = redirect_uris

    @property
    def all_url_schemes_allowed(self):
        """
        Gets the all_url_schemes_allowed of this App.
        If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The all_url_schemes_allowed of this App.
        :rtype: bool
        """
        return self._all_url_schemes_allowed

    @all_url_schemes_allowed.setter
    def all_url_schemes_allowed(self, all_url_schemes_allowed):
        """
        Sets the all_url_schemes_allowed of this App.
        If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param all_url_schemes_allowed: The all_url_schemes_allowed of this App.
        :type: bool
        """
        self._all_url_schemes_allowed = all_url_schemes_allowed

    @property
    def logout_uri(self):
        """
        Gets the logout_uri of this App.
        OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The logout_uri of this App.
        :rtype: str
        """
        return self._logout_uri

    @logout_uri.setter
    def logout_uri(self, logout_uri):
        """
        Sets the logout_uri of this App.
        OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param logout_uri: The logout_uri of this App.
        :type: str
        """
        self._logout_uri = logout_uri

    @property
    def post_logout_redirect_uris(self):
        """
        Gets the post_logout_redirect_uris of this App.
        Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The post_logout_redirect_uris of this App.
        :rtype: list[str]
        """
        return self._post_logout_redirect_uris

    @post_logout_redirect_uris.setter
    def post_logout_redirect_uris(self, post_logout_redirect_uris):
        """
        Sets the post_logout_redirect_uris of this App.
        Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param post_logout_redirect_uris: The post_logout_redirect_uris of this App.
        :type: list[str]
        """
        self._post_logout_redirect_uris = post_logout_redirect_uris

    @property
    def allowed_grants(self):
        """
        Gets the allowed_grants of this App.
        List of grant-types that this App is allowed to use when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The allowed_grants of this App.
        :rtype: list[str]
        """
        return self._allowed_grants

    @allowed_grants.setter
    def allowed_grants(self, allowed_grants):
        """
        Sets the allowed_grants of this App.
        List of grant-types that this App is allowed to use when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param allowed_grants: The allowed_grants of this App.
        :type: list[str]
        """
        self._allowed_grants = allowed_grants

    @property
    def allowed_operations(self):
        """
        Gets the allowed_operations of this App.
        OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "introspect", "onBehalfOfUser", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The allowed_operations of this App.
        :rtype: list[str]
        """
        return self._allowed_operations

    @allowed_operations.setter
    def allowed_operations(self, allowed_operations):
        """
        Sets the allowed_operations of this App.
        OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param allowed_operations: The allowed_operations of this App.
        :type: list[str]
        """
        allowed_values = ["introspect", "onBehalfOfUser"]
        if allowed_operations:
            allowed_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in allowed_operations]
        self._allowed_operations = allowed_operations

    @property
    def client_ip_checking(self):
        """
        Gets the client_ip_checking of this App.
        Network Perimeters checking mode

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "anywhere", "whitelisted", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The client_ip_checking of this App.
        :rtype: str
        """
        return self._client_ip_checking

    @client_ip_checking.setter
    def client_ip_checking(self, client_ip_checking):
        """
        Sets the client_ip_checking of this App.
        Network Perimeters checking mode

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param client_ip_checking: The client_ip_checking of this App.
        :type: str
        """
        allowed_values = ["anywhere", "whitelisted"]
        if not value_allowed_none_or_none_sentinel(client_ip_checking, allowed_values):
            client_ip_checking = 'UNKNOWN_ENUM_VALUE'
        self._client_ip_checking = client_ip_checking

    @property
    def is_opc_service(self):
        """
        Gets the is_opc_service of this App.
        If true, this application is an Oracle Public Cloud service-instance.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_opc_service of this App.
        :rtype: bool
        """
        return self._is_opc_service

    @is_opc_service.setter
    def is_opc_service(self, is_opc_service):
        """
        Sets the is_opc_service of this App.
        If true, this application is an Oracle Public Cloud service-instance.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_opc_service: The is_opc_service of this App.
        :type: bool
        """
        self._is_opc_service = is_opc_service

    @property
    def is_unmanaged_app(self):
        """
        Gets the is_unmanaged_app of this App.
        If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_unmanaged_app of this App.
        :rtype: bool
        """
        return self._is_unmanaged_app

    @is_unmanaged_app.setter
    def is_unmanaged_app(self, is_unmanaged_app):
        """
        Sets the is_unmanaged_app of this App.
        If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_unmanaged_app: The is_unmanaged_app of this App.
        :type: bool
        """
        self._is_unmanaged_app = is_unmanaged_app

    @property
    def allow_access_control(self):
        """
        Gets the allow_access_control of this App.
        If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The allow_access_control of this App.
        :rtype: bool
        """
        return self._allow_access_control

    @allow_access_control.setter
    def allow_access_control(self, allow_access_control):
        """
        Sets the allow_access_control of this App.
        If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param allow_access_control: The allow_access_control of this App.
        :type: bool
        """
        self._allow_access_control = allow_access_control

    @property
    def is_o_auth_resource(self):
        """
        Gets the is_o_auth_resource of this App.
        If true, indicates that this application acts as an OAuth Resource.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_o_auth_resource of this App.
        :rtype: bool
        """
        return self._is_o_auth_resource

    @is_o_auth_resource.setter
    def is_o_auth_resource(self, is_o_auth_resource):
        """
        Sets the is_o_auth_resource of this App.
        If true, indicates that this application acts as an OAuth Resource.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_o_auth_resource: The is_o_auth_resource of this App.
        :type: bool
        """
        self._is_o_auth_resource = is_o_auth_resource

    @property
    def access_token_expiry(self):
        """
        Gets the access_token_expiry of this App.
        Expiry-time in seconds for an Access Token. Any token that allows access to this App will expire after the specified duration.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The access_token_expiry of this App.
        :rtype: int
        """
        return self._access_token_expiry

    @access_token_expiry.setter
    def access_token_expiry(self, access_token_expiry):
        """
        Sets the access_token_expiry of this App.
        Expiry-time in seconds for an Access Token. Any token that allows access to this App will expire after the specified duration.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param access_token_expiry: The access_token_expiry of this App.
        :type: int
        """
        self._access_token_expiry = access_token_expiry

    @property
    def refresh_token_expiry(self):
        """
        Gets the refresh_token_expiry of this App.
        Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The refresh_token_expiry of this App.
        :rtype: int
        """
        return self._refresh_token_expiry

    @refresh_token_expiry.setter
    def refresh_token_expiry(self, refresh_token_expiry):
        """
        Sets the refresh_token_expiry of this App.
        Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param refresh_token_expiry: The refresh_token_expiry of this App.
        :type: int
        """
        self._refresh_token_expiry = refresh_token_expiry

    @property
    def allow_offline(self):
        """
        Gets the allow_offline of this App.
        If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The allow_offline of this App.
        :rtype: bool
        """
        return self._allow_offline

    @allow_offline.setter
    def allow_offline(self, allow_offline):
        """
        Sets the allow_offline of this App.
        If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param allow_offline: The allow_offline of this App.
        :type: bool
        """
        self._allow_offline = allow_offline

    @property
    def callback_service_url(self):
        """
        Gets the callback_service_url of this App.
        Callback Service URL

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The callback_service_url of this App.
        :rtype: str
        """
        return self._callback_service_url

    @callback_service_url.setter
    def callback_service_url(self, callback_service_url):
        """
        Sets the callback_service_url of this App.
        Callback Service URL

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param callback_service_url: The callback_service_url of this App.
        :type: str
        """
        self._callback_service_url = callback_service_url

    @property
    def audience(self):
        """
        Gets the audience of this App.
        The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The audience of this App.
        :rtype: str
        """
        return self._audience

    @audience.setter
    def audience(self, audience):
        """
        Sets the audience of this App.
        The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param audience: The audience of this App.
        :type: str
        """
        self._audience = audience

    @property
    def is_mobile_target(self):
        """
        Gets the is_mobile_target of this App.
        If true, indicates that the App should be visible in each end-user's mobile application.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_mobile_target of this App.
        :rtype: bool
        """
        return self._is_mobile_target

    @is_mobile_target.setter
    def is_mobile_target(self, is_mobile_target):
        """
        Sets the is_mobile_target of this App.
        If true, indicates that the App should be visible in each end-user's mobile application.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_mobile_target: The is_mobile_target of this App.
        :type: bool
        """
        self._is_mobile_target = is_mobile_target

    @property
    def login_page_url(self):
        """
        Gets the login_page_url of this App.
        This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The login_page_url of this App.
        :rtype: str
        """
        return self._login_page_url

    @login_page_url.setter
    def login_page_url(self, login_page_url):
        """
        Sets the login_page_url of this App.
        This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param login_page_url: The login_page_url of this App.
        :type: str
        """
        self._login_page_url = login_page_url

    @property
    def linking_callback_url(self):
        """
        Gets the linking_callback_url of this App.
        This attribute specifies the callback URL for the social linking operation.

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The linking_callback_url of this App.
        :rtype: str
        """
        return self._linking_callback_url

    @linking_callback_url.setter
    def linking_callback_url(self, linking_callback_url):
        """
        Sets the linking_callback_url of this App.
        This attribute specifies the callback URL for the social linking operation.

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param linking_callback_url: The linking_callback_url of this App.
        :type: str
        """
        self._linking_callback_url = linking_callback_url

    @property
    def logout_page_url(self):
        """
        Gets the logout_page_url of this App.
        This attribute specifies the URL of the page that the App uses when an end-user signs out.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The logout_page_url of this App.
        :rtype: str
        """
        return self._logout_page_url

    @logout_page_url.setter
    def logout_page_url(self, logout_page_url):
        """
        Sets the logout_page_url of this App.
        This attribute specifies the URL of the page that the App uses when an end-user signs out.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param logout_page_url: The logout_page_url of this App.
        :type: str
        """
        self._logout_page_url = logout_page_url

    @property
    def error_page_url(self):
        """
        Gets the error_page_url of this App.
        This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The error_page_url of this App.
        :rtype: str
        """
        return self._error_page_url

    @error_page_url.setter
    def error_page_url(self, error_page_url):
        """
        Sets the error_page_url of this App.
        This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param error_page_url: The error_page_url of this App.
        :type: str
        """
        self._error_page_url = error_page_url

    @property
    def is_saml_service_provider(self):
        """
        Gets the is_saml_service_provider of this App.
        If true, then this App acts as a SAML Service Provider.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_saml_service_provider of this App.
        :rtype: bool
        """
        return self._is_saml_service_provider

    @is_saml_service_provider.setter
    def is_saml_service_provider(self, is_saml_service_provider):
        """
        Sets the is_saml_service_provider of this App.
        If true, then this App acts as a SAML Service Provider.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_saml_service_provider: The is_saml_service_provider of this App.
        :type: bool
        """
        self._is_saml_service_provider = is_saml_service_provider

    @property
    def is_web_tier_policy(self):
        """
        Gets the is_web_tier_policy of this App.
        If true, the webtier policy is active

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_web_tier_policy of this App.
        :rtype: bool
        """
        return self._is_web_tier_policy

    @is_web_tier_policy.setter
    def is_web_tier_policy(self, is_web_tier_policy):
        """
        Sets the is_web_tier_policy of this App.
        If true, the webtier policy is active

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_web_tier_policy: The is_web_tier_policy of this App.
        :type: bool
        """
        self._is_web_tier_policy = is_web_tier_policy

    @property
    def is_kerberos_realm(self):
        """
        Gets the is_kerberos_realm of this App.
        If true, indicates that this App supports Kerberos Authentication

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_kerberos_realm of this App.
        :rtype: bool
        """
        return self._is_kerberos_realm

    @is_kerberos_realm.setter
    def is_kerberos_realm(self, is_kerberos_realm):
        """
        Sets the is_kerberos_realm of this App.
        If true, indicates that this App supports Kerberos Authentication

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_kerberos_realm: The is_kerberos_realm of this App.
        :type: bool
        """
        self._is_kerberos_realm = is_kerberos_realm

    @property
    def icon(self):
        """
        Gets the icon of this App.
        URL of application icon.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :return: The icon of this App.
        :rtype: str
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """
        Sets the icon of this App.
        URL of application icon.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :param icon: The icon of this App.
        :type: str
        """
        self._icon = icon

    @property
    def is_alias_app(self):
        """
        Gets the is_alias_app of this App.
        If true, this App is an AliasApp and it cannot be granted to an end-user directly.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: always
         - type: boolean
         - uniqueness: none


        :return: The is_alias_app of this App.
        :rtype: bool
        """
        return self._is_alias_app

    @is_alias_app.setter
    def is_alias_app(self, is_alias_app):
        """
        Sets the is_alias_app of this App.
        If true, this App is an AliasApp and it cannot be granted to an end-user directly.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: always
         - type: boolean
         - uniqueness: none


        :param is_alias_app: The is_alias_app of this App.
        :type: bool
        """
        self._is_alias_app = is_alias_app

    @property
    def is_managed_app(self):
        """
        Gets the is_managed_app of this App.
        If true, indicates that access to this App requires an account. That is, in order to log in to the App, a User must use an application-specific identity that is maintained in the remote identity-repository of that App.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_managed_app of this App.
        :rtype: bool
        """
        return self._is_managed_app

    @is_managed_app.setter
    def is_managed_app(self, is_managed_app):
        """
        Sets the is_managed_app of this App.
        If true, indicates that access to this App requires an account. That is, in order to log in to the App, a User must use an application-specific identity that is maintained in the remote identity-repository of that App.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_managed_app: The is_managed_app of this App.
        :type: bool
        """
        self._is_managed_app = is_managed_app

    @property
    def service_type_urn(self):
        """
        Gets the service_type_urn of this App.
        This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The service_type_urn of this App.
        :rtype: str
        """
        return self._service_type_urn

    @service_type_urn.setter
    def service_type_urn(self, service_type_urn):
        """
        Sets the service_type_urn of this App.
        This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param service_type_urn: The service_type_urn of this App.
        :type: str
        """
        self._service_type_urn = service_type_urn

    @property
    def service_type_version(self):
        """
        Gets the service_type_version of this App.
        This value specifies the version of the Oracle Public Cloud service of which this App is an instance

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The service_type_version of this App.
        :rtype: str
        """
        return self._service_type_version

    @service_type_version.setter
    def service_type_version(self, service_type_version):
        """
        Sets the service_type_version of this App.
        This value specifies the version of the Oracle Public Cloud service of which this App is an instance

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param service_type_version: The service_type_version of this App.
        :type: str
        """
        self._service_type_version = service_type_version

    @property
    def is_obligation_capable(self):
        """
        Gets the is_obligation_capable of this App.
        This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_obligation_capable of this App.
        :rtype: bool
        """
        return self._is_obligation_capable

    @is_obligation_capable.setter
    def is_obligation_capable(self, is_obligation_capable):
        """
        Sets the is_obligation_capable of this App.
        This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_obligation_capable: The is_obligation_capable of this App.
        :type: bool
        """
        self._is_obligation_capable = is_obligation_capable

    @property
    def ready_to_upgrade(self):
        """
        Gets the ready_to_upgrade of this App.
        If true, this App requires an upgrade and mandates attention from application administrator. The flag is used by UI to indicate this app is ready to upgrade.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The ready_to_upgrade of this App.
        :rtype: bool
        """
        return self._ready_to_upgrade

    @ready_to_upgrade.setter
    def ready_to_upgrade(self, ready_to_upgrade):
        """
        Sets the ready_to_upgrade of this App.
        If true, this App requires an upgrade and mandates attention from application administrator. The flag is used by UI to indicate this app is ready to upgrade.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param ready_to_upgrade: The ready_to_upgrade of this App.
        :type: bool
        """
        self._ready_to_upgrade = ready_to_upgrade

    @property
    def trust_scope(self):
        """
        Gets the trust_scope of this App.
        Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "Explicit", "Account", "Tags", "Default", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The trust_scope of this App.
        :rtype: str
        """
        return self._trust_scope

    @trust_scope.setter
    def trust_scope(self, trust_scope):
        """
        Sets the trust_scope of this App.
        Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param trust_scope: The trust_scope of this App.
        :type: str
        """
        allowed_values = ["Explicit", "Account", "Tags", "Default"]
        if not value_allowed_none_or_none_sentinel(trust_scope, allowed_values):
            trust_scope = 'UNKNOWN_ENUM_VALUE'
        self._trust_scope = trust_scope

    @property
    def is_database_service(self):
        """
        Gets the is_database_service of this App.
        If true, this application acts as database service Application

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - type: boolean


        :return: The is_database_service of this App.
        :rtype: bool
        """
        return self._is_database_service

    @is_database_service.setter
    def is_database_service(self, is_database_service):
        """
        Sets the is_database_service of this App.
        If true, this application acts as database service Application

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - type: boolean


        :param is_database_service: The is_database_service of this App.
        :type: bool
        """
        self._is_database_service = is_database_service

    @property
    def secondary_audiences(self):
        """
        Gets the secondary_audiences of this App.
        A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Deprecated Since: 18.2.6**

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The secondary_audiences of this App.
        :rtype: list[str]
        """
        return self._secondary_audiences

    @secondary_audiences.setter
    def secondary_audiences(self, secondary_audiences):
        """
        Sets the secondary_audiences of this App.
        A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Deprecated Since: 18.2.6**

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param secondary_audiences: The secondary_audiences of this App.
        :type: list[str]
        """
        self._secondary_audiences = secondary_audiences

    @property
    def is_enterprise_app(self):
        """
        Gets the is_enterprise_app of this App.
        If true, this app acts as Enterprise app with Authentication and URL Authz policy.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_enterprise_app of this App.
        :rtype: bool
        """
        return self._is_enterprise_app

    @is_enterprise_app.setter
    def is_enterprise_app(self, is_enterprise_app):
        """
        Sets the is_enterprise_app of this App.
        If true, this app acts as Enterprise app with Authentication and URL Authz policy.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_enterprise_app: The is_enterprise_app of this App.
        :type: bool
        """
        self._is_enterprise_app = is_enterprise_app

    @property
    def bypass_consent(self):
        """
        Gets the bypass_consent of this App.
        If true, indicates that consent should be skipped for all scopes

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The bypass_consent of this App.
        :rtype: bool
        """
        return self._bypass_consent

    @bypass_consent.setter
    def bypass_consent(self, bypass_consent):
        """
        Sets the bypass_consent of this App.
        If true, indicates that consent should be skipped for all scopes

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param bypass_consent: The bypass_consent of this App.
        :type: bool
        """
        self._bypass_consent = bypass_consent

    @property
    def disable_kmsi_token_authentication(self):
        """
        Gets the disable_kmsi_token_authentication of this App.
        Indicates whether the application is allowed to be access using kmsi token.

        **Added In:** 2111190457

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: always
         - type: boolean
         - uniqueness: none


        :return: The disable_kmsi_token_authentication of this App.
        :rtype: bool
        """
        return self._disable_kmsi_token_authentication

    @disable_kmsi_token_authentication.setter
    def disable_kmsi_token_authentication(self, disable_kmsi_token_authentication):
        """
        Sets the disable_kmsi_token_authentication of this App.
        Indicates whether the application is allowed to be access using kmsi token.

        **Added In:** 2111190457

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: always
         - type: boolean
         - uniqueness: none


        :param disable_kmsi_token_authentication: The disable_kmsi_token_authentication of this App.
        :type: bool
        """
        self._disable_kmsi_token_authentication = disable_kmsi_token_authentication

    @property
    def is_multicloud_service_app(self):
        """
        Gets the is_multicloud_service_app of this App.
        If true, indicates the app is used for multicloud service integration.

        **Added In:** 2301202328

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_multicloud_service_app of this App.
        :rtype: bool
        """
        return self._is_multicloud_service_app

    @is_multicloud_service_app.setter
    def is_multicloud_service_app(self, is_multicloud_service_app):
        """
        Sets the is_multicloud_service_app of this App.
        If true, indicates the app is used for multicloud service integration.

        **Added In:** 2301202328

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_multicloud_service_app: The is_multicloud_service_app of this App.
        :type: bool
        """
        self._is_multicloud_service_app = is_multicloud_service_app

    @property
    def radius_policy(self):
        """
        Gets the radius_policy of this App.

        :return: The radius_policy of this App.
        :rtype: oci.identity_domains.models.AppRadiusPolicy
        """
        return self._radius_policy

    @radius_policy.setter
    def radius_policy(self, radius_policy):
        """
        Sets the radius_policy of this App.

        :param radius_policy: The radius_policy of this App.
        :type: oci.identity_domains.models.AppRadiusPolicy
        """
        self._radius_policy = radius_policy

    @property
    def apps_network_perimeters(self):
        """
        Gets the apps_network_perimeters of this App.
        Network Perimeter

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The apps_network_perimeters of this App.
        :rtype: list[oci.identity_domains.models.AppAppsNetworkPerimeters]
        """
        return self._apps_network_perimeters

    @apps_network_perimeters.setter
    def apps_network_perimeters(self, apps_network_perimeters):
        """
        Sets the apps_network_perimeters of this App.
        Network Perimeter

        **Added In:** 2010242156

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param apps_network_perimeters: The apps_network_perimeters of this App.
        :type: list[oci.identity_domains.models.AppAppsNetworkPerimeters]
        """
        self._apps_network_perimeters = apps_network_perimeters

    @property
    def cloud_control_properties(self):
        """
        Gets the cloud_control_properties of this App.
        A collection of arbitrary properties that scope the privileges of a cloud-control App.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The cloud_control_properties of this App.
        :rtype: list[oci.identity_domains.models.AppCloudControlProperties]
        """
        return self._cloud_control_properties

    @cloud_control_properties.setter
    def cloud_control_properties(self, cloud_control_properties):
        """
        Sets the cloud_control_properties of this App.
        A collection of arbitrary properties that scope the privileges of a cloud-control App.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param cloud_control_properties: The cloud_control_properties of this App.
        :type: list[oci.identity_domains.models.AppCloudControlProperties]
        """
        self._cloud_control_properties = cloud_control_properties

    @property
    def editable_attributes(self):
        """
        Gets the editable_attributes of this App.
        App attributes editable by subject

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The editable_attributes of this App.
        :rtype: list[oci.identity_domains.models.AppEditableAttributes]
        """
        return self._editable_attributes

    @editable_attributes.setter
    def editable_attributes(self, editable_attributes):
        """
        Sets the editable_attributes of this App.
        App attributes editable by subject

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param editable_attributes: The editable_attributes of this App.
        :type: list[oci.identity_domains.models.AppEditableAttributes]
        """
        self._editable_attributes = editable_attributes

    @property
    def terms_of_use(self):
        """
        Gets the terms_of_use of this App.

        :return: The terms_of_use of this App.
        :rtype: oci.identity_domains.models.AppTermsOfUse
        """
        return self._terms_of_use

    @terms_of_use.setter
    def terms_of_use(self, terms_of_use):
        """
        Sets the terms_of_use of this App.

        :param terms_of_use: The terms_of_use of this App.
        :type: oci.identity_domains.models.AppTermsOfUse
        """
        self._terms_of_use = terms_of_use

    @property
    def protectable_secondary_audiences(self):
        """
        Gets the protectable_secondary_audiences of this App.
        A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The protectable_secondary_audiences of this App.
        :rtype: list[oci.identity_domains.models.AppProtectableSecondaryAudiences]
        """
        return self._protectable_secondary_audiences

    @protectable_secondary_audiences.setter
    def protectable_secondary_audiences(self, protectable_secondary_audiences):
        """
        Sets the protectable_secondary_audiences of this App.
        A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param protectable_secondary_audiences: The protectable_secondary_audiences of this App.
        :type: list[oci.identity_domains.models.AppProtectableSecondaryAudiences]
        """
        self._protectable_secondary_audiences = protectable_secondary_audiences

    @property
    def idp_policy(self):
        """
        Gets the idp_policy of this App.

        :return: The idp_policy of this App.
        :rtype: oci.identity_domains.models.AppIdpPolicy
        """
        return self._idp_policy

    @idp_policy.setter
    def idp_policy(self, idp_policy):
        """
        Sets the idp_policy of this App.

        :param idp_policy: The idp_policy of this App.
        :type: oci.identity_domains.models.AppIdpPolicy
        """
        self._idp_policy = idp_policy

    @property
    def allowed_tags(self):
        """
        Gets the allowed_tags of this App.
        A list of tags, acting as an OAuthClient, this App is allowed to access.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The allowed_tags of this App.
        :rtype: list[oci.identity_domains.models.AppAllowedTags]
        """
        return self._allowed_tags

    @allowed_tags.setter
    def allowed_tags(self, allowed_tags):
        """
        Sets the allowed_tags of this App.
        A list of tags, acting as an OAuthClient, this App is allowed to access.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param allowed_tags: The allowed_tags of this App.
        :type: list[oci.identity_domains.models.AppAllowedTags]
        """
        self._allowed_tags = allowed_tags

    @property
    def app_signon_policy(self):
        """
        Gets the app_signon_policy of this App.

        :return: The app_signon_policy of this App.
        :rtype: oci.identity_domains.models.AppAppSignonPolicy
        """
        return self._app_signon_policy

    @app_signon_policy.setter
    def app_signon_policy(self, app_signon_policy):
        """
        Sets the app_signon_policy of this App.

        :param app_signon_policy: The app_signon_policy of this App.
        :type: oci.identity_domains.models.AppAppSignonPolicy
        """
        self._app_signon_policy = app_signon_policy

    @property
    def trust_policies(self):
        """
        Gets the trust_policies of this App.
        Trust Policies.

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The trust_policies of this App.
        :rtype: list[oci.identity_domains.models.AppTrustPolicies]
        """
        return self._trust_policies

    @trust_policies.setter
    def trust_policies(self, trust_policies):
        """
        Sets the trust_policies of this App.
        Trust Policies.

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param trust_policies: The trust_policies of this App.
        :type: list[oci.identity_domains.models.AppTrustPolicies]
        """
        self._trust_policies = trust_policies

    @property
    def signon_policy(self):
        """
        Gets the signon_policy of this App.

        :return: The signon_policy of this App.
        :rtype: oci.identity_domains.models.AppSignonPolicy
        """
        return self._signon_policy

    @signon_policy.setter
    def signon_policy(self, signon_policy):
        """
        Sets the signon_policy of this App.

        :param signon_policy: The signon_policy of this App.
        :type: oci.identity_domains.models.AppSignonPolicy
        """
        self._signon_policy = signon_policy

    @property
    def identity_providers(self):
        """
        Gets the identity_providers of this App.
        A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex


        :return: The identity_providers of this App.
        :rtype: list[oci.identity_domains.models.AppIdentityProviders]
        """
        return self._identity_providers

    @identity_providers.setter
    def identity_providers(self, identity_providers):
        """
        Sets the identity_providers of this App.
        A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex


        :param identity_providers: The identity_providers of this App.
        :type: list[oci.identity_domains.models.AppIdentityProviders]
        """
        self._identity_providers = identity_providers

    @property
    def accounts(self):
        """
        Gets the accounts of this App.
        Accounts of App

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The accounts of this App.
        :rtype: list[oci.identity_domains.models.AppAccounts]
        """
        return self._accounts

    @accounts.setter
    def accounts(self, accounts):
        """
        Sets the accounts of this App.
        Accounts of App

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param accounts: The accounts of this App.
        :type: list[oci.identity_domains.models.AppAccounts]
        """
        self._accounts = accounts

    @property
    def grants(self):
        """
        Gets the grants of this App.
        Grants assigned to the app

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The grants of this App.
        :rtype: list[oci.identity_domains.models.AppGrants]
        """
        return self._grants

    @grants.setter
    def grants(self, grants):
        """
        Sets the grants of this App.
        Grants assigned to the app

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param grants: The grants of this App.
        :type: list[oci.identity_domains.models.AppGrants]
        """
        self._grants = grants

    @property
    def service_params(self):
        """
        Gets the service_params of this App.
        Custom attribute that is required to compute other attribute values during app creation.

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: always
         - type: complex
         - uniqueness: none


        :return: The service_params of this App.
        :rtype: list[oci.identity_domains.models.AppServiceParams]
        """
        return self._service_params

    @service_params.setter
    def service_params(self, service_params):
        """
        Sets the service_params of this App.
        Custom attribute that is required to compute other attribute values during app creation.

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: always
         - type: complex
         - uniqueness: none


        :param service_params: The service_params of this App.
        :type: list[oci.identity_domains.models.AppServiceParams]
        """
        self._service_params = service_params

    @property
    def attr_rendering_metadata(self):
        """
        Gets the attr_rendering_metadata of this App.
        Label for the attribute to be shown in the UI.

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - multiValued: true
         - mutability: immutable
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The attr_rendering_metadata of this App.
        :rtype: list[oci.identity_domains.models.AppAttrRenderingMetadata]
        """
        return self._attr_rendering_metadata

    @attr_rendering_metadata.setter
    def attr_rendering_metadata(self, attr_rendering_metadata):
        """
        Sets the attr_rendering_metadata of this App.
        Label for the attribute to be shown in the UI.

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - multiValued: true
         - mutability: immutable
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param attr_rendering_metadata: The attr_rendering_metadata of this App.
        :type: list[oci.identity_domains.models.AppAttrRenderingMetadata]
        """
        self._attr_rendering_metadata = attr_rendering_metadata

    @property
    def based_on_template(self):
        """
        **[Required]** Gets the based_on_template of this App.

        :return: The based_on_template of this App.
        :rtype: oci.identity_domains.models.AppBasedOnTemplate
        """
        return self._based_on_template

    @based_on_template.setter
    def based_on_template(self, based_on_template):
        """
        Sets the based_on_template of this App.

        :param based_on_template: The based_on_template of this App.
        :type: oci.identity_domains.models.AppBasedOnTemplate
        """
        self._based_on_template = based_on_template

    @property
    def granted_app_roles(self):
        """
        Gets the granted_app_roles of this App.
        A list of AppRoles that are granted to this App (and that are defined by other Apps). Within the Oracle Public Cloud infrastructure, this allows AppID-based association. Such an association allows this App to act as a consumer and thus to access resources of another App that acts as a producer.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The granted_app_roles of this App.
        :rtype: list[oci.identity_domains.models.AppGrantedAppRoles]
        """
        return self._granted_app_roles

    @granted_app_roles.setter
    def granted_app_roles(self, granted_app_roles):
        """
        Sets the granted_app_roles of this App.
        A list of AppRoles that are granted to this App (and that are defined by other Apps). Within the Oracle Public Cloud infrastructure, this allows AppID-based association. Such an association allows this App to act as a consumer and thus to access resources of another App that acts as a producer.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param granted_app_roles: The granted_app_roles of this App.
        :type: list[oci.identity_domains.models.AppGrantedAppRoles]
        """
        self._granted_app_roles = granted_app_roles

    @property
    def saml_service_provider(self):
        """
        Gets the saml_service_provider of this App.

        :return: The saml_service_provider of this App.
        :rtype: oci.identity_domains.models.AppSamlServiceProvider
        """
        return self._saml_service_provider

    @saml_service_provider.setter
    def saml_service_provider(self, saml_service_provider):
        """
        Sets the saml_service_provider of this App.

        :param saml_service_provider: The saml_service_provider of this App.
        :type: oci.identity_domains.models.AppSamlServiceProvider
        """
        self._saml_service_provider = saml_service_provider

    @property
    def allowed_scopes(self):
        """
        Gets the allowed_scopes of this App.
        A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [fqs]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The allowed_scopes of this App.
        :rtype: list[oci.identity_domains.models.AppAllowedScopes]
        """
        return self._allowed_scopes

    @allowed_scopes.setter
    def allowed_scopes(self, allowed_scopes):
        """
        Sets the allowed_scopes of this App.
        A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [fqs]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param allowed_scopes: The allowed_scopes of this App.
        :type: list[oci.identity_domains.models.AppAllowedScopes]
        """
        self._allowed_scopes = allowed_scopes

    @property
    def certificates(self):
        """
        Gets the certificates of this App.
        Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [certAlias]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The certificates of this App.
        :rtype: list[oci.identity_domains.models.AppCertificates]
        """
        return self._certificates

    @certificates.setter
    def certificates(self, certificates):
        """
        Sets the certificates of this App.
        Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [certAlias]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param certificates: The certificates of this App.
        :type: list[oci.identity_domains.models.AppCertificates]
        """
        self._certificates = certificates

    @property
    def alias_apps(self):
        """
        Gets the alias_apps of this App.
        Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The alias_apps of this App.
        :rtype: list[oci.identity_domains.models.AppAliasApps]
        """
        return self._alias_apps

    @alias_apps.setter
    def alias_apps(self, alias_apps):
        """
        Sets the alias_apps of this App.
        Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param alias_apps: The alias_apps of this App.
        :type: list[oci.identity_domains.models.AppAliasApps]
        """
        self._alias_apps = alias_apps

    @property
    def as_opc_service(self):
        """
        Gets the as_opc_service of this App.

        :return: The as_opc_service of this App.
        :rtype: oci.identity_domains.models.AppAsOPCService
        """
        return self._as_opc_service

    @as_opc_service.setter
    def as_opc_service(self, as_opc_service):
        """
        Sets the as_opc_service of this App.

        :param as_opc_service: The as_opc_service of this App.
        :type: oci.identity_domains.models.AppAsOPCService
        """
        self._as_opc_service = as_opc_service

    @property
    def admin_roles(self):
        """
        Gets the admin_roles of this App.
        A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers administrative privilege within this App.

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex


        :return: The admin_roles of this App.
        :rtype: list[oci.identity_domains.models.AppAdminRoles]
        """
        return self._admin_roles

    @admin_roles.setter
    def admin_roles(self, admin_roles):
        """
        Sets the admin_roles of this App.
        A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers administrative privilege within this App.

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex


        :param admin_roles: The admin_roles of this App.
        :type: list[oci.identity_domains.models.AppAdminRoles]
        """
        self._admin_roles = admin_roles

    @property
    def user_roles(self):
        """
        Gets the user_roles of this App.
        A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers end-user privilege within this App.

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex


        :return: The user_roles of this App.
        :rtype: list[oci.identity_domains.models.AppUserRoles]
        """
        return self._user_roles

    @user_roles.setter
    def user_roles(self, user_roles):
        """
        Sets the user_roles of this App.
        A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers end-user privilege within this App.

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: complex


        :param user_roles: The user_roles of this App.
        :type: list[oci.identity_domains.models.AppUserRoles]
        """
        self._user_roles = user_roles

    @property
    def scopes(self):
        """
        Gets the scopes of this App.
        Scopes defined by this App. Used when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The scopes of this App.
        :rtype: list[oci.identity_domains.models.AppScopes]
        """
        return self._scopes

    @scopes.setter
    def scopes(self, scopes):
        """
        Sets the scopes of this App.
        Scopes defined by this App. Used when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param scopes: The scopes of this App.
        :type: list[oci.identity_domains.models.AppScopes]
        """
        self._scopes = scopes

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionRadiusAppApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app of this App.
        :type: oci.identity_domains.models.AppExtensionRadiusAppApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_radius_app_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionSamlServiceProviderApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app of this App.
        :type: oci.identity_domains.models.AppExtensionSamlServiceProviderApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_saml_service_provider_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionWebTierPolicyApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app of this App.
        :type: oci.identity_domains.models.AppExtensionWebTierPolicyApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_web_tier_policy_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionManagedappApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app of this App.
        :type: oci.identity_domains.models.AppExtensionManagedappApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_managedapp_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template of this App.
        :rtype: oci.identity_domains.models.AppExtensionFormFillAppTemplateAppTemplate
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template: The urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template of this App.
        :type: oci.identity_domains.models.AppExtensionFormFillAppTemplateAppTemplate
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template = urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_template_app_template

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionOpcServiceApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app of this App.
        :type: oci.identity_domains.models.AppExtensionOpcServiceApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_opc_service_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionKerberosRealmApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app of this App.
        :type: oci.identity_domains.models.AppExtensionKerberosRealmApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_kerberos_realm_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionRequestableApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app of this App.
        :type: oci.identity_domains.models.AppExtensionRequestableApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_requestable_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionFormFillAppApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app of this App.
        :type: oci.identity_domains.models.AppExtensionFormFillAppApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_form_fill_app_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionDbcsApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app of this App.
        :type: oci.identity_domains.models.AppExtensionDbcsApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_dbcs_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionEnterpriseAppApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app of this App.
        :type: oci.identity_domains.models.AppExtensionEnterpriseAppApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_enterprise_app_app

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags of this App.
        :rtype: oci.identity_domains.models.ExtensionOCITags
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags: The urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags of this App.
        :type: oci.identity_domains.models.ExtensionOCITags
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags = urn_ietf_params_scim_schemas_oracle_idcs_extension_oci_tags

    @property
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app(self):
        """
        Gets the urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app of this App.

        :return: The urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app of this App.
        :rtype: oci.identity_domains.models.AppExtensionMulticloudServiceAppApp
        """
        return self._urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app

    @urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app.setter
    def urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app(self, urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app):
        """
        Sets the urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app of this App.

        :param urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app: The urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app of this App.
        :type: oci.identity_domains.models.AppExtensionMulticloudServiceAppApp
        """
        self._urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app = urn_ietf_params_scim_schemas_oracle_idcs_extension_multicloud_service_app_app

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
