# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudGateExtUpstreamServers(object):
    """
    A list of upstream servers
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudGateExtUpstreamServers object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this CloudGateExtUpstreamServers.
        :type value: str

        :param ref:
            The value to assign to the ref property of this CloudGateExtUpstreamServers.
        :type ref: str

        :param host_name:
            The value to assign to the host_name property of this CloudGateExtUpstreamServers.
        :type host_name: str

        :param port:
            The value to assign to the port property of this CloudGateExtUpstreamServers.
        :type port: int

        :param nginx_settings:
            The value to assign to the nginx_settings property of this CloudGateExtUpstreamServers.
        :type nginx_settings: str

        :param group_id:
            The value to assign to the group_id property of this CloudGateExtUpstreamServers.
        :type group_id: str

        :param display_name:
            The value to assign to the display_name property of this CloudGateExtUpstreamServers.
        :type display_name: str

        """
        self.swagger_types = {
            'value': 'str',
            'ref': 'str',
            'host_name': 'str',
            'port': 'int',
            'nginx_settings': 'str',
            'group_id': 'str',
            'display_name': 'str'
        }
        self.attribute_map = {
            'value': 'value',
            'ref': '$ref',
            'host_name': 'hostName',
            'port': 'port',
            'nginx_settings': 'nginxSettings',
            'group_id': 'groupId',
            'display_name': 'displayName'
        }
        self._value = None
        self._ref = None
        self._host_name = None
        self._port = None
        self._nginx_settings = None
        self._group_id = None
        self._display_name = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this CloudGateExtUpstreamServers.
        ID of the upstream server

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this CloudGateExtUpstreamServers.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this CloudGateExtUpstreamServers.
        ID of the upstream server

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this CloudGateExtUpstreamServers.
        :type: str
        """
        self._value = value

    @property
    def ref(self):
        """
        Gets the ref of this CloudGateExtUpstreamServers.
        URI of the upstream server

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :return: The ref of this CloudGateExtUpstreamServers.
        :rtype: str
        """
        return self._ref

    @ref.setter
    def ref(self, ref):
        """
        Sets the ref of this CloudGateExtUpstreamServers.
        URI of the upstream server

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :param ref: The ref of this CloudGateExtUpstreamServers.
        :type: str
        """
        self._ref = ref

    @property
    def host_name(self):
        """
        Gets the host_name of this CloudGateExtUpstreamServers.
        Any incoming request to cloud gate is finally sent to this host, if selected during load balancing

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The host_name of this CloudGateExtUpstreamServers.
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """
        Sets the host_name of this CloudGateExtUpstreamServers.
        Any incoming request to cloud gate is finally sent to this host, if selected during load balancing

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param host_name: The host_name of this CloudGateExtUpstreamServers.
        :type: str
        """
        self._host_name = host_name

    @property
    def port(self):
        """
        Gets the port of this CloudGateExtUpstreamServers.
        Port for the Upstream Server

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The port of this CloudGateExtUpstreamServers.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this CloudGateExtUpstreamServers.
        Port for the Upstream Server

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param port: The port of this CloudGateExtUpstreamServers.
        :type: int
        """
        self._port = port

    @property
    def nginx_settings(self):
        """
        Gets the nginx_settings of this CloudGateExtUpstreamServers.
        Any additional settings for this upstream server in nginx configuration form

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The nginx_settings of this CloudGateExtUpstreamServers.
        :rtype: str
        """
        return self._nginx_settings

    @nginx_settings.setter
    def nginx_settings(self, nginx_settings):
        """
        Sets the nginx_settings of this CloudGateExtUpstreamServers.
        Any additional settings for this upstream server in nginx configuration form

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param nginx_settings: The nginx_settings of this CloudGateExtUpstreamServers.
        :type: str
        """
        self._nginx_settings = nginx_settings

    @property
    def group_id(self):
        """
        Gets the group_id of this CloudGateExtUpstreamServers.
        Upstream Server Group instance for the upstream server. This is one of the upstreamServerGroup IDs(upstream blocks) from the associated Cloud Gate list

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The group_id of this CloudGateExtUpstreamServers.
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """
        Sets the group_id of this CloudGateExtUpstreamServers.
        Upstream Server Group instance for the upstream server. This is one of the upstreamServerGroup IDs(upstream blocks) from the associated Cloud Gate list

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param group_id: The group_id of this CloudGateExtUpstreamServers.
        :type: str
        """
        self._group_id = group_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CloudGateExtUpstreamServers.
        Display name of upstream server

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The display_name of this CloudGateExtUpstreamServers.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CloudGateExtUpstreamServers.
        Display name of upstream server

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param display_name: The display_name of this CloudGateExtUpstreamServers.
        :type: str
        """
        self._display_name = display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
