# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenerateAgentInstallerConfigurationDetails(object):
    """
    Attributes to generate agent installer parameters for a fleet.
    """

    #: A constant which can be used with the agent_type property of a GenerateAgentInstallerConfigurationDetails.
    #: This constant has a value of "OMA"
    AGENT_TYPE_OMA = "OMA"

    #: A constant which can be used with the agent_type property of a GenerateAgentInstallerConfigurationDetails.
    #: This constant has a value of "OCA"
    AGENT_TYPE_OCA = "OCA"

    #: A constant which can be used with the agent_type property of a GenerateAgentInstallerConfigurationDetails.
    #: This constant has a value of "OCMA"
    AGENT_TYPE_OCMA = "OCMA"

    def __init__(self, **kwargs):
        """
        Initializes a new GenerateAgentInstallerConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param install_key_id:
            The value to assign to the install_key_id property of this GenerateAgentInstallerConfigurationDetails.
        :type install_key_id: str

        :param fleet_id:
            The value to assign to the fleet_id property of this GenerateAgentInstallerConfigurationDetails.
        :type fleet_id: str

        :param agent_type:
            The value to assign to the agent_type property of this GenerateAgentInstallerConfigurationDetails.
            Allowed values for this property are: "OMA", "OCA", "OCMA"
        :type agent_type: str

        """
        self.swagger_types = {
            'install_key_id': 'str',
            'fleet_id': 'str',
            'agent_type': 'str'
        }
        self.attribute_map = {
            'install_key_id': 'installKeyId',
            'fleet_id': 'fleetId',
            'agent_type': 'agentType'
        }
        self._install_key_id = None
        self._fleet_id = None
        self._agent_type = None

    @property
    def install_key_id(self):
        """
        **[Required]** Gets the install_key_id of this GenerateAgentInstallerConfigurationDetails.
        The `OCID`__ of the management agent install key for which to generate the configuration file.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The install_key_id of this GenerateAgentInstallerConfigurationDetails.
        :rtype: str
        """
        return self._install_key_id

    @install_key_id.setter
    def install_key_id(self, install_key_id):
        """
        Sets the install_key_id of this GenerateAgentInstallerConfigurationDetails.
        The `OCID`__ of the management agent install key for which to generate the configuration file.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param install_key_id: The install_key_id of this GenerateAgentInstallerConfigurationDetails.
        :type: str
        """
        self._install_key_id = install_key_id

    @property
    def fleet_id(self):
        """
        **[Required]** Gets the fleet_id of this GenerateAgentInstallerConfigurationDetails.
        The `OCID`__ of the fleet for which to generate the configuration file.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The fleet_id of this GenerateAgentInstallerConfigurationDetails.
        :rtype: str
        """
        return self._fleet_id

    @fleet_id.setter
    def fleet_id(self, fleet_id):
        """
        Sets the fleet_id of this GenerateAgentInstallerConfigurationDetails.
        The `OCID`__ of the fleet for which to generate the configuration file.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param fleet_id: The fleet_id of this GenerateAgentInstallerConfigurationDetails.
        :type: str
        """
        self._fleet_id = fleet_id

    @property
    def agent_type(self):
        """
        Gets the agent_type of this GenerateAgentInstallerConfigurationDetails.
        The JMS plugin type.

        Allowed values for this property are: "OMA", "OCA", "OCMA"


        :return: The agent_type of this GenerateAgentInstallerConfigurationDetails.
        :rtype: str
        """
        return self._agent_type

    @agent_type.setter
    def agent_type(self, agent_type):
        """
        Sets the agent_type of this GenerateAgentInstallerConfigurationDetails.
        The JMS plugin type.


        :param agent_type: The agent_type of this GenerateAgentInstallerConfigurationDetails.
        :type: str
        """
        allowed_values = ["OMA", "OCA", "OCMA"]
        if not value_allowed_none_or_none_sentinel(agent_type, allowed_values):
            raise ValueError(
                f"Invalid value for `agent_type`, must be None or one of {allowed_values}"
            )
        self._agent_type = agent_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
