# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RequestDeployedApplicationMigrationAnalysesDetails(object):
    """
    Details of the request to start a Java migration analyses. The analyses requires the managed instance OCID, deployed application key,
    source JDK version, and target JDK version of each selected application.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RequestDeployedApplicationMigrationAnalysesDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param targets:
            The value to assign to the targets property of this RequestDeployedApplicationMigrationAnalysesDetails.
        :type targets: list[oci.jms.models.DeployedApplicationMigrationAnalysesTarget]

        """
        self.swagger_types = {
            'targets': 'list[DeployedApplicationMigrationAnalysesTarget]'
        }
        self.attribute_map = {
            'targets': 'targets'
        }
        self._targets = None

    @property
    def targets(self):
        """
        **[Required]** Gets the targets of this RequestDeployedApplicationMigrationAnalysesDetails.
        An array of migration analyses requests.


        :return: The targets of this RequestDeployedApplicationMigrationAnalysesDetails.
        :rtype: list[oci.jms.models.DeployedApplicationMigrationAnalysesTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this RequestDeployedApplicationMigrationAnalysesDetails.
        An array of migration analyses requests.


        :param targets: The targets of this RequestDeployedApplicationMigrationAnalysesDetails.
        :type: list[oci.jms.models.DeployedApplicationMigrationAnalysesTarget]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
