# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20170115

from .rule import Rule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IpBasedMaxConnectionsRule(Rule):
    """
    An object that represents the action of configuring an IP max connection rule which specifies
    how many connections IPs can make to a listener.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IpBasedMaxConnectionsRule object with values from keyword arguments. The default value of the :py:attr:`~oci.load_balancer.models.IpBasedMaxConnectionsRule.action` attribute
        of this class is ``IP_BASED_MAX_CONNECTIONS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action:
            The value to assign to the action property of this IpBasedMaxConnectionsRule.
            Allowed values for this property are: "ADD_HTTP_REQUEST_HEADER", "EXTEND_HTTP_REQUEST_HEADER_VALUE", "REMOVE_HTTP_REQUEST_HEADER", "ADD_HTTP_RESPONSE_HEADER", "EXTEND_HTTP_RESPONSE_HEADER_VALUE", "REMOVE_HTTP_RESPONSE_HEADER", "ALLOW", "CONTROL_ACCESS_USING_HTTP_METHODS", "REDIRECT", "HTTP_HEADER", "IP_BASED_MAX_CONNECTIONS"
        :type action: str

        :param default_max_connections:
            The value to assign to the default_max_connections property of this IpBasedMaxConnectionsRule.
        :type default_max_connections: int

        :param ip_max_connections:
            The value to assign to the ip_max_connections property of this IpBasedMaxConnectionsRule.
        :type ip_max_connections: list[oci.load_balancer.models.IpMaxConnections]

        """
        self.swagger_types = {
            'action': 'str',
            'default_max_connections': 'int',
            'ip_max_connections': 'list[IpMaxConnections]'
        }
        self.attribute_map = {
            'action': 'action',
            'default_max_connections': 'defaultMaxConnections',
            'ip_max_connections': 'ipMaxConnections'
        }
        self._action = None
        self._default_max_connections = None
        self._ip_max_connections = None
        self._action = 'IP_BASED_MAX_CONNECTIONS'

    @property
    def default_max_connections(self):
        """
        Gets the default_max_connections of this IpBasedMaxConnectionsRule.
        The maximum number of connections that the any IP can make to a listener unless the IP is mentioned
        in maxConnections. If no defaultMaxConnections is specified the default is unlimited.


        :return: The default_max_connections of this IpBasedMaxConnectionsRule.
        :rtype: int
        """
        return self._default_max_connections

    @default_max_connections.setter
    def default_max_connections(self, default_max_connections):
        """
        Sets the default_max_connections of this IpBasedMaxConnectionsRule.
        The maximum number of connections that the any IP can make to a listener unless the IP is mentioned
        in maxConnections. If no defaultMaxConnections is specified the default is unlimited.


        :param default_max_connections: The default_max_connections of this IpBasedMaxConnectionsRule.
        :type: int
        """
        self._default_max_connections = default_max_connections

    @property
    def ip_max_connections(self):
        """
        Gets the ip_max_connections of this IpBasedMaxConnectionsRule.
        An array of IPs that have a maxConnection setting different than the default and what
        that maxConnection setting is


        :return: The ip_max_connections of this IpBasedMaxConnectionsRule.
        :rtype: list[oci.load_balancer.models.IpMaxConnections]
        """
        return self._ip_max_connections

    @ip_max_connections.setter
    def ip_max_connections(self, ip_max_connections):
        """
        Sets the ip_max_connections of this IpBasedMaxConnectionsRule.
        An array of IPs that have a maxConnection setting different than the default and what
        that maxConnection setting is


        :param ip_max_connections: The ip_max_connections of this IpBasedMaxConnectionsRule.
        :type: list[oci.load_balancer.models.IpMaxConnections]
        """
        self._ip_max_connections = ip_max_connections

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
