# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointCredentials(object):
    """
    An object containing credential details to authenticate/authorize a REST request.
    """

    #: A constant which can be used with the credential_type property of a EndpointCredentials.
    #: This constant has a value of "NONE"
    CREDENTIAL_TYPE_NONE = "NONE"

    #: A constant which can be used with the credential_type property of a EndpointCredentials.
    #: This constant has a value of "BASIC_AUTH"
    CREDENTIAL_TYPE_BASIC_AUTH = "BASIC_AUTH"

    #: A constant which can be used with the credential_type property of a EndpointCredentials.
    #: This constant has a value of "STATIC_TOKEN"
    CREDENTIAL_TYPE_STATIC_TOKEN = "STATIC_TOKEN"

    #: A constant which can be used with the credential_type property of a EndpointCredentials.
    #: This constant has a value of "DYNAMIC_TOKEN"
    CREDENTIAL_TYPE_DYNAMIC_TOKEN = "DYNAMIC_TOKEN"

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointCredentials object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_type:
            The value to assign to the credential_type property of this EndpointCredentials.
            Allowed values for this property are: "NONE", "BASIC_AUTH", "STATIC_TOKEN", "DYNAMIC_TOKEN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type credential_type: str

        :param credential_name:
            The value to assign to the credential_name property of this EndpointCredentials.
        :type credential_name: str

        :param credential_endpoint:
            The value to assign to the credential_endpoint property of this EndpointCredentials.
        :type credential_endpoint: oci.log_analytics.models.CredentialEndpoint

        """
        self.swagger_types = {
            'credential_type': 'str',
            'credential_name': 'str',
            'credential_endpoint': 'CredentialEndpoint'
        }
        self.attribute_map = {
            'credential_type': 'credentialType',
            'credential_name': 'credentialName',
            'credential_endpoint': 'credentialEndpoint'
        }
        self._credential_type = None
        self._credential_name = None
        self._credential_endpoint = None

    @property
    def credential_type(self):
        """
        Gets the credential_type of this EndpointCredentials.
        The credential type. NONE indicates credentials are not needed to access the endpoint.
        BASIC_AUTH represents a username and password based model. TOKEN could be static or dynamic.
        In case of dynamic tokens, also specify the endpoint from which the token must be fetched.

        Allowed values for this property are: "NONE", "BASIC_AUTH", "STATIC_TOKEN", "DYNAMIC_TOKEN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The credential_type of this EndpointCredentials.
        :rtype: str
        """
        return self._credential_type

    @credential_type.setter
    def credential_type(self, credential_type):
        """
        Sets the credential_type of this EndpointCredentials.
        The credential type. NONE indicates credentials are not needed to access the endpoint.
        BASIC_AUTH represents a username and password based model. TOKEN could be static or dynamic.
        In case of dynamic tokens, also specify the endpoint from which the token must be fetched.


        :param credential_type: The credential_type of this EndpointCredentials.
        :type: str
        """
        allowed_values = ["NONE", "BASIC_AUTH", "STATIC_TOKEN", "DYNAMIC_TOKEN"]
        if not value_allowed_none_or_none_sentinel(credential_type, allowed_values):
            credential_type = 'UNKNOWN_ENUM_VALUE'
        self._credential_type = credential_type

    @property
    def credential_name(self):
        """
        Gets the credential_name of this EndpointCredentials.
        The named credential name on the management agent.


        :return: The credential_name of this EndpointCredentials.
        :rtype: str
        """
        return self._credential_name

    @credential_name.setter
    def credential_name(self, credential_name):
        """
        Sets the credential_name of this EndpointCredentials.
        The named credential name on the management agent.


        :param credential_name: The credential_name of this EndpointCredentials.
        :type: str
        """
        self._credential_name = credential_name

    @property
    def credential_endpoint(self):
        """
        Gets the credential_endpoint of this EndpointCredentials.

        :return: The credential_endpoint of this EndpointCredentials.
        :rtype: oci.log_analytics.models.CredentialEndpoint
        """
        return self._credential_endpoint

    @credential_endpoint.setter
    def credential_endpoint(self, credential_endpoint):
        """
        Sets the credential_endpoint of this EndpointCredentials.

        :param credential_endpoint: The credential_endpoint of this EndpointCredentials.
        :type: oci.log_analytics.models.CredentialEndpoint
        """
        self._credential_endpoint = credential_endpoint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
