# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NamedCaptureValue(object):
    """
    Named capture value.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NamedCaptureValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sub_sequence:
            The value to assign to the sub_sequence property of this NamedCaptureValue.
        :type sub_sequence: str

        :param sub_sequence_start_index:
            The value to assign to the sub_sequence_start_index property of this NamedCaptureValue.
        :type sub_sequence_start_index: int

        :param sub_sequence_end_index:
            The value to assign to the sub_sequence_end_index property of this NamedCaptureValue.
        :type sub_sequence_end_index: int

        """
        self.swagger_types = {
            'sub_sequence': 'str',
            'sub_sequence_start_index': 'int',
            'sub_sequence_end_index': 'int'
        }
        self.attribute_map = {
            'sub_sequence': 'subSequence',
            'sub_sequence_start_index': 'subSequenceStartIndex',
            'sub_sequence_end_index': 'subSequenceEndIndex'
        }
        self._sub_sequence = None
        self._sub_sequence_start_index = None
        self._sub_sequence_end_index = None

    @property
    def sub_sequence(self):
        """
        Gets the sub_sequence of this NamedCaptureValue.
        The subSequence.


        :return: The sub_sequence of this NamedCaptureValue.
        :rtype: str
        """
        return self._sub_sequence

    @sub_sequence.setter
    def sub_sequence(self, sub_sequence):
        """
        Sets the sub_sequence of this NamedCaptureValue.
        The subSequence.


        :param sub_sequence: The sub_sequence of this NamedCaptureValue.
        :type: str
        """
        self._sub_sequence = sub_sequence

    @property
    def sub_sequence_start_index(self):
        """
        Gets the sub_sequence_start_index of this NamedCaptureValue.
        The subSequence start index.


        :return: The sub_sequence_start_index of this NamedCaptureValue.
        :rtype: int
        """
        return self._sub_sequence_start_index

    @sub_sequence_start_index.setter
    def sub_sequence_start_index(self, sub_sequence_start_index):
        """
        Sets the sub_sequence_start_index of this NamedCaptureValue.
        The subSequence start index.


        :param sub_sequence_start_index: The sub_sequence_start_index of this NamedCaptureValue.
        :type: int
        """
        self._sub_sequence_start_index = sub_sequence_start_index

    @property
    def sub_sequence_end_index(self):
        """
        Gets the sub_sequence_end_index of this NamedCaptureValue.
        The subSequence end index.


        :return: The sub_sequence_end_index of this NamedCaptureValue.
        :rtype: int
        """
        return self._sub_sequence_end_index

    @sub_sequence_end_index.setter
    def sub_sequence_end_index(self, sub_sequence_end_index):
        """
        Sets the sub_sequence_end_index of this NamedCaptureValue.
        The subSequence end index.


        :param sub_sequence_end_index: The sub_sequence_end_index of this NamedCaptureValue.
        :type: int
        """
        self._sub_sequence_end_index = sub_sequence_end_index

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
