# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BrokerShape(object):
    """
    Configuration of the broker node.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BrokerShape object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param node_count:
            The value to assign to the node_count property of this BrokerShape.
        :type node_count: int

        :param ocpu_count:
            The value to assign to the ocpu_count property of this BrokerShape.
        :type ocpu_count: int

        :param storage_size_in_gbs:
            The value to assign to the storage_size_in_gbs property of this BrokerShape.
        :type storage_size_in_gbs: int

        :param node_shape:
            The value to assign to the node_shape property of this BrokerShape.
        :type node_shape: str

        """
        self.swagger_types = {
            'node_count': 'int',
            'ocpu_count': 'int',
            'storage_size_in_gbs': 'int',
            'node_shape': 'str'
        }
        self.attribute_map = {
            'node_count': 'nodeCount',
            'ocpu_count': 'ocpuCount',
            'storage_size_in_gbs': 'storageSizeInGbs',
            'node_shape': 'nodeShape'
        }
        self._node_count = None
        self._ocpu_count = None
        self._storage_size_in_gbs = None
        self._node_shape = None

    @property
    def node_count(self):
        """
        **[Required]** Gets the node_count of this BrokerShape.
        Number of Kafka broker nodes


        :return: The node_count of this BrokerShape.
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """
        Sets the node_count of this BrokerShape.
        Number of Kafka broker nodes


        :param node_count: The node_count of this BrokerShape.
        :type: int
        """
        self._node_count = node_count

    @property
    def ocpu_count(self):
        """
        **[Required]** Gets the ocpu_count of this BrokerShape.
        Number of OCPUs per nodes


        :return: The ocpu_count of this BrokerShape.
        :rtype: int
        """
        return self._ocpu_count

    @ocpu_count.setter
    def ocpu_count(self, ocpu_count):
        """
        Sets the ocpu_count of this BrokerShape.
        Number of OCPUs per nodes


        :param ocpu_count: The ocpu_count of this BrokerShape.
        :type: int
        """
        self._ocpu_count = ocpu_count

    @property
    def storage_size_in_gbs(self):
        """
        Gets the storage_size_in_gbs of this BrokerShape.
        Size of the storage per nodes.


        :return: The storage_size_in_gbs of this BrokerShape.
        :rtype: int
        """
        return self._storage_size_in_gbs

    @storage_size_in_gbs.setter
    def storage_size_in_gbs(self, storage_size_in_gbs):
        """
        Sets the storage_size_in_gbs of this BrokerShape.
        Size of the storage per nodes.


        :param storage_size_in_gbs: The storage_size_in_gbs of this BrokerShape.
        :type: int
        """
        self._storage_size_in_gbs = storage_size_in_gbs

    @property
    def node_shape(self):
        """
        Gets the node_shape of this BrokerShape.
        Node shape for broker is passed as part of cluster creation, similar to VM.Standard.A1.Flex


        :return: The node_shape of this BrokerShape.
        :rtype: str
        """
        return self._node_shape

    @node_shape.setter
    def node_shape(self, node_shape):
        """
        Sets the node_shape of this BrokerShape.
        Node shape for broker is passed as part of cluster creation, similar to VM.Standard.A1.Flex


        :param node_shape: The node_shape of this BrokerShape.
        :type: str
        """
        self._node_shape = node_shape

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
