# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttachmentSummary(object):
    """
    Description of Attachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AttachmentSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AttachmentSummary.
        :type id: str

        :param offer_id:
            The value to assign to the offer_id property of this AttachmentSummary.
        :type offer_id: str

        :param mime_type:
            The value to assign to the mime_type property of this AttachmentSummary.
        :type mime_type: str

        :param display_name:
            The value to assign to the display_name property of this AttachmentSummary.
        :type display_name: str

        :param type:
            The value to assign to the type property of this AttachmentSummary.
        :type type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AttachmentSummary.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AttachmentSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AttachmentSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'offer_id': 'str',
            'mime_type': 'str',
            'display_name': 'str',
            'type': 'str',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'offer_id': 'offerId',
            'mime_type': 'mimeType',
            'display_name': 'displayName',
            'type': 'type',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._id = None
        self._offer_id = None
        self._mime_type = None
        self._display_name = None
        self._type = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AttachmentSummary.
        Unique identifier that is immutable on creation


        :return: The id of this AttachmentSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AttachmentSummary.
        Unique identifier that is immutable on creation


        :param id: The id of this AttachmentSummary.
        :type: str
        """
        self._id = id

    @property
    def offer_id(self):
        """
        **[Required]** Gets the offer_id of this AttachmentSummary.
        Unique identifier of the associated offer that is immutable on creation


        :return: The offer_id of this AttachmentSummary.
        :rtype: str
        """
        return self._offer_id

    @offer_id.setter
    def offer_id(self, offer_id):
        """
        Sets the offer_id of this AttachmentSummary.
        Unique identifier of the associated offer that is immutable on creation


        :param offer_id: The offer_id of this AttachmentSummary.
        :type: str
        """
        self._offer_id = offer_id

    @property
    def mime_type(self):
        """
        Gets the mime_type of this AttachmentSummary.
        The MIME type of the uploaded data.


        :return: The mime_type of this AttachmentSummary.
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """
        Sets the mime_type of this AttachmentSummary.
        The MIME type of the uploaded data.


        :param mime_type: The mime_type of this AttachmentSummary.
        :type: str
        """
        self._mime_type = mime_type

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AttachmentSummary.
        The name used to refer to the uploaded data.


        :return: The display_name of this AttachmentSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AttachmentSummary.
        The name used to refer to the uploaded data.


        :param display_name: The display_name of this AttachmentSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this AttachmentSummary.
        The type of offer attachment.


        :return: The type of this AttachmentSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this AttachmentSummary.
        The type of offer attachment.


        :param type: The type of this AttachmentSummary.
        :type: str
        """
        self._type = type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AttachmentSummary.
        The current state of the Attachment.


        :return: The lifecycle_state of this AttachmentSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AttachmentSummary.
        The current state of the Attachment.


        :param lifecycle_state: The lifecycle_state of this AttachmentSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this AttachmentSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this AttachmentSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AttachmentSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this AttachmentSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this AttachmentSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this AttachmentSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AttachmentSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this AttachmentSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
