# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MachineImageDetails(object):
    """
    Machine image details.
    """

    #: A constant which can be used with the validation_status property of a MachineImageDetails.
    #: This constant has a value of "VALIDATION_IN_PROGRESS"
    VALIDATION_STATUS_VALIDATION_IN_PROGRESS = "VALIDATION_IN_PROGRESS"

    #: A constant which can be used with the validation_status property of a MachineImageDetails.
    #: This constant has a value of "VALIDATION_FAILED"
    VALIDATION_STATUS_VALIDATION_FAILED = "VALIDATION_FAILED"

    #: A constant which can be used with the validation_status property of a MachineImageDetails.
    #: This constant has a value of "VALIDATION_COMPLETED"
    VALIDATION_STATUS_VALIDATION_COMPLETED = "VALIDATION_COMPLETED"

    def __init__(self, **kwargs):
        """
        Initializes a new MachineImageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_image_id:
            The value to assign to the source_image_id property of this MachineImageDetails.
        :type source_image_id: str

        :param username:
            The value to assign to the username property of this MachineImageDetails.
        :type username: str

        :param is_snapshot_allowed:
            The value to assign to the is_snapshot_allowed property of this MachineImageDetails.
        :type is_snapshot_allowed: bool

        :param image_shape_compatibility_entries:
            The value to assign to the image_shape_compatibility_entries property of this MachineImageDetails.
        :type image_shape_compatibility_entries: list[oci.marketplace_publisher.models.ImageShapeCompatibility]

        :param validation_status:
            The value to assign to the validation_status property of this MachineImageDetails.
            Allowed values for this property are: "VALIDATION_IN_PROGRESS", "VALIDATION_FAILED", "VALIDATION_COMPLETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type validation_status: str

        :param validation_error:
            The value to assign to the validation_error property of this MachineImageDetails.
        :type validation_error: str

        """
        self.swagger_types = {
            'source_image_id': 'str',
            'username': 'str',
            'is_snapshot_allowed': 'bool',
            'image_shape_compatibility_entries': 'list[ImageShapeCompatibility]',
            'validation_status': 'str',
            'validation_error': 'str'
        }
        self.attribute_map = {
            'source_image_id': 'sourceImageId',
            'username': 'username',
            'is_snapshot_allowed': 'isSnapshotAllowed',
            'image_shape_compatibility_entries': 'imageShapeCompatibilityEntries',
            'validation_status': 'validationStatus',
            'validation_error': 'validationError'
        }
        self._source_image_id = None
        self._username = None
        self._is_snapshot_allowed = None
        self._image_shape_compatibility_entries = None
        self._validation_status = None
        self._validation_error = None

    @property
    def source_image_id(self):
        """
        **[Required]** Gets the source_image_id of this MachineImageDetails.
        The source image ocid of the machine image.


        :return: The source_image_id of this MachineImageDetails.
        :rtype: str
        """
        return self._source_image_id

    @source_image_id.setter
    def source_image_id(self, source_image_id):
        """
        Sets the source_image_id of this MachineImageDetails.
        The source image ocid of the machine image.


        :param source_image_id: The source_image_id of this MachineImageDetails.
        :type: str
        """
        self._source_image_id = source_image_id

    @property
    def username(self):
        """
        Gets the username of this MachineImageDetails.
        The username for machine image.


        :return: The username of this MachineImageDetails.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this MachineImageDetails.
        The username for machine image.


        :param username: The username of this MachineImageDetails.
        :type: str
        """
        self._username = username

    @property
    def is_snapshot_allowed(self):
        """
        **[Required]** Gets the is_snapshot_allowed of this MachineImageDetails.
        Identified if customer can take a snapshot of instance running on the machine image.


        :return: The is_snapshot_allowed of this MachineImageDetails.
        :rtype: bool
        """
        return self._is_snapshot_allowed

    @is_snapshot_allowed.setter
    def is_snapshot_allowed(self, is_snapshot_allowed):
        """
        Sets the is_snapshot_allowed of this MachineImageDetails.
        Identified if customer can take a snapshot of instance running on the machine image.


        :param is_snapshot_allowed: The is_snapshot_allowed of this MachineImageDetails.
        :type: bool
        """
        self._is_snapshot_allowed = is_snapshot_allowed

    @property
    def image_shape_compatibility_entries(self):
        """
        **[Required]** Gets the image_shape_compatibility_entries of this MachineImageDetails.
        List of shape configurations supported by the image.


        :return: The image_shape_compatibility_entries of this MachineImageDetails.
        :rtype: list[oci.marketplace_publisher.models.ImageShapeCompatibility]
        """
        return self._image_shape_compatibility_entries

    @image_shape_compatibility_entries.setter
    def image_shape_compatibility_entries(self, image_shape_compatibility_entries):
        """
        Sets the image_shape_compatibility_entries of this MachineImageDetails.
        List of shape configurations supported by the image.


        :param image_shape_compatibility_entries: The image_shape_compatibility_entries of this MachineImageDetails.
        :type: list[oci.marketplace_publisher.models.ImageShapeCompatibility]
        """
        self._image_shape_compatibility_entries = image_shape_compatibility_entries

    @property
    def validation_status(self):
        """
        **[Required]** Gets the validation_status of this MachineImageDetails.
        Image validation status.

        Allowed values for this property are: "VALIDATION_IN_PROGRESS", "VALIDATION_FAILED", "VALIDATION_COMPLETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The validation_status of this MachineImageDetails.
        :rtype: str
        """
        return self._validation_status

    @validation_status.setter
    def validation_status(self, validation_status):
        """
        Sets the validation_status of this MachineImageDetails.
        Image validation status.


        :param validation_status: The validation_status of this MachineImageDetails.
        :type: str
        """
        allowed_values = ["VALIDATION_IN_PROGRESS", "VALIDATION_FAILED", "VALIDATION_COMPLETED"]
        if not value_allowed_none_or_none_sentinel(validation_status, allowed_values):
            validation_status = 'UNKNOWN_ENUM_VALUE'
        self._validation_status = validation_status

    @property
    def validation_error(self):
        """
        Gets the validation_error of this MachineImageDetails.
        Description of image validation errors.


        :return: The validation_error of this MachineImageDetails.
        :rtype: str
        """
        return self._validation_error

    @validation_error.setter
    def validation_error(self, validation_error):
        """
        Sets the validation_error of this MachineImageDetails.
        Description of image validation errors.


        :param validation_error: The validation_error of this MachineImageDetails.
        :type: str
        """
        self._validation_error = validation_error

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
