# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StackArtifactDetails(object):
    """
    Stack details required to create a Stack artifact.
    """

    #: A constant which can be used with the validation_status property of a StackArtifactDetails.
    #: This constant has a value of "VALIDATION_IN_PROGRESS"
    VALIDATION_STATUS_VALIDATION_IN_PROGRESS = "VALIDATION_IN_PROGRESS"

    #: A constant which can be used with the validation_status property of a StackArtifactDetails.
    #: This constant has a value of "VALIDATION_FAILED"
    VALIDATION_STATUS_VALIDATION_FAILED = "VALIDATION_FAILED"

    #: A constant which can be used with the validation_status property of a StackArtifactDetails.
    #: This constant has a value of "VALIDATION_COMPLETED"
    VALIDATION_STATUS_VALIDATION_COMPLETED = "VALIDATION_COMPLETED"

    def __init__(self, **kwargs):
        """
        Initializes a new StackArtifactDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_stack_id:
            The value to assign to the source_stack_id property of this StackArtifactDetails.
        :type source_stack_id: str

        :param image_listing_ids:
            The value to assign to the image_listing_ids property of this StackArtifactDetails.
        :type image_listing_ids: list[str]

        :param validation_status:
            The value to assign to the validation_status property of this StackArtifactDetails.
            Allowed values for this property are: "VALIDATION_IN_PROGRESS", "VALIDATION_FAILED", "VALIDATION_COMPLETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type validation_status: str

        :param validation_error:
            The value to assign to the validation_error property of this StackArtifactDetails.
        :type validation_error: str

        """
        self.swagger_types = {
            'source_stack_id': 'str',
            'image_listing_ids': 'list[str]',
            'validation_status': 'str',
            'validation_error': 'str'
        }
        self.attribute_map = {
            'source_stack_id': 'sourceStackId',
            'image_listing_ids': 'imageListingIds',
            'validation_status': 'validationStatus',
            'validation_error': 'validationError'
        }
        self._source_stack_id = None
        self._image_listing_ids = None
        self._validation_status = None
        self._validation_error = None

    @property
    def source_stack_id(self):
        """
        **[Required]** Gets the source_stack_id of this StackArtifactDetails.
        The source stack OCID.


        :return: The source_stack_id of this StackArtifactDetails.
        :rtype: str
        """
        return self._source_stack_id

    @source_stack_id.setter
    def source_stack_id(self, source_stack_id):
        """
        Sets the source_stack_id of this StackArtifactDetails.
        The source stack OCID.


        :param source_stack_id: The source_stack_id of this StackArtifactDetails.
        :type: str
        """
        self._source_stack_id = source_stack_id

    @property
    def image_listing_ids(self):
        """
        Gets the image_listing_ids of this StackArtifactDetails.
        Image listing OCIDs that are referred in the Stack.


        :return: The image_listing_ids of this StackArtifactDetails.
        :rtype: list[str]
        """
        return self._image_listing_ids

    @image_listing_ids.setter
    def image_listing_ids(self, image_listing_ids):
        """
        Sets the image_listing_ids of this StackArtifactDetails.
        Image listing OCIDs that are referred in the Stack.


        :param image_listing_ids: The image_listing_ids of this StackArtifactDetails.
        :type: list[str]
        """
        self._image_listing_ids = image_listing_ids

    @property
    def validation_status(self):
        """
        **[Required]** Gets the validation_status of this StackArtifactDetails.
        Stack validation status.

        Allowed values for this property are: "VALIDATION_IN_PROGRESS", "VALIDATION_FAILED", "VALIDATION_COMPLETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The validation_status of this StackArtifactDetails.
        :rtype: str
        """
        return self._validation_status

    @validation_status.setter
    def validation_status(self, validation_status):
        """
        Sets the validation_status of this StackArtifactDetails.
        Stack validation status.


        :param validation_status: The validation_status of this StackArtifactDetails.
        :type: str
        """
        allowed_values = ["VALIDATION_IN_PROGRESS", "VALIDATION_FAILED", "VALIDATION_COMPLETED"]
        if not value_allowed_none_or_none_sentinel(validation_status, allowed_values):
            validation_status = 'UNKNOWN_ENUM_VALUE'
        self._validation_status = validation_status

    @property
    def validation_error(self):
        """
        Gets the validation_error of this StackArtifactDetails.
        The description of the stack validation failure errors.


        :return: The validation_error of this StackArtifactDetails.
        :rtype: str
        """
        return self._validation_error

    @validation_error.setter
    def validation_error(self, validation_error):
        """
        Sets the validation_error of this StackArtifactDetails.
        The description of the stack validation failure errors.


        :param validation_error: The validation_error of this StackArtifactDetails.
        :type: str
        """
        self._validation_error = validation_error

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
