# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MulticloudSubscriptionSummary(object):
    """
    Multicloud subscription object
    """

    #: A constant which can be used with the service_name property of a MulticloudSubscriptionSummary.
    #: This constant has a value of "ORACLEDBATAZURE"
    SERVICE_NAME_ORACLEDBATAZURE = "ORACLEDBATAZURE"

    #: A constant which can be used with the service_name property of a MulticloudSubscriptionSummary.
    #: This constant has a value of "ORACLEDBATGOOGLE"
    SERVICE_NAME_ORACLEDBATGOOGLE = "ORACLEDBATGOOGLE"

    #: A constant which can be used with the service_name property of a MulticloudSubscriptionSummary.
    #: This constant has a value of "ORACLEDBATAWS"
    SERVICE_NAME_ORACLEDBATAWS = "ORACLEDBATAWS"

    #: A constant which can be used with the lifecycle_state property of a MulticloudSubscriptionSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a MulticloudSubscriptionSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new MulticloudSubscriptionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param classic_subscription_id:
            The value to assign to the classic_subscription_id property of this MulticloudSubscriptionSummary.
        :type classic_subscription_id: str

        :param subscription_id:
            The value to assign to the subscription_id property of this MulticloudSubscriptionSummary.
        :type subscription_id: str

        :param partner_cloud_account_identifier:
            The value to assign to the partner_cloud_account_identifier property of this MulticloudSubscriptionSummary.
        :type partner_cloud_account_identifier: str

        :param service_name:
            The value to assign to the service_name property of this MulticloudSubscriptionSummary.
            Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type service_name: str

        :param time_linked_date:
            The value to assign to the time_linked_date property of this MulticloudSubscriptionSummary.
        :type time_linked_date: datetime

        :param payment_plan:
            The value to assign to the payment_plan property of this MulticloudSubscriptionSummary.
        :type payment_plan: str

        :param active_commitment:
            The value to assign to the active_commitment property of this MulticloudSubscriptionSummary.
        :type active_commitment: str

        :param time_end_date:
            The value to assign to the time_end_date property of this MulticloudSubscriptionSummary.
        :type time_end_date: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this MulticloudSubscriptionSummary.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param csp_additional_properties:
            The value to assign to the csp_additional_properties property of this MulticloudSubscriptionSummary.
        :type csp_additional_properties: dict(str, str)

        :param time_created:
            The value to assign to the time_created property of this MulticloudSubscriptionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this MulticloudSubscriptionSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this MulticloudSubscriptionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this MulticloudSubscriptionSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this MulticloudSubscriptionSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'classic_subscription_id': 'str',
            'subscription_id': 'str',
            'partner_cloud_account_identifier': 'str',
            'service_name': 'str',
            'time_linked_date': 'datetime',
            'payment_plan': 'str',
            'active_commitment': 'str',
            'time_end_date': 'datetime',
            'lifecycle_state': 'str',
            'csp_additional_properties': 'dict(str, str)',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'classic_subscription_id': 'classicSubscriptionId',
            'subscription_id': 'subscriptionId',
            'partner_cloud_account_identifier': 'partnerCloudAccountIdentifier',
            'service_name': 'serviceName',
            'time_linked_date': 'timeLinkedDate',
            'payment_plan': 'paymentPlan',
            'active_commitment': 'activeCommitment',
            'time_end_date': 'timeEndDate',
            'lifecycle_state': 'lifecycleState',
            'csp_additional_properties': 'cspAdditionalProperties',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._classic_subscription_id = None
        self._subscription_id = None
        self._partner_cloud_account_identifier = None
        self._service_name = None
        self._time_linked_date = None
        self._payment_plan = None
        self._active_commitment = None
        self._time_end_date = None
        self._lifecycle_state = None
        self._csp_additional_properties = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def classic_subscription_id(self):
        """
        **[Required]** Gets the classic_subscription_id of this MulticloudSubscriptionSummary.
        Subscription ID for OCI and Partner cloud in classic format.


        :return: The classic_subscription_id of this MulticloudSubscriptionSummary.
        :rtype: str
        """
        return self._classic_subscription_id

    @classic_subscription_id.setter
    def classic_subscription_id(self, classic_subscription_id):
        """
        Sets the classic_subscription_id of this MulticloudSubscriptionSummary.
        Subscription ID for OCI and Partner cloud in classic format.


        :param classic_subscription_id: The classic_subscription_id of this MulticloudSubscriptionSummary.
        :type: str
        """
        self._classic_subscription_id = classic_subscription_id

    @property
    def subscription_id(self):
        """
        Gets the subscription_id of this MulticloudSubscriptionSummary.
        URL to the subscription page https://{console-url}/org-mgmt/subscription/ocid1.organizationssubscription.oc1.iad.amaaaaaapf266qyaqohz27zvh45jzaielgwojo53bh24s7cy5q5g7fiknpxa?region=us-ashburn-1.


        :return: The subscription_id of this MulticloudSubscriptionSummary.
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """
        Sets the subscription_id of this MulticloudSubscriptionSummary.
        URL to the subscription page https://{console-url}/org-mgmt/subscription/ocid1.organizationssubscription.oc1.iad.amaaaaaapf266qyaqohz27zvh45jzaielgwojo53bh24s7cy5q5g7fiknpxa?region=us-ashburn-1.


        :param subscription_id: The subscription_id of this MulticloudSubscriptionSummary.
        :type: str
        """
        self._subscription_id = subscription_id

    @property
    def partner_cloud_account_identifier(self):
        """
        **[Required]** Gets the partner_cloud_account_identifier of this MulticloudSubscriptionSummary.
        The partner cloud account ID.


        :return: The partner_cloud_account_identifier of this MulticloudSubscriptionSummary.
        :rtype: str
        """
        return self._partner_cloud_account_identifier

    @partner_cloud_account_identifier.setter
    def partner_cloud_account_identifier(self, partner_cloud_account_identifier):
        """
        Sets the partner_cloud_account_identifier of this MulticloudSubscriptionSummary.
        The partner cloud account ID.


        :param partner_cloud_account_identifier: The partner_cloud_account_identifier of this MulticloudSubscriptionSummary.
        :type: str
        """
        self._partner_cloud_account_identifier = partner_cloud_account_identifier

    @property
    def service_name(self):
        """
        Gets the service_name of this MulticloudSubscriptionSummary.
        The serviceName that externalLocation map object belongs to.

        Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The service_name of this MulticloudSubscriptionSummary.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this MulticloudSubscriptionSummary.
        The serviceName that externalLocation map object belongs to.


        :param service_name: The service_name of this MulticloudSubscriptionSummary.
        :type: str
        """
        allowed_values = ["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]
        if not value_allowed_none_or_none_sentinel(service_name, allowed_values):
            service_name = 'UNKNOWN_ENUM_VALUE'
        self._service_name = service_name

    @property
    def time_linked_date(self):
        """
        Gets the time_linked_date of this MulticloudSubscriptionSummary.
        The date and time for when the multicloud was created, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_linked_date of this MulticloudSubscriptionSummary.
        :rtype: datetime
        """
        return self._time_linked_date

    @time_linked_date.setter
    def time_linked_date(self, time_linked_date):
        """
        Sets the time_linked_date of this MulticloudSubscriptionSummary.
        The date and time for when the multicloud was created, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_linked_date: The time_linked_date of this MulticloudSubscriptionSummary.
        :type: datetime
        """
        self._time_linked_date = time_linked_date

    @property
    def payment_plan(self):
        """
        Gets the payment_plan of this MulticloudSubscriptionSummary.
        Payment plan for the subscription.


        :return: The payment_plan of this MulticloudSubscriptionSummary.
        :rtype: str
        """
        return self._payment_plan

    @payment_plan.setter
    def payment_plan(self, payment_plan):
        """
        Sets the payment_plan of this MulticloudSubscriptionSummary.
        Payment plan for the subscription.


        :param payment_plan: The payment_plan of this MulticloudSubscriptionSummary.
        :type: str
        """
        self._payment_plan = payment_plan

    @property
    def active_commitment(self):
        """
        Gets the active_commitment of this MulticloudSubscriptionSummary.
        Total value for the subscription.


        :return: The active_commitment of this MulticloudSubscriptionSummary.
        :rtype: str
        """
        return self._active_commitment

    @active_commitment.setter
    def active_commitment(self, active_commitment):
        """
        Sets the active_commitment of this MulticloudSubscriptionSummary.
        Total value for the subscription.


        :param active_commitment: The active_commitment of this MulticloudSubscriptionSummary.
        :type: str
        """
        self._active_commitment = active_commitment

    @property
    def time_end_date(self):
        """
        Gets the time_end_date of this MulticloudSubscriptionSummary.
        The date and time for when the subscription is finishing, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_end_date of this MulticloudSubscriptionSummary.
        :rtype: datetime
        """
        return self._time_end_date

    @time_end_date.setter
    def time_end_date(self, time_end_date):
        """
        Sets the time_end_date of this MulticloudSubscriptionSummary.
        The date and time for when the subscription is finishing, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_end_date: The time_end_date of this MulticloudSubscriptionSummary.
        :type: datetime
        """
        self._time_end_date = time_end_date

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this MulticloudSubscriptionSummary.
        The current state of the subscription.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this MulticloudSubscriptionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this MulticloudSubscriptionSummary.
        The current state of the subscription.


        :param lifecycle_state: The lifecycle_state of this MulticloudSubscriptionSummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def csp_additional_properties(self):
        """
        Gets the csp_additional_properties of this MulticloudSubscriptionSummary.
        CSP Specific Additional Properties, AzureSubnetId for Azure


        :return: The csp_additional_properties of this MulticloudSubscriptionSummary.
        :rtype: dict(str, str)
        """
        return self._csp_additional_properties

    @csp_additional_properties.setter
    def csp_additional_properties(self, csp_additional_properties):
        """
        Sets the csp_additional_properties of this MulticloudSubscriptionSummary.
        CSP Specific Additional Properties, AzureSubnetId for Azure


        :param csp_additional_properties: The csp_additional_properties of this MulticloudSubscriptionSummary.
        :type: dict(str, str)
        """
        self._csp_additional_properties = csp_additional_properties

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MulticloudSubscriptionSummary.
        The date and time the subscription was created, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this MulticloudSubscriptionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MulticloudSubscriptionSummary.
        The date and time the subscription was created, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this MulticloudSubscriptionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this MulticloudSubscriptionSummary.
        The date and time the subscription was updated, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this MulticloudSubscriptionSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this MulticloudSubscriptionSummary.
        The date and time the subscription was updated, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this MulticloudSubscriptionSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this MulticloudSubscriptionSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this MulticloudSubscriptionSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this MulticloudSubscriptionSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this MulticloudSubscriptionSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this MulticloudSubscriptionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this MulticloudSubscriptionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this MulticloudSubscriptionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this MulticloudSubscriptionSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this MulticloudSubscriptionSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this MulticloudSubscriptionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this MulticloudSubscriptionSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this MulticloudSubscriptionSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
